#ifndef __INCLUDED_DIA_COMMON_SYSSET__
#define __INCLUDED_DIA_COMMON_SYSSET__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

enum dia_enSystemSettingLevel
{
   DIA_EN_SYSTEM_SETTING_LEVEL_UNKNOWN = 0,
   DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE,
   DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE,
   DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE,
   DIA_EN_SYSTEM_SETTING_LEVEL_COUNT
};

enum dia_enSystemSettingMode
{
   DIA_EN_SYSTEM_SETTING_MODE_UNKNOWN = 0,
   DIA_EN_SYSTEM_SETTING_MODE_MASTER,
   DIA_EN_SYSTEM_SETTING_MODE_SLAVE,
   DIA_EN_SYSTEM_SETTING_MODE_COUNT
};

typedef tU8 dia_SysSettingTypeInfo;

struct dia_SystemSettingExtDataElem
{
   dia_SystemSettingExtDataElem ( void ) : mTypeInfo(0) {}
   dia_SystemSettingExtDataElem ( dia_SysSettingTypeInfo typeInfo, const std::vector<tU8>& data ) : mTypeInfo(typeInfo), mData(data) {}
   dia_SystemSettingExtDataElem ( const dia_SystemSettingExtDataElem& obj ) : mTypeInfo(obj.mTypeInfo), mData(obj.mData) {}
   dia_SystemSettingExtDataElem& operator = ( const dia_SystemSettingExtDataElem& obj ) {
      if ( this != &obj ) {
         mTypeInfo = obj.mTypeInfo;
         mData = obj.mData;
      }
      return *this;
   }
   virtual ~dia_SystemSettingExtDataElem ( void ) {}

   dia_SysSettingTypeInfo mTypeInfo;
   std::vector<tU8> mData;
};

typedef std::vector<dia_SystemSettingExtDataElem> dia_SystemSettingExtendedData;

#endif
