/**
 * \file       dia_SystemSetPluginPM.h
 *
 * \brief      Abstract base class for all kinds of diagnosis internal system setting plugins.
 *
 * \details    Class dia_SystemSetPluginPM is the abstract base class for all kinds of diagnosis
 *             internal system setting plugins. In contrast to system setting modules the
 *             methods called on system setting plugins are processed in a synchronous way, so
 *             no interaction with other applications is involved, except of drivers or platform
 *             components like the authorization level daemon. In each system setting level
 *             (prepare, execute and finalize) system setting plugins are always processed before
 *             any system setting module is processed.
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreSystemSettings
 *
 * \copyright  (c) 2015 Robert Bosch Car Multimedia
 *
 */

#ifndef __INCLUDED_DIA_SYSTEMSET_PLUGIN_PM__
#define __INCLUDED_DIA_SYSTEMSET_PLUGIN_PM__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_PLUGIN__
#include <common/framework/sysset/dia_SystemSettingsPlugin.h>
#endif

class dia_SystemSetPluginPM
   : public dia_SystemSettingsPlugin
{
public:
   //! default class constructor
   dia_SystemSetPluginPM ( tU32 u32DpTimeout = 5000 );
   //! class destructor
   virtual ~dia_SystemSetPluginPM ( void );

   //! prepare the module for the system setting
   virtual tDiaResult prepare ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData );
   //! execute the system setting
   virtual tDiaResult execute ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData );
   //! finalize the system setting
   virtual tDiaResult finalize ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData );

protected:
   //!
   tDiaResult lockMaster ( dia_UID sysSetTypeUID ) const;
   //!
   tDiaResult lockDefaults ( dia_UID sysSetTypeUID );

   //virtual bool isSystemSettingTypeSupported ( dia_UID typeUID );

protected:
   //! mapping table for defset types
   std::map<dia_UID,tU32> mTypeMapping;
   tU32 mDpTimeout;
};

#endif /* __INCLUDED_DIA_SYSTEMSET_PLUGIN_PM__ */
