/*
 * dia_SystemSetPluginPM.cpp
 *
 *  Created on: 16.11.2012
 *      Author: gib2hi
 */

#include "dia_SystemSetPluginPM.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

//#define __ENABLE_FEATURE_SYSSET_PLUGIN_PM_IGNORE_DP_RETVALS__

#define DIA_C_U32_DP_DEFSET_NOT_SUPPORTED       ((tU32) 0xFFFFFFFF)

//-----------------------------------------------------------------------------

dia_SystemSetPluginPM::dia_SystemSetPluginPM ( tU32 u32DpTimeout )
   : dia_SystemSettingsPlugin("dia_SystemSetPluginPM",DIA_EN_SYSSET_PLUGIN_ID_PM_DATAPOOL),
     mDpTimeout(u32DpTimeout)
{
   mTypeMapping[DIA_C_UID_SYSTEM_SETTING_TYPE_HMI]                 = DP_DEFSET_USER;
   mTypeMapping[DIA_C_UID_SYSTEM_SETTING_TYPE_PRODUCTION]          = DP_DEFSET_TEF;
   mTypeMapping[DIA_C_UID_SYSTEM_SETTING_TYPE_ALIGNMENT]           = DIA_C_U32_DP_DEFSET_NOT_SUPPORTED;
   mTypeMapping[DIA_C_UID_SYSTEM_SETTING_TYPE_CALIBRATION]         = DIA_C_U32_DP_DEFSET_NOT_SUPPORTED;
   mTypeMapping[DIA_C_UID_SYSTEM_SETTING_TYPE_CUSTOMER]            = DP_DEFSET_CUSTOMER;
   mTypeMapping[DIA_C_UID_SYSTEM_SETTING_TYPE_USRMGMT_RESET_ALL]   = DIA_C_U32_DP_DEFSET_NOT_SUPPORTED;
   mTypeMapping[DIA_C_UID_SYSTEM_SETTING_TYPE_USRMGMT_RESET_USER]  = DIA_C_U32_DP_DEFSET_NOT_SUPPORTED;
   mTypeMapping[DIA_C_UID_SYSTEM_SETTING_TYPE_USRMGMT_RESET_BANK]  = DIA_C_U32_DP_DEFSET_NOT_SUPPORTED;
   mTypeMapping[DIA_C_UID_SYSTEM_SETTING_TYPE_USRMGMT_SWITCH_USER] = DIA_C_U32_DP_DEFSET_NOT_SUPPORTED;
   mTypeMapping[DIA_C_UID_SYSTEM_SETTING_TYPE_USRMGMT_SWITCH_BANK] = DIA_C_U32_DP_DEFSET_NOT_SUPPORTED;

   std::map<dia_UID,tU32>::iterator iter = mTypeMapping.begin();

   for ( ; iter != mTypeMapping.end(); iter++ )
   {
      if ( iter->second != DIA_C_U32_DP_DEFSET_NOT_SUPPORTED)
      {
         DIA_TR_INF("# dia_SystemSetPluginPM::dia_SystemSetPluginPM(): add supported typeID = 0x%08x", iter->first);

         addSupportedSysSetType(iter->first);
      }
   }
}

//-----------------------------------------------------------------------------

dia_SystemSetPluginPM::~dia_SystemSetPluginPM ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SystemSetPluginPM::prepare ( dia_UID /*sysSetTypeUID*/, const dia_SystemSettingExtendedData& /*extData*/ )
{
   dia_tclFnctTrace oTrace("dia_SystemSetPluginPM::prepare()");

   // This will be checked in sysset framework
//   if ( !isSystemSettingTypeSupported(sysSetTypeUID) )
//   {
//      DIA_TR_INF("# dia_SystemSetPluginPM::prepare(): NOTHING TO BE DONE FOR sysSetTypeUID = 0x%08x", sysSetTypeUID);
//      // nothing to do for this defset type
//      return DIA_SUCCESS;
//   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SystemSetPluginPM::execute ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& /*extData*/ )
{
   dia_tclFnctTrace oTrace("dia_SystemSetPluginPM::execute()");

   // This will be checked in sysset framework
//   if ( !isSystemSettingTypeSupported(sysSetTypeUID) )
//   {
//      DIA_TR_INF("# dia_SystemSetPluginPM::execute(): NOTHING TO BE DONE FOR sysSetTypeUID = 0x%08x", sysSetTypeUID);
//      // nothing to do for this defset type
//      return DIA_SUCCESS;
//   }

   tDiaResult retCode = lockMaster(sysSetTypeUID);

   if ( retCode == DIA_SUCCESS )
   {
      retCode = lockDefaults(sysSetTypeUID);
   }
   else
   {
      DIA_TR_ERR("dia_SystemSetPluginPM: Locking Datapool (MASTER) Failed (ERR=0x%08x)!!", retCode);
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SystemSetPluginPM::finalize ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& /*extData*/ )
{
   dia_tclFnctTrace oTrace("dia_SystemSetPluginPM::finalize()");

   tDiaResult retCode = DIA_FAILED;

   // This will be checked in sysset framework
//   if ( !isSystemSettingTypeSupported(sysSetTypeUID) )
//   {
//      DIA_TR_INF("# dia_SystemSetPluginPM::finalize(): NOTHING TO BE DONE FOR sysSetTypeUID = 0x%08x", sysSetTypeUID);
//      // nothing to do for this defset type
//      return DIA_SUCCESS;
//   }

   DIA_TR_INF("###############################################");
   DIA_TR_INF("# dia_SystemSetPluginPM: Lock Datapool (MASTER)");
   DIA_TR_INF("###############################################");

   dp_tclSrvIf dp;

#ifdef __ENABLE_FEATURE_SYSSET_PLUGIN_PM_IGNORE_DP_RETVALS__
   // lock datapool
   (tVoid) dp.s32Lock(DP_U32_LOCK_MODE_MASTER, mDpTimeout);

   DIA_TR_INF("###############################################");
   DIA_TR_INF("# dia_SystemSetPluginPM: Store Datapool");
   DIA_TR_INF("###############################################");

   // store datapool contents
   (tVoid) dp.s32StoreNow(mDpTimeout);

   if ( sysSetTypeUID == DIA_C_UID_SYSTEM_SETTING_TYPE_HMI )
   {
      DIA_TR_INF("###############################################");
      DIA_TR_INF("# dia_SystemSetPluginPM: Unlock Datapool");
      DIA_TR_INF("###############################################");

      (tVoid) dp.s32Unlock(mDpTimeout);
   }

   DIA_TR_INF("########################################################################");
   DIA_TR_INF("# dia_SystemSetPluginPM: TEMPORARILY FORCING POSITIVE RETURN CODE !!!");
   DIA_TR_INF("########################################################################");
   retCode = DIA_SUCCESS;

#else

   // lock datapool
   tS32 result = dp.s32Lock(DP_U32_LOCK_MODE_MASTER, mDpTimeout);

   // check if locking succeeded
   if ( result == DP_S32_NO_ERR )
   {
      DIA_TR_INF("###############################################");
      DIA_TR_INF("# dia_SystemSetPluginPM: Store Datapool");
      DIA_TR_INF("###############################################");

      // store datapool contents
      result = dp.s32StoreNow(mDpTimeout);

      // check if storing was successful
      if ( result == DP_S32_NO_ERR )
      {
         if ( sysSetTypeUID == DIA_C_UID_SYSTEM_SETTING_TYPE_HMI )
         {
            DIA_TR_INF("###############################################");
            DIA_TR_INF("# dia_SystemSetPluginPM: Unlock Datapool");
            DIA_TR_INF("###############################################");

            result = dp.s32Unlock(mDpTimeout);

            // check if unlocking succeeded
            if ( result == DP_S32_NO_ERR )
            {
               retCode = DIA_SUCCESS;
            }
            else
            {
               DIA_TR_ERR("dia_SystemSetPluginPM: Unlocking Datapool Failed (ERR=%d)!!", result);
            }
         }
         else
         {
            retCode = DIA_SUCCESS;
         }
      }
      else
      {
         DIA_TR_ERR("dia_SystemSetPluginPM: Locking Datapool (MASTER) Failed (ERR=%d)!!", result);
      }
   }
   else
   {
      DIA_TR_ERR("dia_SystemSetPluginPM: Set Datapool to Defaults (TYPE=0x%08x) Failed (ERR=%d)!!", sysSetTypeUID, result);
   }
#endif

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SystemSetPluginPM::lockMaster ( dia_UID /*sysSetTypeUID*/ ) const
{
   dia_tclFnctTrace oTrace("dia_SystemSetPluginPM::lockMaster()");

   tDiaResult retCode = DIA_FAILED;

   DIA_TR_INF("###############################################");
   DIA_TR_INF("# dia_SystemSetPluginPM: Lock Datapool (MASTER)");
   DIA_TR_INF("###############################################");

   dp_tclSrvIf dp;

#ifdef __ENABLE_FEATURE_SYSSET_PLUGIN_PM_IGNORE_DP_RETVALS__

   // lock datapool
   (tVoid) dp.s32Lock(DP_U32_LOCK_MODE_MASTER, mDpTimeout);

   DIA_TR_INF("########################################################################");
   DIA_TR_INF("# dia_SystemSetPluginPM: TEMPORARILY FORCING POSITIVE RETURN CODE !!!");
   DIA_TR_INF("########################################################################");
   return DIA_SUCCESS;

#else

   // lock datapool
   tS32 result = dp.s32Lock(DP_U32_LOCK_MODE_MASTER, mDpTimeout);

   // check if locking succeeded
   if ( result == DP_S32_NO_ERR )
   {
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_ERR("dia_SystemSetPluginPM: Locking Datapool (MASTER) Failed (ERR=%d)!!", result);
   }

   return retCode;
#endif
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SystemSetPluginPM::lockDefaults ( dia_UID sysSetTypeUID )
{
   dia_tclFnctTrace oTrace("dia_SystemSetPluginPM::lockDefaults()");

   tDiaResult retCode = DIA_FAILED;

   DIA_TR_INF("###############################################");
   DIA_TR_INF("# dia_SystemSetPluginPM: Datapool->SetDefaults ");
   DIA_TR_INF("###############################################");

   dp_tclSrvIf dp;

#ifdef __ENABLE_FEATURE_SYSSET_PLUGIN_PM_IGNORE_DP_RETVALS__
   // set datapool to defaults
   (tVoid) dp.s32SetDefault(mTypeMapping[sysSetTypeUID], mDpTimeout);

   DIA_TR_INF("###############################################");
   DIA_TR_INF("# dia_SystemSetPluginPM: Lock Datapool (SETDEF)");
   DIA_TR_INF("###############################################");

   // setting to defaults succeeded now change the lock level
   (tVoid) dp.s32Lock(DP_U32_LOCK_MODE_SETDEF, mDpTimeout);

   DIA_TR_INF("########################################################################");
   DIA_TR_INF("# dia_SystemSetPluginPM: TEMPORARILY FORCING POSITIVE RETURN CODE !!!");
   DIA_TR_INF("########################################################################");

   return DIA_SUCCESS;

#else

   // set datapool to defaults
   tS32 result = dp.s32SetDefault(mTypeMapping[sysSetTypeUID], mDpTimeout);

   // check if setDefault succeeded
   if ( result == DP_S32_NO_ERR )
   {
      DIA_TR_INF("###############################################");
      DIA_TR_INF("# dia_SystemSetPluginPM: Lock Datapool (SETDEF)");
      DIA_TR_INF("###############################################");

      // setting to defaults succeeded now change the lock level
      result = dp.s32Lock(DP_U32_LOCK_MODE_SETDEF, mDpTimeout);

      // check if locking succeeded
      if ( result == DP_S32_NO_ERR )
      {
         retCode = DIA_SUCCESS;
      }
      else
      {
         DIA_TR_ERR("dia_SystemSetPluginPM: Locking Datapool (SETDEF) Failed (ERR=%d)!!", result);
      }
   }
   else
   {
      DIA_TR_ERR("dia_SystemSetPluginPM: Set Datapool to Defaults (TYPE=%d) Failed (ERR=%d)!!", mTypeMapping[sysSetTypeUID], result);
   }

   return retCode;
#endif
}

//-----------------------------------------------------------------------------

//bool
//dia_SystemSetPluginPM::isSystemSettingTypeSupported ( dia_UID typeUID )
//{
//   std::map<dia_UID,tU32>::iterator iter = mTypeMapping.find(typeUID);
//   if ( iter != mTypeMapping.end() )
//   {
//      return ( iter->second != DIA_C_U32_DP_DEFSET_NOT_SUPPORTED) ? true : false;
//   }
//   return false;
//}
