/*
 * dia_SystemSetPluginFileDeletion.cpp
 *
 *  Created on: 01.03.2016
 *      Author: bsu9kor
 */

#ifndef __INCLUDED_DIA_COMMON_CONFIG__
#include "common/framework/config/dia_common_config.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEMSET_PLUGIN_FILE_DELETION__
#include "common/framework/sysset/dia_SystemSetPluginFileDeletion.h"
#endif

#ifndef __INCLUDED_DIA_FILE__
#include "common/framework/application/dia_File.h"
#endif

//-----------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    dia_SystemSetPluginFileDeletion (Class constructor)
*
* DESCRIPTION: Specifies the Plugin ID.
*
* PARAMETER:   void
*
* RETURNVALUE: NA
*
******************************************************************************/
dia_SystemSetPluginFileDeletion::dia_SystemSetPluginFileDeletion ( void )
   : dia_SystemSettingsPlugin("dia_SystemSetPluginFileDeletion")
{
   dia_tclFnctTrace oTrace("dia_SystemSetPluginFileDeletion::dia_SystemSetPluginFileDeletion()");

   addSupportedSysSetType(DIA_C_UID_SYSTEM_SETTING_TYPE_PRODUCTION);
}

//-----------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    dia_SystemSetPluginFileDeletion (Class destructor)
*
* DESCRIPTION: -
*
* PARAMETER:   void
*
* RETURNVALUE: NA
*
******************************************************************************/
dia_SystemSetPluginFileDeletion::~dia_SystemSetPluginFileDeletion ( void )
{
}
//-----------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    prepare
*
* DESCRIPTION: prepare for the upcoming system setting
*
* PARAMETER:   Unique ID
*
* RETURNVALUE: Success
*
******************************************************************************/
tDiaResult
dia_SystemSetPluginFileDeletion::prepare (  dia_UID /*sysSetTypeUID*/ )
{
   dia_tclFnctTrace oTrace("dia_SystemSetPluginFileDeletion::prepare()");
   return DIA_SUCCESS;
}
//------------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    prepare
*
* DESCRIPTION:  perform the system set operation
*
* PARAMETER:   Unique ID
*
* RETURNVALUE: Success - if file exists and deletion is successful
* 			   failure - if file deletion is not successful
*
******************************************************************************/
tDiaResult
dia_SystemSetPluginFileDeletion::execute (  dia_UID sysSetTypeUID )
{
   dia_tclFnctTrace oTrace("dia_SystemSetPluginFileDeletion::execute()");
   DIA_TR_INF("dia_SystemSetPluginFileDeletion::execute() sysSetTypeUID = 0x%08x", sysSetTypeUID);
//   if ( sysSetTypeUID == DIA_C_UID_SYSTEM_SETTING_TYPE_PRODUCTION )
//   {
	   tU16 filecount = 0;
	   DIA_TR_INF("No of files to be checked and deleted = %zu", lFileList.size());
	   std::list<tCString>::iterator it = lFileList.begin();
	   for(;it != lFileList.end(); ++it)
	   {
		   DIA_TR_INF("FILE = %s", *it);
		   tCString name = *it;
		   dia_File FlagFile(name);
		   if (DIA_SUCCESS == FlagFile.open("r"))	//check if file exists
		   {
			   ++filecount;
			   FlagFile.close();
			   DIA_TR_INF("dia_SystemSetPluginFileDeletion:FILE %s EXISTS--Remove it",name);
			   if(FlagFile.remove()== DIA_SUCCESS)
			   {
				   DIA_TR_INF("dia_SystemSetPluginFileDeletion:FILE %s DELETION SUCCESS",name);
			   }
			   else
			   {
				   DIA_TR_INF("dia_SystemSetPluginFileDeletion:FILE %s DELETION FAILED",name);
				   return DIA_FAILED;
			   }
		   }
		   else
		   {
			 DIA_TR_INF("dia_SystemSetPluginFileDeletion:FILE %s DOES NOT EXISTS--Cannot Remove it",name);
		   }
		}
	   DIA_TR_INF("No of files found = %d",filecount);
	   if( filecount <= lFileList.size())
	   {
		   return DIA_SUCCESS;
	   }
	   else
	   {
		   DIA_TR_INF("dia_SystemSetPluginFileDeletion::execute-Some files could not be deleted");
		  return DIA_FAILED;
	   }
//   }
//   else
//   {
//	   DIA_TR_INF("# dia_SystemSetPluginFileDeletion::execute(): NOTHING TO BE DONE FOR sysSetTypeUID = 0x%08x", sysSetTypeUID);
//	   return DIA_SUCCESS;
//   }

}
//------------------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    finalize
*
* DESCRIPTION: finalize the system set operation
*
* PARAMETER:   Unique ID
*
* RETURNVALUE: Success
*
******************************************************************************/
tDiaResult
dia_SystemSetPluginFileDeletion::finalize (  dia_UID /*sysSetTypeUID*/ )
{
	   dia_tclFnctTrace oTrace("dia_SystemSetPluginFileDeletion::finalize()");
	   return DIA_SUCCESS;
}
//--------------------------------------------------------------------------------------

/******************************************************************************
* FUNCTION:    addFile
*
* DESCRIPTION: add file name to repository of filelist to be deleted on startup
*
* PARAMETER:   const dia_SystemSetPluginFileDeletionTEF arNames[] : array containing file names ,const tU16 size: Size of the array
*
* RETURNVALUE: void
*
******************************************************************************/
void
dia_SystemSetPluginFileDeletion::addFile(const dia_SystemSetPluginFileDeletionTEF arNames[], const tU16 size)
{
	dia_tclFnctTrace oTrace("dia_SystemSetPluginFileDeletion::addFile()");
	for(tU16 i=0; i < size ; i++)
		{
			tCString name;
			name = arNames[i].name;
			lFileList.push_back(name);
		}
	DIA_TR_INF("No of files added = %zu", lFileList.size());
}
