/**
 * \file      dia_SystemAdapterServicePluginDiaglib.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      14.01.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN_DIAGLIB__
#include "common/framework/sysadapters/dia_SystemAdapterServicePluginDiaglib.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_DIAGLIB__
#include "dia_SystemAdapterFeatureDiaglib.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
#include "project/framework/sysadapters/dia_SAFeatureDiaglib.h"
#endif

//-----------------------------------------------------------------------------

dia_SystemAdapterServicePluginDiaglib::dia_SystemAdapterServicePluginDiaglib (
      tCString name,        // name used to create name for lock and condvar object (in future!!)
      tU16 srvMajVersion,   // major version number of the service
      tU16 srvMinVersion,   // minor version number of the service
      dia_SystemAdapter& adapter
   )
   : dia_SystemAdapterServicePlugin(name,CCA_C_U16_SRV_DIAGLIB,srvMajVersion,srvMinVersion,adapter)
{
}

//----------------------------------------------------------------------------------------

dia_SystemAdapterServicePluginDiaglib::~dia_SystemAdapterServicePluginDiaglib ( tVoid )
{
   _BP_TRY_BEGIN
   {
      mFeatureDiaglibRep.clear();
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_SystemAdapterServicePluginDiaglib::~dia_SystemAdapterServicePluginDiaglib !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SystemAdapterServicePluginDiaglib::addFeature ( dia_SystemAdapterFeature& feature )
{
   dia_tclFnctTrace oTrace("dia_SystemAdapterServicePluginDiaglib::addFeature");

   if ( feature.getFeatureType() != DIA_EN_SAFEATURE_TYPE_DIAGLIB )
   {
      return DIA_FAILED;
   }

   // here we know that we can cast without problems
   dia_SystemAdapterFeatureDiaglib& diaglibFeature = (dia_SystemAdapterFeatureDiaglib&) feature;

   std::list<tU32> supportedDiaglibIDs;
   diaglibFeature.getDiaglibIDs(supportedDiaglibIDs);
   for ( std::list<tU32>::iterator iter = supportedDiaglibIDs.begin(); iter != supportedDiaglibIDs.end(); ++iter )
   {
      mFeatureDiaglibRep[*iter] = &diaglibFeature;
   }

   std::list<dia_SystemAdapterFeature*>::iterator objIter = std::find(mFeatureRep.begin(),mFeatureRep.end(),&feature);
   if ( objIter == mFeatureRep.end() )
   {
      mFeatureRep.push_back(&feature);
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SystemAdapterServicePluginDiaglib::dispatchMessage ( amt_tclBaseMessage *pMessage )
{
   dia_tclFnctTrace oTrace("dia_SystemAdapterServicePluginDiaglib::vDispatchMessage");

   tDiaResult retCode = DIA_FAILED;

   // check if the received message is a AMT Service data message
   if ( pMessage->u8GetType() == AMT_C_U8_CCAMSGTYPE_SVCDATA )
   {
      // cast the received message to a AMT Service data message so we can
      // access the standard members
      amt_tclServiceData oServiceData(pMessage);

      if ( dia_SAFeatureDiaglib::isDiaglibMessage(&oServiceData) == TRUE )
      {
         tU32 diaglibID = dia_SAFeatureDiaglib::getDiaglibID(&oServiceData);

         std::map<tU32,dia_SystemAdapterFeatureDiaglib*>::iterator iter =  mFeatureDiaglibRep.find(diaglibID);
         if ( iter != mFeatureDiaglibRep.end() )
         {
            dia_SystemAdapterFeatureDiaglib* pFeature = iter->second;
            if ( pFeature )
            {
               retCode = pFeature->dispatchMessage(pMessage);
            }
         }
      }
   }

   return retCode;
}

