/*
 * dia_SystemAdapterServicePlugin.h
 *
 *  Created on: 25.08.2011
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN__
#define __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN__

//
// includes
//

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_LOCK__
#include <common/framework/application/dia_Lock.h>
#endif

#ifndef __INCLUDED_DIA_CONDVAR__
#include <common/framework/application/dia_CondVar.h>
#endif

#ifndef __INCLUDED_DIA_FUNCTOR__
#include <common/framework/application/dia_Functor.h>
#endif

class dia_SystemAdapter;
class dia_SystemAdapterFeature;
class amt_tclBaseMessage;
class amt_tclServiceData;
class fi_tclVisitorMessage;

//----------------------------------------------------------------------------------------

class dia_SystemAdapterServicePlugin
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SystemAdapterServicePlugin);

public:
   //! default constructor
   dia_SystemAdapterServicePlugin (
         tCString name,        // name used to create name for lock and condvar object
         tU16 srvID,           // service of the client we are using
         tU16 srvMajVersion,   // major version number of the service
         tU16 srvMinVersion,   // minor version number of the service
         dia_SystemAdapter& adapter
   );

   //! class destructor
   virtual ~dia_SystemAdapterServicePlugin ( void );

   //! add a new feature to this service plugin
   virtual tDiaResult addFeature ( dia_SystemAdapterFeature& feature );

   //! the state of the service handled by this plugin has been changed
   void vOnServiceState ( tU16 u16SrvID, tU16 u16AppID, tU16 u16RegID, tU8 u8SrvState, tU16 u16SubId);

   //! handle an incoming message
   virtual tDiaResult dispatchMessage ( amt_tclBaseMessage *pBaseMessage );

   //! send a message to the client application
   virtual tBool bTransmitMessage ( amt_tclServiceData* poMessage );

   //! Initializes ServiceData with useful default values + given parameters
   virtual void vInitServiceData ( fi_tclVisitorMessage& oMsg, tU16 u16FuncId, tU8 u8OpCode, tU16 u16CmdCounter=0 );

   //! register for a function of the service
   virtual tBool bRegisterForFID ( tU16 u16FID );
   //! unregister for a function of the service
   virtual tBool bUnregisterForFID ( tU16 u16FID );

   //! register all services controlled by this system adapter
   tDiaResult registerService ( void );
   //! unregister all services controlled by this system adapter
   tDiaResult unregisterService ( void );
   //!
   virtual tDiaResult onServiceRegistered ( tU16 regID, tU16 srcSubID );

   tU16 getServiceID ( void ) const { return mServiceID; }
   tU16 getRegistrationID ( void );
   tU16 getClientID ( void ) const;

   //! check if an application state change is requested and all conditions are fulfilled
   bool isRegistrationInProgress ( void ) const;

   //! reset service connection. Sets class to known state
   void resetConnection ( void );

   void onServiceStateChanged ( tU8 u8ServiceState, tU16 u16SubId );

   // helper methods used to customize the condition variable
   void setCondVarRetries ( tU16 retries ) { mCondVarRetries = retries; }
   void setCondVarTimeout ( tU16 msecs ) { mConditionTimeout = msecs; }
   void setCondVarMask ( tU32 bitmask ) { mConditionMask = bitmask; }

   void vOnErrorMessage ( amt_tclServiceData* poMessage ) const;

   bool getBlockingMode ( void ) const { return mBlockingMode; }
   void setBlockingMode ( bool newMode ) { mBlockingMode = newMode; }

   void onStopSending ( void ) { mCondVar.broadcast(); }
   void onResumeSending ( void ) { mCondVar.resetBroadcast(); }

   //! executes a functor based on the service availability predicate
   virtual tDiaResult executeServiceFunctor(std::unique_ptr<dia_Functor> pFunctor);

protected:
   //! deprecated default constructor
   dia_SystemAdapterServicePlugin ( void );

   //! give subclasses a chance to handle service state changes in their own way
   virtual tBool bOnServiceStateAvailable ( tU16 u16SrvID, tU16 u16SubId );
   virtual void vOnServiceStateNotAvailable ( tU16 u16SrvID, tU16 u16SubId );

protected:
   //! some flags to identify which activity is pending
   bool  mIsRegistrationInProgress;
   //! flag to control if messages can be sent to other applications or not
   bool  mBlockingMode;

   //! pointer to the owner of this plugin
   dia_SystemAdapter* mpAdapter;

   // synchronization lock object.
   dia_Lock mSyncObj;
   // synchronization condition variable
   dia_CondVar mCondVar;
   //! number of condition variable monitored send retries
   tU16   mCondVarRetries;
   //! condition variable timeout value
   tU16   mConditionTimeout;
   //! condition bitmask monitiored by the condition variable
   tU32   mConditionMask;

   // to store the RegID of the service
   tU16  _u16RegID;
   tBool _bFidReg;
   tU16  _u16ServiceId;
   tU16  _u16SourceSubID;

   //! application ID of the concrete client handler
   tU16  mClientAppID;
   tU16  mServiceID;
   tU16  mServiceMajorVersion;
   tU16  mServiceMinorVersion;

   //! map used to bind function IDs to feature objects
   std::map<tU16,dia_SystemAdapterFeature*> mFunctionMapping;
   //! list of feature object attached to this service plugin
   std::list<dia_SystemAdapterFeature*> mFeatureRep;
};

#endif /* __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN__ */
