/*
 * dia_SystemAdapterFeature.h
 *
 *  Created on: 25.08.2011
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__
#define __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER__
#include <common/framework/sysadapters/dia_SystemAdapter.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN__
#include <common/framework/sysadapters/dia_SystemAdapterServicePlugin.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include <common/framework/sysadapters/dia_SystemAdapterFacade.h>
#endif

#ifndef __DIA_UNIT_TESTING__
#define MIDW_FI_S_IMPORT_INTERFACE_FI_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#endif

enum dia_enSAFeatureType
{
   DIA_EN_SAFEATURE_TYPE_UNKNOWN = 0,
   DIA_EN_SAFEATURE_TYPE_UNSPECIFIED,
   DIA_EN_SAFEATURE_TYPE_DIAGLIB,
   DIA_EN_SAFEATURE_TYPE_COUNT
};

//----------------------------------------------------------------------------------------

class dia_SystemAdapterFeature
#ifndef __DIA_UNIT_TESTING__
   : public ahl_tclBaseWork
#endif
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SystemAdapterFeature);

   friend class dia_SystemAdapterServicePlugin;

public:
   //! default constructor
   dia_SystemAdapterFeature (
         tCString name, // feature name
         dia_SystemAdapterServicePlugin& pSrvPlugin,
         dia_enSAFeatureType type = DIA_EN_SAFEATURE_TYPE_UNSPECIFIED
   );

   //! class destructor
   virtual ~dia_SystemAdapterFeature ( void );

   //! Dispatcher for messages - call this function if there's a new message to dispatch
   virtual tDiaResult dispatchMessage (amt_tclBaseMessage *pBaseMessage);

   //! register for a function of the service
   virtual tDiaResult registerFunction ( tU16 u16FID );
   //! unregister for a function of the service
   virtual tDiaResult unregisterFunction ( tU16 u16FID );

   //! retrieve the list of all function IDs handled by the feature
   dia_enSAFeatureType getFeatureType ( void ) const { return mType; }
   //! retrieve the list of all function IDs handled by the feature
   virtual tDiaResult getFunctionIDs ( std::list<tU16>& results ) const;

   //! start monitoring of properties
   virtual tDiaResult startMonitoring ( void );
   //! stop monitoring of properties
   virtual tDiaResult stopMonitoring ( void );

protected:
   //! deprecated default constructor
   dia_SystemAdapterFeature ( void );

   //! reset the festure
   virtual void reset ( void ) {}

   //! Functor to send a CCA message when predicates are fulfilled
   template <class SystemAdapterFeature, typename... Args>
   class FunctorSendMessage : public dia_Functor
   {
      //! SystemAdapter for a CCA Service to send the message
      dia_SystemAdapterServicePlugin* mpSrvPlugin;
      //! message parameters
      std::tuple<Args...> mArgs;

   public:
      FunctorSendMessage() = delete;
      FunctorSendMessage ( SystemAdapterFeature* pSystemAdapterFeature, const Args&... args)
         : mpSrvPlugin(pSystemAdapterFeature? pSystemAdapterFeature->mpSrvPlugin: nullptr), mArgs(args...)
      {}

      virtual ~FunctorSendMessage () {}
      //! override operator "()" in order to call the member function with stored arguments
      tDiaResult operator() ( void ) override;
   };

protected:
   //! name for this feature
   tCString mName;

   // pointer to the associated service plugin
   dia_SystemAdapterServicePlugin* mpSrvPlugin;

   tBool _bFidReg;

   //! application ID of the concrete client handler
   tU16  mAppID;

   //! specific type identifier for the feature
   dia_enSAFeatureType mType;
};

#endif /* __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__ */
