/*!
 * \file       dia_SAFeatureWifiBLConflictManagement.h
 *
 * \brief      header file for dia_SAFeatureWifiBLConflictManagement
 *
 * \details    ASF component for Wifi BL ConflictManagement
 *
 * \component  Diagnosis
 *
 * \ingroup    diaASFComponents
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_SAFEATURE_WIFI_BL_CONFLICTMANAGEMENT__
#define __INCLUDED_DIA_SAFEATURE_WIFI_BL_CONFLICTMANAGEMENT__

#ifndef ORG_BOSCH_WBL_CONFLICTMANAGEMENTPROXY_H
#include <org/bosch/wbl/conflictmanagementProxy.h>
#endif

#ifndef ORG_BOSCH_WBL_CONFLICTMANAGEMENTCLIENTBASE_H
#include "org/bosch/wbl/conflictmanagementClientBase.h"
#endif

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterFeatureASF.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_WIFI_SETUPS_LISTENER__
#include <common/interfaces/dia_IWifiSetupsListener.h>
#endif


using namespace org::bosch::wbl::conflictmanagement;

class dia_SAFeatureWifiBLConflictManagement
  : public dia_SystemAdapterFeatureASF<ConflictmanagementProxy>,
    public ConflictmanagementClientBase,
    public dia_IWifiSetups
{
public:
   //! constructor
   dia_SAFeatureWifiBLConflictManagement (dia_SystemAdapterServicePluginASF<ConflictmanagementProxy>& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureWifiBLConflictManagement();

   //! start monitoring of properties
   virtual tDiaResult startMonitoring();
   //! stop monitoring of properties
   virtual tDiaResult stopMonitoring();

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IWifiSetups methods
   //
   //-------------------------------------------------------------------------
   //! request to configure Wifi module
   virtual tDiaResult prepareSetup(const ::std::string& mode);
   //! get property 'ActiveWiFiSetups'
   virtual tDiaResult GetActiveSetups ( );
   //! register property 'ActiveWiFiSetups'
   virtual tDiaResult regActiveSetups( );
   //! unregister property 'ActiveWiFiSetups'
   virtual tDiaResult deregActiveSetups( );
   //! Deactivate Wifi setup (wifiMode is e.g. STA)
   virtual tDiaResult deActivateSetup ( const ::std::string& wifiMode );

   //-------------------------------------------------------------------------
   //
   // Overloaded ConflictmanagementClientBase methods
   //
   //-------------------------------------------------------------------------
   virtual void onPrepareSetupError(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< PrepareSetupError >& error);
   virtual void onPrepareSetupResponse(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< PrepareSetupResponse >& response);

   virtual void onDeActivateSetupError(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< DeActivateSetupError >& error);
   virtual void onDeActivateSetupResponse(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< DeActivateSetupResponse >& response);

   virtual void onActiveWiFiSetupsError(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< ActiveWiFiSetupsError >& error);
   virtual void onActiveWiFiSetupsUpdate(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< ActiveWiFiSetupsUpdate >& update);

protected:
   //! deprecated default constructor
   dia_SAFeatureWifiBLConflictManagement ();

   //! response to the request GetActiveSetups
   virtual void onActiveWiFiSetupsUpdate( const std::vector<dia_stWifiSetup>& setupList );
   //! response to the request prepareSetup
   virtual void onPrepareSetupResponse(tDiaResult response);
   //! response to the request deActivateSetup
   virtual void onDeActivateSetupResponse(tDiaResult response);

   virtual void* getDbusIterValue(DBusMessageIter* iter);
   virtual void getConnectedDeviceList(DBusMessageIter* iter, std::vector< std::string >& deviceList, int check);

   //! act got after register
   act_t mActReg;

   //! insert element for a map of DBUS message
   tDiaResult insert_map_element_dbus(::std::map< ::std::string, ::asf::dbus::DBusVariant >& map, const ::std::string& key, int type, const void* val);
   //! insert element for a map of DBUS message
   tDiaResult insertAPConfigElements_dbus(::asf::dbus::DBusVariant& apConfigVariant);
   //!
   tDiaResult dict_append_entry_dbus(DBusMessageIter* dict, const char* key, int type, void* val);
   //!
   tDiaResult append_variant_dbus(DBusMessageIter* iter, int type, void* val);

   static const std::string sAPMode;
   static const std::string sStationMode;
};

#endif /* __INCLUDED_DIA_SAFEATURE_WIFI_BL_CONFLICTMANAGEMENT__ */
