/**
 * \file      dia_SAFeatureVDDeviceMGR.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    kaa1hi
 * \date      Feb 11, 2015
 *
 * \copyright Robert Bosch Car Multimedia 2015
 */

#ifndef DIA_SAFEATUREVDDEVICEMANAGER_H_
#define DIA_SAFEATUREVDDEVICEMANAGER_H_

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DEVICEMGRUSB_LISTENER__
#include "common/interfaces/dia_IDeviceMGRUSBListener.h"
#endif

#ifndef __INCLUDED_DIA_DIAGLIB_IOCONTROL_LISTENER__
#include "common/depricated/SystemAdapter/dia_IDiaglibIoControlListener.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_DIAGLIB__
#include "dia_SystemAdapterFeatureDiaglib.h"
#endif


#ifndef __INCLUDED_DIA_INTERFACE_DIAGLIB_DIAGNOSIS_DATA_LISTENER__
#include "common/depricated/SystemAdapter/dia_IDiaglibDiagnosisDataListener.h"
#endif

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureVDDeviceMGR
   : public dia_SystemAdapterFeatureDiaglib,
     public dia_IDeviceMGRUSB,
     public dia_IDiaglibIoControlListener,
     public dia_IDiaglibDiagnosisDataListener

{
public:
   //! constructor
   dia_SAFeatureVDDeviceMGR ( tCString name, dia_SystemAdapterServicePluginDiaglib& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureVDDeviceMGR ( void );

   //! return the diaglib IDs managed by this feature
   virtual tDiaResult getDiaglibIDs ( std::list<tU32>& results ) const;

   //-------------------------------------------------------------------------
   // Overloaded dia_IDeviceMGRUSB method
   //-------------------------------------------------------------------------

   /**
    * IOControl USB_1_PowerStatus Set
    */
   //! IOControl USB_1_PowerStatus Set
   virtual tDiaResult setUSBPowerStatus ( dia_eUsbDevice powerDevice, dia_eUsbPowerStatus powerStatus );

   /**
    * ReadDataByIdentifier
    */

   //! Get current in units of milliampere for all USB ports
   virtual tDiaResult getUSBPortCurrentResult ( );

   //! ReadDataByIdentifier USB_1_PowerStatus Read
   virtual tDiaResult getUSBPowerStatusResult ( dia_eUsbDevice powerDevice );

   //-------------------------------------------------------------------------
   // receive functions
   //-------------------------------------------------------------------------

   //IOControl USB_1_PowerStatus Set
   virtual void vOnIoCtrlResult(tU32 u32IoCtrlId, tenIoCtrlResult enResult, tenIoControlAction enActionId, const tDiaglibParamVector& oStartResult);

   //ReadDataByIdentifier USB_1_PowerStatus Read
   virtual void vOnDiagnosisDataResult (
        tU32 u32DiagnosisDataId,
        tenDiagDataResult enResult,
        const tDiaglibParamVector& oResult
   );

protected:
   //! deprecated default constructor
   dia_SAFeatureVDDeviceMGR ( void );

   //! handle incoming CCA message
   void vHandleIOControl ( amt_tclServiceData* poMessage );       //IOControl USB_1_PowerStatus Set
   void vHandleDiagnosisData ( amt_tclServiceData* poMessage );   //ReadDataByIdentifier USB_1_PowerStatus Read

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureVDDeviceMGR)
};

#endif /* DIA_SAFEATUREVDDEVICEMANAGER_H_ */
