/**
* \file      dia_SAFeatureVDDeviceMGR.cpp
*
* \brief     {insert brief description here}
*
* \details   {insert file description here}
*
* \author    kaa1hi
* \date      Feb 11, 2015
*
* \copyright Robert Bosch Car Multimedia 2015
*/

#include "dia_SAFeatureVDDeviceMGR.h"

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
#include "project/framework/sysadapters/dia_SAFeatureDiaglib.h"
#endif

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_STDVISITORS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_ERRORCODES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#include "common/depricated/SystemAdapter/dia_IdSpecEnum.h"
#include "common/diaglib/diaglib_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define DIA_NUMBER_OF_USB_PORTS              (3U)
#define DIA_SIZE_OF_CURRENT_VALUE_IN_BYTES   (2U)

// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureVDDeviceMGR, dia_SystemAdapterFeatureDiaglib)
   ON_MESSAGE(MIDW_DIAGLIBFI_C_U16_IOCONTROL, vHandleIOControl)
   ON_MESSAGE(MIDW_DIAGLIBFI_C_U16_DIAGNOSISDATA, vHandleDiagnosisData)
END_MSG_MAP()

//------------------------------------------------------------------------------

dia_SAFeatureVDDeviceMGR::dia_SAFeatureVDDeviceMGR(tCString name, dia_SystemAdapterServicePluginDiaglib& pSrvPlugin)
   : dia_SystemAdapterFeatureDiaglib(name, pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureVDDeviceMGR::dia_SAFeatureVDDeviceMGR");
}

//-----------------------------------------------------------------------------

dia_SAFeatureVDDeviceMGR::~dia_SAFeatureVDDeviceMGR(void)
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureVDDeviceMGR::getDiaglibIDs(std::list<tU32>& results) const
{
   results.push_back(IOCONTROLID_DEVICEMAMAGER_USB_DETECTION_CONTROL);     //IOControl USB_1_PowerStatus Set
   results.push_back(DATAID_DEVICEMANAGER_USB_DETECTION_CONTROL_STATUS);   //ReadDataByIdentifier USB_1_PowerStatus Read
   results.push_back(DATAID_DEVICEMANAGER_USB_CURRENT_FOR_ALL_PORTS);      //ReadDataByIdentifier dia_SrvHandler_USB_PowerSupplyInfoPort
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------
// IOControl
//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureVDDeviceMGR::setUSBPowerStatus(dia_eUsbDevice powerDevice, dia_eUsbPowerStatus powerStatus)
{
   dia_tclFnctTrace trc("dia_SAFeatureVDDeviceMGR::setUSBPowerStatus(dia_eUsbDevice,dia_eUsbPowerStatus)");

   tDiaResult retCode = DIA_FAILED;

   if (powerDevice == USB_DEVICE_UNKNOWN || powerDevice >= USB_DEVICE_COUNT)
   {
      DIA_TR_ERR("### dia_SAFeatureVDDeviceMGR::setUSBPowerStatus - powerDevice (0x%02x) FAILURE!", powerDevice);
      return retCode;
   }

   if (powerStatus == USB_POWER_UNKNOWN || powerStatus >= USB_POWER_COUNT)
   {
      DIA_TR_ERR("### dia_SAFeatureVDDeviceMGR::setUSBPowerStatus - powerStatus (0x%02x) FAILURE!", powerStatus);
      return retCode;
   }

   tDiaglibParamVector vecRequest;
   trParameter paramMode;

   paramMode.u32Value = 0x00000000;  //default none of the powersupplies are selected for controlling
   paramMode.enType = static_cast<tenParameterType>(IOCONTROLID_DEVICEMAMAGER_USB_DETECTION_CONTROL_SET_PARAM1/*DATAID_DEVICEMANAGER_USB_DETECTION_CONTROL_STATUS_WRITE_LEN*/);
   /* Bitmask for usb-devices (1-3); 0 means off; 1 mean on */
   /* MSB is used to select a power supply to turn off or on*/
   switch (powerDevice)
   {
      case USB_DEVICE_1:
      {
         DIA_TR_INF("dia_SAFeatureVDDeviceMGR::setUSBPowerStatus - Switch USB_DEVICE_1.");
         if (powerStatus == USB_POWER_OFF)
         {
            paramMode.u32Value |= 0x00000100;
            DIA_TR_INF("dia_SAFeatureVDDeviceMGR::setUSBPowerStatus - Switch USB_DEVICE_1 to off u32Value=0x%02X.", paramMode.u32Value);
         }
         else
         {
            paramMode.u32Value |= 0x00000101;
            DIA_TR_INF("dia_SAFeatureVDDeviceMGR::setUSBPowerStatus - Switch USB_DEVICE_1 to on u32Value=0x%02X.", paramMode.u32Value);
         }
      }
      break;

      case USB_DEVICE_2:
      {
         DIA_TR_INF("dia_SAFeatureVDDeviceMGR::setUSBPowerStatus - Switch USB_DEVICE_2.");
         if (powerStatus == USB_POWER_OFF)
         {
            paramMode.u32Value |= 0x00000200;
            DIA_TR_INF("dia_SAFeatureVDDeviceMGR::setUSBPowerStatus - Switch USB_DEVICE_2 to off u32Value=0x%02X.", paramMode.u32Value);
         }
         else
         {
            paramMode.u32Value |= 0x00000202;
            DIA_TR_INF("dia_SAFeatureVDDeviceMGR::setUSBPowerStatus - Switch USB_DEVICE_2 to on u32Value=0x%02X.", paramMode.u32Value);
         }
      }
      break;

      case USB_DEVICE_3:
      {
         DIA_TR_INF("dia_SAFeatureVDDeviceMGR::setUSBPowerStatus - Switch USB_DEVICE_3.");
         if (powerStatus == USB_POWER_OFF)
         {
            paramMode.u32Value |= 0x00000400;
            DIA_TR_INF("dia_SAFeatureVDDeviceMGR::setUSBPowerStatus - Switch USB_DEVICE_3 to off u32Value=0x%02X.", paramMode.u32Value);
         }
         else
         {
            paramMode.u32Value |= 0x00000404;
            DIA_TR_INF("dia_SAFeatureVDDeviceMGR::setUSBPowerStatus - Switch USB_DEVICE_3 to on u32Value=0x%02X.", paramMode.u32Value);
         }
      }
      break;

      default:
      {
         DIA_TR_ERR("dia_SAFeatureVDDeviceMGR::setUSBPowerStatus - Switch Error Case Device 0x%02x selected!", powerDevice);
      }
      break;
   }

   vecRequest.push_back(paramMode);

   if (dia_SAFeatureDiaglib::bIOControlStart(IOCONTROLID_DEVICEMAMAGER_USB_DETECTION_CONTROL, EN_ACTION_SET, vecRequest, mpSrvPlugin) == TRUE)
   {
      DIA_TR_INF("dia_SAFeatureVDDeviceMGR::setUSBPowerStatus-bIOControlStart SUCCESSFUL.");
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureVDDeviceMGR::setUSBPowerStatus - bIOControlStart FAILED");
   }

   return retCode;

}

//=============================================================================
//=============================================================================

void
dia_SAFeatureVDDeviceMGR::vHandleIOControl(amt_tclServiceData* poMessage)
{
   dia_tclFnctTrace trc(("dia_SAFeatureVDDeviceMGR::vHandleIOControl"));

   dia_SAFeatureDiaglib::u32EvalIoCtrlMessage(poMessage, this);
}

//------------------------------------------------------------------------------

void
dia_SAFeatureVDDeviceMGR::vOnIoCtrlResult(tU32 u32IoCtrlId, tenIoCtrlResult enResult, tenIoControlAction /*enActionId*/, const tDiaglibParamVector& oStartResult)
{
   dia_tclFnctTrace trc("dia_SAFeatureVDDeviceMGR::vOnIoCtrlResult");

   DIA_PARAMETER_INTENTIONALLY_UNUSED(u32IoCtrlId);

   dia_IDeviceMGRUSBListener* pListener = OSAL_NULL;
   querySysAdapterListener<dia_IDeviceMGRUSBListener>(&pListener);

   if (pListener)
   {
      DIA_TR_INF("dia_SAFeatureVDDeviceMGR::vOnIoCtrlResult - Information forwarded to listener");

      tU8 ePwrSupply = 0;

      if (EN_IO_CONTROL_OK == enResult)
      {
         DIA_TR_INF("dia_SAFeatureVDDeviceMGR::vOnIoCtrlResult - EN_IO_CONTROL_OK !");

         //ePwrSupply = static_cast<tU8>(oStartResult[0].u32Value+1);
         ePwrSupply = (tU8)oStartResult[IOCONTROLID_DEVICEMAMAGER_USB_DETECTION_CONTROL_RESULT_u32MediaStatusBitField].u32Value;

         DIA_TR_INF("dia_SAFeatureVDDeviceMGR::vOnIoCtrlResult - u32Value=0x%08X.", oStartResult[IOCONTROLID_DEVICEMAMAGER_USB_DETECTION_CONTROL_RESULT_u32MediaStatusBitField].u32Value);
         DIA_TR_INF("dia_SAFeatureVDDeviceMGR::vOnIoCtrlResult - ePwrSupply=0x%02X.", ePwrSupply);
         pListener->vOnUSBPowerStatusResult(ePwrSupply);
      }
      else     //if ( EN_ROUTINE_CONTROL_OK == enRoutineStatus )
      {
         DIA_TR_ERR("dia_SAFeatureVDDeviceMGR::vOnIoCtrlResult - EN_IO_CONTROL_NOK !!");
         pListener->vOnUSBPowerStatusError();
      }

   }
   else
   {
      DIA_TR_ERR("### dia_SAFeatureVDDeviceMGR::vOnIoCtrlResult - No listener registered");
   }
}

//----------------------------------------------------------------------------------------
// ReadDataByIdentifier
//----------------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureVDDeviceMGR::getUSBPowerStatusResult(dia_eUsbDevice /*powerDevice*/){
   dia_tclFnctTrace trc(("dia_SAFeatureVDDeviceMGR::getUSBPowerStatusResult(dia_eUsbDevice)"));

   tBool bRetVal = dia_SAFeatureDiaglib::bDiagDataReadStart(DATAID_DEVICEMANAGER_USB_DETECTION_CONTROL_STATUS, mpSrvPlugin);
   tDiaResult retCode = (bRetVal ? DIA_SUCCESS : DIA_FAILED);
   DIA_TR_INF(" dia_SAFeatureVDDeviceMGR::getUSBPowerStatusResult (%x)", retCode);

   return retCode;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureVDDeviceMGR::getUSBPortCurrentResult(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureVDDeviceMGR::getUSBPortCurrent()");

   tBool bRetVal = dia_SAFeatureDiaglib::bDiagDataReadStart(DATAID_DEVICEMANAGER_USB_CURRENT_FOR_ALL_PORTS, mpSrvPlugin);
   tDiaResult retCode = (bRetVal ? DIA_SUCCESS : DIA_FAILED);
   DIA_TR_INF(" dia_SAFeatureVDDeviceMGR::getUSBPortCurrent (%x ==> %s)", retCode, (DIA_SUCCESS == retCode ? "DIA_SUCCESS" : "DIA_FAILED"));

   return retCode;
}

//----------------------------------------------------------------------------------------

void
dia_SAFeatureVDDeviceMGR::vHandleDiagnosisData(amt_tclServiceData* poMessage)
{
   dia_tclFnctTrace trc((" dia_SAFeatureVDDeviceMGR::vHandleDiagnosisData"));

   if (!poMessage)
   {
      DIA_TR_ERR("dia_SAFeatureVDDeviceMGR::vHandleDiagnosisData => ERROR: Invalid Message Pointer !!!");
   }
   else
   {
      (void)dia_SAFeatureDiaglib::u32EvalDiagnosisDataCtrlMessage(poMessage, this);
   }

   // delete now if not deleted
   if (poMessage != NULL)
   {
      (void)poMessage->bDelete();
   }
}
//----------------------------------------------------------------------------------------

void
dia_SAFeatureVDDeviceMGR::vOnDiagnosisDataResult(tU32 u32DiagnosisDataId, tenDiagDataResult enResult, const tDiaglibParamVector& oResult)
{
   dia_tclFnctTrace trc(("dia_SAFeatureVDDeviceMGR::vOnDiagnosisDataResult"));
   dia_IDeviceMGRUSBListener* pListener = OSAL_NULL;
   (void)querySysAdapterListener<dia_IDeviceMGRUSBListener>(&pListener);

   if (OSAL_NULL != pListener)
   {
      switch (u32DiagnosisDataId)
      {
      case DATAID_DEVICEMANAGER_USB_DETECTION_CONTROL_STATUS:
      {
         DIA_TR_INF("dia_SAFeatureVDDeviceMGR::vOnDiagnosisDataResult - DATAID_DEVICEMANAGER_USB_DETECTION_CONTROL_STATUS");

         if (EN_DIAGDATA_OK == enResult)
         {
            DIA_TR_INF("dia_SAFeatureVDDeviceMGR::vOnDiagnosisDataResult - enResult = EN_DIAGDATA_OK");
            if (oResult.size() >= DATAID_DEVICEMANAGER_USB_DETECTION_CONTROL_STATUS_READ_RESULT_LEN)
            {
               tU32 powerStatus = oResult[DATAID_DEVICEMANAGER_USB_DETECTION_CONTROL_STATUS_READ_RESULT_u32MediaStatusBitField].u32Value;
               DIA_TR_INF("dia_SAFeatureVDDeviceMGR::vOnDiagnosisDataResult - Received powerStatus=0x%08x .", powerStatus);
               DIA_TR_INF("dia_SAFeatureVDDeviceMGR::vOnDiagnosisDataResult - USB_DEVICE_1=%s .", (powerStatus & 0x01) != 0 ? "USB_POWER_ON" : "USB_POWER_OFF");
               DIA_TR_INF("dia_SAFeatureVDDeviceMGR::vOnDiagnosisDataResult - USB_DEVICE_2=%s .", (powerStatus & 0x02) != 0 ? "USB_POWER_ON" : "USB_POWER_OFF");
               DIA_TR_INF("dia_SAFeatureVDDeviceMGR::vOnDiagnosisDataResult - USB_DEVICE_3=%s .", (powerStatus & 0x04) != 0 ? "USB_POWER_ON" : "USB_POWER_OFF");

               DIA_TR_INF("dia_SAFeatureVDDeviceMGR::vOnDiagnosisDataResult - Inform services.");
               pListener->vOnUSBPowerStatusReadResult(USB_DEVICE_1, (powerStatus & 0x01) != 0 ? USB_POWER_ON : USB_POWER_OFF);
               pListener->vOnUSBPowerStatusReadResult(USB_DEVICE_2, (powerStatus & 0x02) != 0 ? USB_POWER_ON : USB_POWER_OFF);
               pListener->vOnUSBPowerStatusReadResult(USB_DEVICE_3, (powerStatus & 0x04) != 0 ? USB_POWER_ON : USB_POWER_OFF);
            }
            else
            {
               DIA_TR_ERR("!!! dia_SAFeatureVDDeviceMGR::vOnDiagnosisDataResult => ERROR: No Data Available");
               pListener->vOnUSBPowerStatusReadError(EN_ERROR_NO_DATA);
            }
         }
         else
         {
            DIA_TR_ERR("!!! dia_SAFeatureVDDeviceMGR::vOnDiagnosisDataResult => enResult != EN_DIAGDATA_OK");

            if (oResult.size() >= 1 && oResult[0].enType == EN_PARAMETER_TYPE_U8ERROR) {
               tenInternalError enErrorCode = oResult[0].u8ErrorValue;
               DIA_TR_ERR("!!! dia_SAFeatureVDDeviceMGR::vOnDiagnosisDataResult => Error received :%x", enErrorCode);
               pListener->vOnUSBPowerStatusReadError(enErrorCode);
            }
            else {
               DIA_TR_ERR("!!! dia_SAFeatureVDDeviceMGR::vOnDiagnosisDataResult => ERROR: No Data Available");
               pListener->vOnUSBPowerStatusReadError(EN_ERROR_NO_DATA);
            }
         }
         break;
      }

      case DATAID_DEVICEMANAGER_USB_CURRENT_FOR_ALL_PORTS:
      {
         DIA_TR_INF("dia_SAFeatureVDDeviceMGR::vOnDiagnosisDataResult - DATAID_DEVICEMANAGER_USB_CURRENT_FOR_ALL_PORTS");

         if (EN_DIAGDATA_OK == enResult)
         {
            DIA_TR_INF("dia_SAFeatureVDDeviceMGR::vOnDiagnosisDataResult - enResult = EN_DIAGDATA_OK - USB_CURRENT_FOR_ALL_PORTS");

            if ((oResult.size() >= DATAID_DEVICEMANAGER_USB_DETECTION_CONTROL_STATUS_READ_RESULT_LEN) && (EN_PARAMETER_TYPE_ARRAY_U8 == oResult[0].enType))
            {
               std::vector<dia_tUsbPortCurrent> usbPortCurrent;

               for (tU8 i = 0; i<DIA_NUMBER_OF_USB_PORTS; i++)
               {
                  tU16 currentVal = (tU16)((oResult[DATAID_DEVICEMANAGER_USB_CURRENT_FOR_ALL_PORTS_READ_RESULT_au8Current + i*DIA_SIZE_OF_CURRENT_VALUE_IN_BYTES + 0].u8Value << 8) |
                     (oResult[DATAID_DEVICEMANAGER_USB_CURRENT_FOR_ALL_PORTS_READ_RESULT_au8Current + i*DIA_SIZE_OF_CURRENT_VALUE_IN_BYTES + 1].u8Value << 0));

                  //+1 because valid port numbers are 1, 2, 3
                  usbPortCurrent.push_back(dia_tUsbPortCurrent(static_cast<dia_eUsbPort>(i + 1), currentVal));

                  DIA_TR_INF("[%d] portNo=%d, currentVal=0x%04X (decimal %d)", i, i + 1, currentVal, currentVal);
               }

               DIA_TR_INF("dia_SAFeatureVDDeviceMGR::vOnDiagnosisDataResult - Inform services - USB_CURRENT_FOR_ALL_PORTS");
               pListener->vOnUSBPortCurrentResult(usbPortCurrent);
            }
            else
            {
               DIA_TR_ERR("!!! dia_SAFeatureVDDeviceMGR::vOnDiagnosisDataResult => ERROR: No Data Available");
               DIA_TR_ERR("!!! oResult.size() is %zu, but expected eq or gr than %u", oResult.size(), DATAID_DEVICEMANAGER_USB_DETECTION_CONTROL_STATUS_READ_RESULT_LEN);

               if (oResult.size()>0)
               {
                  DIA_TR_ERR("!!! oResult[0].enType is %d, but expected %d", oResult[0].enType, EN_PARAMETER_TYPE_ARRAY_U8);
               }

               if (!(oResult.size() >= DATAID_DEVICEMANAGER_USB_DETECTION_CONTROL_STATUS_READ_RESULT_LEN))
               {
                  pListener->vOnUSBPortCurrentError(EN_ERROR_DATA_LENGTH_INCORRECT);
               }
               else
               {
                  pListener->vOnUSBPortCurrentError(EN_ERROR_NO_DATA);
               }
            }
         }
         else
         {
            DIA_TR_ERR("!!! dia_SAFeatureVDDeviceMGR::vOnDiagnosisDataResult enResult!=EN_DIAGDATA_OK - USB_CURRENT_FOR_ALL_PORTS");

            if ((oResult.size() >= 1) && (oResult[0].enType == EN_PARAMETER_TYPE_U8ERROR))
            {
               tenInternalError enErrorCode = oResult[0].u8ErrorValue;
               DIA_TR_ERR("!!! dia_SAFeatureVDDeviceMGR::vOnDiagnosisDataResult Error received 0x%08X (decimal %d)", enErrorCode, enErrorCode);
               pListener->vOnUSBPortCurrentError(enErrorCode);
            }
            else
            {
               DIA_TR_ERR("!!! dia_SAFeatureVDDeviceMGR::vOnDiagnosisDataResult => ERROR: No Data Available");
               pListener->vOnUSBPortCurrentError(EN_ERROR_NO_DATA);
            }
         }
         break;
      }

      default:
      {
         DIA_TR_ERR("!!! dia_SAFeatureVDDeviceMGR::vOnDiagnosisDataResult ERROR: Unknown DataId=0x%x (decimal %d)", u32DiagnosisDataId, u32DiagnosisDataId);
         DIA_ASSERT_ALWAYS();
         break;
      }
      }
   }
   else
   {
      DIA_TR_ERR("!!! dia_SAFeatureVDDeviceMGR::vOnDiagnosisDataResult => ERROR: OSAL_NULL == pListener");
      DIA_ASSERT_ALWAYS();
   }
}
