/*
 * dia_SAFeatureSystemSettingsASF.h
 *
 *  Created on: 12.09.2015
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS_ASF__
#define __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS_ASF__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterFeatureASF.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MODULE__
#include <common/framework/sysset/dia_SystemSettingsModule.h>
#endif

#ifndef __INCLUDED_DIA_LOCK__
#include <common/framework/application/dia_Lock.h>
#endif

#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1Proxy.h"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1ClientBase.h"

using namespace ::boost;
using namespace ::asf::core;
using namespace ::org::bosch::cm::diagnosis::dbus::Diagnosis1::SystemSettings1;

//-----------------------------------------------------------------------------

class dia_SAFeatureSystemSettingsASF
   : public dia_SystemAdapterFeatureASF<SystemSettings1Proxy>,
     public SystemSettings1ClientBase,
     public dia_SystemSettingsModule
{
public:
   //! constructor
   dia_SAFeatureSystemSettingsASF ( tCString name, tCString strSystemSettingID, tU32 maskSystemSettingTypes, dia_SystemAdapterServicePluginASF<SystemSettings1Proxy>& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureSystemSettingsASF();

   //! overloaded from dia_SystemSettingsModule
   virtual tDiaResult prepareSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData );
   //! overloaded from dia_SystemSettingsModule
   virtual tDiaResult executeSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData  );
   //! overloaded from dia_SystemSettingsModule
   virtual tDiaResult finalizeSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData  );

   // ASF callbacks on 'PrepareSystemSettingCallbackIF'
   virtual void onPrepareSystemSettingError(const boost::shared_ptr<SystemSettings1Proxy>& proxy, const boost::shared_ptr<PrepareSystemSettingError>& error);
   virtual void onPrepareSystemSettingResponse(const boost::shared_ptr<SystemSettings1Proxy>& proxy, const boost::shared_ptr<PrepareSystemSettingResponse>& response);
   // ASF callbacks on 'ExecuteSystemSettingCallbackIF'
   virtual void onExecuteSystemSettingError(const boost::shared_ptr<SystemSettings1Proxy>& proxy, const boost::shared_ptr<ExecuteSystemSettingError>& error);
   virtual void onExecuteSystemSettingResponse(const boost::shared_ptr<SystemSettings1Proxy>& proxy, const boost::shared_ptr<ExecuteSystemSettingResponse>& response);
   // ASF callbacks on 'FinalizeSystemSettingCallbackIF'
   virtual void onFinalizeSystemSettingError(const boost::shared_ptr<SystemSettings1Proxy>& proxy, const boost::shared_ptr<FinalizeSystemSettingError>& error);
   virtual void onFinalizeSystemSettingResponse(const boost::shared_ptr<SystemSettings1Proxy>& proxy, const boost::shared_ptr<FinalizeSystemSettingResponse>& response);
   //! update error or response info to system settings framework
   virtual void onSystemSettingResult(act_t act, dia_UID Id,dia_enSystemSettingLevel level, tDiaResult result);
protected:
   //! deprecated default constructor
   dia_SAFeatureSystemSettingsASF ();

protected:
   //! system setting ID string for the module
   std::string mID;
   //! asynchronous completion token used for ASF based communication
   std::map<dia_enSystemSettingLevel, act_t> mLevelACT;
   //! synchronization object used to synchronize concurrent access from multiple threads
   mutable dia::Lock mSyncObj;

protected:

   template <class ExtendedDataStruct>
   class FunctorSendRequest : public dia_Functor
   {
   public:
      //! constructor
      FunctorSendRequest ( dia_SAFeatureSystemSettingsASF* pObj, const std::string& strSysSetType, const dia_SystemSettingExtendedData& extData )
         : mpObj(pObj), mStrType(strSysSetType)
      {
         std::transform(extData.begin(), extData.end(), std::back_inserter(mRequestExtDataVec),
               [](const dia_SystemSettingExtDataElem& e)  { return ExtendedDataStruct(e.mTypeInfo, e.mData); });
      }

      //! class destructor
      virtual ~FunctorSendRequest ( void ) {}

      //! override operator "()" in order to call the member function with stored arguments
      virtual tDiaResult operator() ( void );

   protected:
      //! deprecated default constructor without implementation
      FunctorSendRequest ( void );

   private:
      //! pointer to object
      dia_SAFeatureSystemSettingsASF* mpObj;
      //! system setting Type string
      std::string mStrType;
      //! extended data
      std::vector<ExtendedDataStruct> mRequestExtDataVec;
   };

};

#endif /* __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS_ASF__ */
