/*
 * dia_SAFeatureSystemSettingsASF.cpp
 *
 *  Created on: 12.09.2015
 *      Author: gib2hi
 */

#if 1
//Redefinition of new and delete when both OSAL and std::stl is used
#define __PLACEMENT_NEW_INLINE
#endif

//#include <com/adit/de/ALD/change_levelProxy.h>
//
#ifndef __INCLUDED_DIA_APPLICATION__
#include "common/framework/application/dia_Application.h"
#endif

#include <org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1Proxy.h> //lint !e451 !e537 repeatedly included header file without standard include guard

#include <common/framework/sysadapters/dia_SAFeatureSystemSettingsASF.h>

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterServicePluginASF.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include <common/framework/sysset/dia_SystemSettingsManager.h>
#endif

using namespace ::org::bosch::cm::diagnosis::dbus::Diagnosis1::SystemSettings1;

//-----------------------------------------------------------------------------

dia_SAFeatureSystemSettingsASF::dia_SAFeatureSystemSettingsASF (
      tCString name,
      tCString strSystemSettingsID,
      tU32 systemSettingsTypeMask,
      dia_SystemAdapterServicePluginASF<SystemSettings1Proxy>& pSrvPlugin
   )
   : dia_SystemAdapterFeatureASF(pSrvPlugin),
     dia_SystemSettingsModule(name,systemSettingsTypeMask),
     mID(strSystemSettingsID),
     mSyncObj(std::string(std::string(name) + "_LK").c_str())
{
   dia_tclFnctTrace trc("dia_SAFeatureSystemSettingsASF::dia_SAFeatureSystemSettingsASF()");

   mLevelACT[DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE] = 0;
   mLevelACT[DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE] = 0;
   mLevelACT[DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE] = 0;
}

//-----------------------------------------------------------------------------

dia_SAFeatureSystemSettingsASF::~dia_SAFeatureSystemSettingsASF()
{
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSystemSettingsASF::prepareSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData )
{
   dia_tclFnctTrace trc("dia_SAFeatureSystemSettingsASF::prepareSystemSetting");

   tDiaResult retCode = DIA_FAILED;

   std::string typeName;
   if ( getSystemSettingTypeName(sysSetTypeUID, typeName) == DIA_SUCCESS )
   {
      if (mLevelACT[DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE] == 0)
      {
         mLevelACT[DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE] = UINTPTR_MAX;
         retCode = mpSrvPlugin->executeServiceFunctor( std::unique_ptr<dia_Functor>(new FunctorSendRequest<PrepareSystemSettingRequestExtendedDataStruct>(this, typeName, extData)) );
      }
      else
      {
         DIA_TR_ERR("System setting functor Prepare already started (type=\"%s\",id=\"%s\")", typeName.c_str(),mID.c_str());
         retCode=DIA_SUCCESS;
      }
   }
   else
   {
      DIA_TR_INF("System setting type not supported (type=\"%s\",id=\"%s\")", typeName.c_str(),mID.c_str());
      retCode=DIA_SUCCESS;
   }

   return retCode;
}

//-----------------------------------------------------------------------------

template <>
tDiaResult
dia_SAFeatureSystemSettingsASF::FunctorSendRequest<PrepareSystemSettingRequestExtendedDataStruct>::operator() ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureSystemSettingsASF::FunctorSendRequest<PrepareSystemSettingRequestExtendedDataStruct>::operator()");

   tDiaResult retCode = DIA_FAILED;

   SystemSettings1Proxy* pProxy = mpObj->mpSrvPlugin->getProxy();
   if (pProxy)
   {
      dia::LockScope lock(mpObj->mSyncObj);
      mpObj->mLevelACT[DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE] = pProxy->sendPrepareSystemSettingRequest(*mpObj, mpObj->mID, mStrType, mRequestExtDataVec, 0 /*this*/);

      if ( mpObj->mLevelACT[DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE] != 0 )
      {
         DIA_TR_INF("Successfully sent PrepareSystemSettingRequest (type=\"%s\",id=\"%s\",act=0x%lx)", mStrType.c_str(), mpObj->mID.c_str(), mpObj->mLevelACT[DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE]);
         retCode=DIA_SUCCESS;
      }
      else
      {
         DIA_TR_ERR("Failed to send PrepareSystemSettingRequest (type=\"%s\",id=\"%s\")", mStrType.c_str(), mpObj->mID.c_str());
      }
   }
   else
   {
      DIA_TR_ERR("##### ASF INTERFACE PROXY \"SystemSettings1Proxy\" for %s NOT AVAILABLE #####", mpObj->mpSrvPlugin->getPortName().c_str());
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSystemSettingsASF::executeSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData )
{
   dia_tclFnctTrace trc("dia_SAFeatureSystemSettingsASF::executeSystemSetting");

   tDiaResult retCode = DIA_FAILED;

   std::string typeName;
   if ( getSystemSettingTypeName(sysSetTypeUID, typeName) == DIA_SUCCESS )
   {
      if (mLevelACT[DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE] == 0)
      {
         mLevelACT[DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE] = UINTPTR_MAX;
         retCode = mpSrvPlugin->executeServiceFunctor( std::unique_ptr<dia_Functor>(new FunctorSendRequest<ExecuteSystemSettingRequestExtendedDataStruct>(this, typeName, extData)) );
      }
      else
      {
         DIA_TR_ERR("System setting functor Execute already started (type=\"%s\",id=\"%s\")", typeName.c_str(),mID.c_str());
         retCode=DIA_SUCCESS;
      }
   }
   else
   {
      DIA_TR_INF("System setting type not supported (type=\"%s\",id=\"%s\")", typeName.c_str(),mID.c_str());
      retCode=DIA_SUCCESS;
   }

   return retCode;
}

//-----------------------------------------------------------------------------

template <>
tDiaResult
dia_SAFeatureSystemSettingsASF::FunctorSendRequest<ExecuteSystemSettingRequestExtendedDataStruct>::operator() ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureSystemSettingsASF::FunctorSendRequest<ExecuteSystemSettingRequestExtendedDataStruct>::operator()");

   tDiaResult retCode = DIA_FAILED;

   SystemSettings1Proxy* pProxy = mpObj->mpSrvPlugin->getProxy();
   if (pProxy)
   {
      dia::LockScope lock(mpObj->mSyncObj);
      mpObj->mLevelACT[DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE] = pProxy->sendExecuteSystemSettingRequest(*mpObj, mpObj->mID, mStrType, mRequestExtDataVec, 0 /*this*/);

      if ( mpObj->mLevelACT[DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE] != 0 )
      {
         DIA_TR_INF("Successfully sent ExecuteSystemSettingRequest (type=\"%s\",id=\"%s\",act=0x%lx)", mStrType.c_str(), mpObj->mID.c_str(), mpObj->mLevelACT[DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE]);
         retCode=DIA_SUCCESS;
      }
      else
      {
         DIA_TR_ERR("Failed to send ExecuteSystemSettingRequest (type=\"%s\",id=\"%s\")", mStrType.c_str(), mpObj->mID.c_str());
      }
   }
   else
   {
      DIA_TR_ERR("##### ASF INTERFACE PROXY \"SystemSettings1Proxy\" for %s NOT AVAILABLE #####", mpObj->mpSrvPlugin->getPortName().c_str());
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSystemSettingsASF::finalizeSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData )
{
   dia_tclFnctTrace trc("dia_SAFeatureSystemSettingsASF::finalizeSystemSetting");

   tDiaResult retCode = DIA_FAILED;

   std::string typeName;
   if ( getSystemSettingTypeName(sysSetTypeUID, typeName) == DIA_SUCCESS )
   {
      if (mLevelACT[DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE] == 0)
      {
         mLevelACT[DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE] = UINTPTR_MAX;
         retCode = mpSrvPlugin->executeServiceFunctor( std::unique_ptr<dia_Functor>(new FunctorSendRequest<FinalizeSystemSettingRequestExtendedDataStruct>(this, typeName, extData)) );
      }
      else
      {
         DIA_TR_ERR("System setting functor Finalize already started (type=\"%s\",id=\"%s\")", typeName.c_str(),mID.c_str());
         retCode=DIA_SUCCESS;
      }
   }
   else
   {
      DIA_TR_INF("System setting type not supported (type=\"%s\",id=\"%s\")", typeName.c_str(),mID.c_str());
      retCode=DIA_SUCCESS;
   }

   return retCode;
}

//-----------------------------------------------------------------------------

template <>
tDiaResult
dia_SAFeatureSystemSettingsASF::FunctorSendRequest<FinalizeSystemSettingRequestExtendedDataStruct>::operator() ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureSystemSettingsASF::FunctorSendRequest<FinalizeSystemSettingRequestExtendedDataStruct>::operator()");

   tDiaResult retCode = DIA_FAILED;

   SystemSettings1Proxy* pProxy = mpObj->mpSrvPlugin->getProxy();
   if (pProxy)
   {
      dia::LockScope lock(mpObj->mSyncObj);
      mpObj->mLevelACT[DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE] = pProxy->sendFinalizeSystemSettingRequest(*mpObj, mpObj->mID, mStrType, mRequestExtDataVec, 0 /*this*/);

      if ( mpObj->mLevelACT[DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE] != 0 )
      {
         DIA_TR_INF("Successfully sent FinalizeSystemSettingRequest (type=\"%s\",id=\"%s\",act=0x%lx)", mStrType.c_str(), mpObj->mID.c_str(), mpObj->mLevelACT[DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE]);
         retCode=DIA_SUCCESS;
      }
      else
      {
         DIA_TR_ERR("Failed to send FinalizeSystemSettingRequest (type=\"%s\",id=\"%s\")", mStrType.c_str(), mpObj->mID.c_str());
      }
   }
   else
   {
      DIA_TR_ERR("##### ASF INTERFACE PROXY \"SystemSettings1Proxy\" for %s NOT AVAILABLE #####", mpObj->mpSrvPlugin->getPortName().c_str());
   }

   return retCode;
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSystemSettingsASF::onPrepareSystemSettingError(const ::boost::shared_ptr< SystemSettings1Proxy >& /*proxy*/, const ::boost::shared_ptr< PrepareSystemSettingError >& error)
{
   dia_tclFnctTrace trc("dia_SAFeatureSystemSettingsASF::onPrepareSystemSettingError");
   DIA_TR_ERR( "##### DBUS ERROR: ErrorName = \"%s\", DBusErrorMessage = \"%s\" #####", error->getName().c_str(), error->getMessage().c_str() );

   act_t act = error->getAct();

   getInstanceOfApplication()->postMessage (
        OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
             OSAL_NEW dia_FunctorFourArgsNoReturnValue<dia_SAFeatureSystemSettingsASF,act_t,dia_UID,dia_enSystemSettingLevel,tDiaResult>(this,&dia_SAFeatureSystemSettingsASF::onSystemSettingResult,act,0,DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE,DIA_FAILED)
       )
   );
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSystemSettingsASF::onPrepareSystemSettingResponse(const ::boost::shared_ptr< SystemSettings1Proxy >& /*proxy*/, const ::boost::shared_ptr< PrepareSystemSettingResponse >& response)
{
   dia_tclFnctTrace trc("dia_SAFeatureSystemSettingsASF::onPrepareSystemSettingResponse");

   act_t act = response->getAct();
   tDiaResult errCode = ( response->getReturnCode() == 0 ) ? DIA_SUCCESS : DIA_FAILED;
   dia_UID typeUID = dia_getHashCodeFromString(response->getSysSetType().c_str());

   getInstanceOfApplication()->postMessage (
        OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
             OSAL_NEW dia_FunctorFourArgsNoReturnValue<dia_SAFeatureSystemSettingsASF,act_t,dia_UID,dia_enSystemSettingLevel,tDiaResult>(this,&dia_SAFeatureSystemSettingsASF::onSystemSettingResult,act,typeUID,DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE,errCode)
       )
   );
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSystemSettingsASF::onExecuteSystemSettingError(const ::boost::shared_ptr< SystemSettings1Proxy >& /*proxy*/, const ::boost::shared_ptr< ExecuteSystemSettingError >& error)
{
   dia_tclFnctTrace trc("dia_SAFeatureSystemSettingsASF::onExecuteSystemSettingError");
   DIA_TR_ERR( "##### DBUS ERROR: ErrorName = \"%s\", DBusErrorMessage = \"%s\" #####", error->getName().c_str(), error->getMessage().c_str() );

   act_t act = error->getAct();

   getInstanceOfApplication()->postMessage (
        OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
             OSAL_NEW dia_FunctorFourArgsNoReturnValue<dia_SAFeatureSystemSettingsASF,act_t,dia_UID,dia_enSystemSettingLevel,tDiaResult>(this,&dia_SAFeatureSystemSettingsASF::onSystemSettingResult,act,0,DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE,DIA_FAILED)
       )
   );
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSystemSettingsASF::onExecuteSystemSettingResponse(const ::boost::shared_ptr< SystemSettings1Proxy >& /*proxy*/, const ::boost::shared_ptr< ExecuteSystemSettingResponse >& response)
{
   dia_tclFnctTrace trc("dia_SAFeatureSystemSettingsASF::onExecuteSystemSettingResponse");

   act_t act = response->getAct();
   tDiaResult errCode = ( response->getReturnCode() == 0 ) ? DIA_SUCCESS : DIA_FAILED;
   dia_UID typeUID = dia_getHashCodeFromString(response->getSysSetType().c_str());

   getInstanceOfApplication()->postMessage (
        OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
             OSAL_NEW dia_FunctorFourArgsNoReturnValue<dia_SAFeatureSystemSettingsASF,act_t,dia_UID,dia_enSystemSettingLevel,tDiaResult>(this,&dia_SAFeatureSystemSettingsASF::onSystemSettingResult,act,typeUID,DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE,errCode)
       )
   );
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSystemSettingsASF::onFinalizeSystemSettingError(const ::boost::shared_ptr< SystemSettings1Proxy >& /*proxy*/, const ::boost::shared_ptr< FinalizeSystemSettingError >& error)
{
   dia_tclFnctTrace trc("dia_SAFeatureSystemSettingsASF::onFinalizeSystemSettingError");
   DIA_TR_ERR( "##### DBUS ERROR: ErrorName = \"%s\", DBusErrorMessage = \"%s\" #####", error->getName().c_str(), error->getMessage().c_str() );

   act_t act = error->getAct();

   getInstanceOfApplication()->postMessage (
        OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
             OSAL_NEW dia_FunctorFourArgsNoReturnValue<dia_SAFeatureSystemSettingsASF,act_t,dia_UID,dia_enSystemSettingLevel,tDiaResult>(this,&dia_SAFeatureSystemSettingsASF::onSystemSettingResult,act,0,DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE,DIA_FAILED)
       )
   );
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSystemSettingsASF::onFinalizeSystemSettingResponse(const ::boost::shared_ptr< SystemSettings1Proxy >& /*proxy*/, const ::boost::shared_ptr< FinalizeSystemSettingResponse >& response)
{
   dia_tclFnctTrace trc("dia_SAFeatureSystemSettingsASF::onFinalizeSystemSettingResponse");

   act_t act = response->getAct();
   tDiaResult errCode = ( response->getReturnCode() == 0 ) ? DIA_SUCCESS : DIA_FAILED;
   dia_UID typeUID = dia_getHashCodeFromString(response->getSysSetType().c_str());

   getInstanceOfApplication()->postMessage (
        OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
             OSAL_NEW dia_FunctorFourArgsNoReturnValue<dia_SAFeatureSystemSettingsASF,act_t,dia_UID,dia_enSystemSettingLevel,tDiaResult>(this,&dia_SAFeatureSystemSettingsASF::onSystemSettingResult,act,typeUID,DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE,errCode)
       )
   );
}

//------------------------------------------------------------------------------

void
dia_SAFeatureSystemSettingsASF::onSystemSettingResult(act_t act, dia_UID Id,dia_enSystemSettingLevel level, tDiaResult result)
{
   dia_tclFnctTrace trc("dia_SAFeatureSystemSettingsASF::onSystemSettingResult");

   dia::LockScope lock(mSyncObj);

   DIA_TR_INF("dia_SAFeatureSystemSettingsASF::onSystemSettingResult: act=0x%lx / mLevelACT[%u]=0x%lx", act, level, mLevelACT[level]);

   if (act == mLevelACT[level])
   {
      mLevelACT[level] = 0;
      getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,Id,level,result);
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureSystemSettingsASF::onSystemSettingResult => ERROR: Spurious act=0x%lx received!!!", act);
   }
}
