/*
 * dia_SAFeatureSystemSettings.h
 *
 *  Created on: 30.08.2011
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#define __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MODULE__
#include <common/framework/sysset/dia_SystemSettingsModule.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SYSTEM_SETTINGS_DIAGLIB_LISTENER__
#include "common/depricated/SystemAdapter/dia_IDiaglibSysSetListener.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_DIAGLIB__
#include "dia_SystemAdapterFeatureDiaglib.h"
#endif

class amt_tclServiceData;

class dia_SAFeatureSystemSettings
   : public dia_SystemAdapterFeatureDiaglib,
     public dia_SystemSettingsModule,   // To handle requests Diag -> Component
     public dia_IDiaglibSysSetListener // To handle requests Component -> Diag
{
public:
   dia_SAFeatureSystemSettings (
         tCString name,
         tU32 u32SystemSetId,
         tU32 u32SystemSetTypes,
         dia_SystemAdapterServicePluginDiaglib& pSrvPlugin
         );

   // destructor
   virtual ~dia_SAFeatureSystemSettings ( void );

   //--------------------------------------------------------------------------
   // Methods inherited from dia_SystemSettingsModule
   //--------------------------------------------------------------------------

   //! prepare the module for the system setting
   virtual tDiaResult prepareSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData );
   //! execute the system setting
   virtual tDiaResult executeSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData );
   //! finalize the system setting
   virtual tDiaResult finalizeSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData );

   //--------------------------------------------------------------------------
   // Methods inherited from dia_IDiaglibSysSetListener
   //--------------------------------------------------------------------------

   virtual tVoid vOnSystemSetResult ( tU32 u32SysSetId, tenSystemSetType enSysSetType, tenSystemSetResult enSystemSetResult, const tDiaglibParamVector& oErrorList );
   virtual tVoid vOnSystemSetPrepareResult ( tenSystemSetResult enSystemSetResult, const tDiaglibParamVector& oErrorList );
   virtual tVoid vOnSystemSetFinished ( tVoid );

   //! return the function IDs managed by this feature
   virtual tDiaResult getFunctionIDs ( std::list<tU16>& results ) const;
   //! return the diaglib IDs managed by this feature
   virtual tDiaResult getDiaglibIDs ( std::list<tU32>& results ) const;

   virtual tDiaResult dispatchMessage (amt_tclBaseMessage *pBaseMessage);

protected:
   // constructor
   dia_SAFeatureSystemSettings ( tVoid ); // Not implemented, do not use

   tDiaResult convertErrorCode (const tDiaglibParamVector& oList) const;

   tenSystemSetType convertType ( dia_UID typeUID ) const;

   dia_UID mSystemSettingTypeUID;
   tU32 mu32SystemSetId;
   tU32 mu32SystemSetTypes;
};

#endif /* __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__ */
