/*!
 * \file       dia_SAFeatureSystemAdapterFactory.h
 *
 * \brief      Proxy to create other ASF system adapters
 *
 * \component  Diagnostics
 *
 * \ingroup    diaCoreSysAdapters
 *
 * \copyright  (c) 2019 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_ADAPTER_FACTORY__
#define __INCLUDED_DIA_SAFEATURE_SYSTEM_ADAPTER_FACTORY__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_ASF__
#include "common/framework/platform/asf/dia_SystemAdapterFeatureASF.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SYSTEM_ADAPTER_FACTORY_LISTENER__
#include "common/interfaces/dia_ISystemAdapterFactoryListener.h"
#endif

#ifndef ASF_SYSTEMADAPTERFACTORYSERVICEPROXY_H
#include "asf/SystemAdapterFactoryServiceProxy.h"
#endif

//-----------------------------------------------------------------------------

using namespace asf::SystemAdapterFactoryService;

class dia_SAFeatureSystemAdapterFactory
   : public dia_SystemAdapterFeatureASF<SystemAdapterFactoryServiceProxy>,
     public SystemAdapterFactoryServiceClientBase,
     public dia_ISystemAdapterFactory
{
public:
   //! constructor
   dia_SAFeatureSystemAdapterFactory ( dia_SystemAdapterServicePluginASF<SystemAdapterFactoryServiceProxy>& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureSystemAdapterFactory();

   //! interface dia_ISystemAdapterFactory
   tDiaResult registerModule ( const std::string& moduleName, const std::vector<dia::IID>& iidList ) override;
   //! interface dia_ISystemAdapterFactory
   tDiaResult createSystemAdapter ( dia::IID iid ) override;

protected:
   //! deprecated default constructor
   dia_SAFeatureSystemAdapterFactory () = delete;

   //! RegisterModuleCallbackIF
   void onRegisterModuleResponse(const ::boost::shared_ptr< SystemAdapterFactoryServiceProxy >&, const ::boost::shared_ptr< RegisterModuleResponse >&) override;
   //! CreateSystemAdapterCallbackIF
   void onCreateSystemAdapterResponse(const ::boost::shared_ptr< SystemAdapterFactoryServiceProxy >&, const ::boost::shared_ptr< CreateSystemAdapterResponse >&) override;
};

#endif /* __INCLUDED_DIA_SAFEATURE_SYSTEM_ADAPTER_FACTORY__ */
