/*
 * dia_SAFeatureSwUpdate.h
 *
 *  Created on: 28.12.2015
 *      Author: nbs3kor
 */

#ifndef DIA_SAFEATURESWUPDATE_H_
#define DIA_SAFEATURESWUPDATE_H_


#include "fcswupdatesrv/FcSwUpdateSrvProxy.h"         //GEN folder
#include "fcswupdatesrv/FcSwUpdateSrvClientBase.h"    //GEN folder

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterFeatureASF.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SWUPDATE__
#include <common/interfaces/dia_ISwUpdate.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SWUPDATE_LISTENER__
#include <common/interfaces/dia_ISwUpdateListener.h>
#endif

using namespace fcswupdatesrv::FcSwUpdateSrv;

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureSwUpdate
   : public dia_SystemAdapterFeatureASF<FcSwUpdateSrvProxy>,
     public FcSwUpdateSrvClientBase,
     public dia_ISwUpdate
{
public:
   //! constructor
   dia_SAFeatureSwUpdate (dia_SystemAdapterServicePluginASF<FcSwUpdateSrvProxy>& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureSwUpdate();

   //! start monitoring of properties
   virtual tDiaResult startMonitoring();
   //! stop monitoring of properties
   virtual tDiaResult stopMonitoring();

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_ISwUpdate methods
   //
   //-------------------------------------------------------------------------
   virtual tDiaResult getSwUpdateInfo ( const dia_tHistoryScope& historyScope );

   virtual tDiaResult enterRecoveryMode ( void );

   virtual tDiaResult updateAllSubModules (  );

   //-------------------------------------------------------------------------
   //
   // Overloaded FcSwUpdateSrvClientBase methods
   //
   //-------------------------------------------------------------------------
   virtual void onGetUpdateHistoryScopedError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy,
                                              const ::boost::shared_ptr< GetUpdateHistoryScopedError >& error);

   virtual void onGetUpdateHistoryScopedResponse(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy,
                                                 const ::boost::shared_ptr< GetUpdateHistoryScopedResponse >& response);

   virtual void onEnterRecoveryModeError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy,
                                         const ::boost::shared_ptr< EnterRecoveryModeError >& error);

   virtual void onEnterRecoveryModeResponse(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy,
                                            const ::boost::shared_ptr< EnterRecoveryModeResponse >& response);

   virtual void onUpdateSelectReleaseByFileError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, 
                                                 const ::boost::shared_ptr< UpdateSelectReleaseByFileError >& error);

   virtual void onUpdateSelectReleaseByFileResponse(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, 
                                                    const ::boost::shared_ptr< UpdateSelectReleaseByFileResponse >& response);
													
protected:
   //! deprecated default constructor
   dia_SAFeatureSwUpdate ();

   // Update to listeners
   virtual void vOnSwUpdateInfo(const std::vector<dia_tProgramHistory>& progInfo);
   virtual void vOnNoOfSwReUpdate(tU32 numberOfUpateLogs);
   virtual void onUpdateSelectReleaseByFileResponse(bool bOk, dia_eSwUpdateError eError);
   virtual void onEnterRecoveryModeResponse(bool bRecoveryMode);

};

#endif /* DIA_SAFEATURESWUPDATE_H_ */
