/*
 * dia_SAFeatureSensorPV.h
 *
 *  Created on: 10.09.2015
 *      Author: wgl2hi
 */

#ifndef __DIA_SAFEATURESENSORPV_H__ 
#define __DIA_SAFEATURESENSORPV_H__ 

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

// implemented interfaces
#ifndef __INCLUDED_DIA_INTERFACE_SENSORSPEED_LISTENER__
#include "common/interfaces/dia_ISensorSpeedListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SENSORPOSITION_LISTENER__
#include "common/interfaces/dia_ISensorPositionListener.h"
#endif

class amt_tclServiceData;

class dia_SAFeatureSensorPV
   : public dia_SystemAdapterFeature,
     public dia_ISensorSpeed,
     public dia_ISensorPosition
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SAFeatureSensorPV);

public:
   //! default class constructor
   dia_SAFeatureSensorPV ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin);
   //! class destructor
   virtual ~dia_SAFeatureSensorPV ();

   // implementation of the dia_ISensorSpeed interface
   virtual tDiaResult getSensorSpeed ( void );
   // implementation of the dia_ISensorPosition interface
   virtual tDiaResult getSensorPosition ( void );

protected:
   void vHandleSensorSpeed ( amt_tclServiceData* poMessage ) const;
   void vHandleSensorPosition ( amt_tclServiceData* poMessage ) const;

   tBool bSendMessage (
           const tU8  u8MessageType,
           const tU16 u16FID,
           const tU8  u8Opcode,
           const tU16 u16MsgLength,
           const tU8  u8MsgBuffer[]
           );

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureSensorPV)
};

#endif /* __DIA_SAFEATURESENSORPV_H__ */
