/*
 * dia_SAFeatureRemoteControl.h
 *
 *  Created on: 11.01.2013
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_SAFEATURE_REMOTE_CONTROL__
#define __INCLUDED_DIA_SAFEATURE_REMOTE_CONTROL__

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_DIAGLIB__
#include "dia_SystemAdapterFeatureDiaglib.h"
#endif

#ifndef __INCLUDED_DIA_REMOTE_CONTROL_PLUGIN__
#include "common/framework/application/dia_RemoteControlPlugin.h"
#endif

#ifndef __INCLUDED_DIA_DIAGLIB_IOCONTROL_LISTENER__
#include "common/depricated/SystemAdapter/dia_IDiaglibIoControlListener.h"
#endif

//-----------------------------------------------------------------------------

class dia_SAFeatureRemoteControl
   : public dia_SystemAdapterFeatureDiaglib,
     public dia_RemoteControlPlugin,
     public dia_IDiaglibIoControlListener
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SAFeatureRemoteControl);

public:
   //! class constructor
   dia_SAFeatureRemoteControl ( tCString name, dia_SystemAdapterServicePluginDiaglib& pSrvPlugin );
   //! class destructor
   virtual ~dia_SAFeatureRemoteControl ( tVoid );

   virtual tDiaResult getDiaglibIDs ( std::list<tU32>& results ) const;

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_RemoteControlPlugin methods
   //
   //-------------------------------------------------------------------------

   //! set remote control to the specified mode
   virtual tDiaResult requestRemoteControlMode ( dia_eRemoteCtrlMode mode, dia_RemoteControlSettings settings = DIA_C_U32_REMOTE_CTRL_SETTINGS_DEFAULT  );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IDiaglibIoControlListener methods
   //
   //-------------------------------------------------------------------------

   //! receive result from diaglib
   virtual tVoid vOnIoCtrlResult ( tU32 ioctrlID, tenIoCtrlResult enResult, tenIoControlAction actionId, const tDiaglibParamVector& data );

protected:
   //! handle incoming CCA message
   tVoid vHandleIOControl ( amt_tclServiceData* poMessage );

protected:
   //! diaglib ioctrl id
   tU32 mDiagLibIOCtrlID;

   //! declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureRemoteControl)
};

#endif
