/************************************************************************
* FILE:         dia_SAFeatureIPOD.cpp
* SW-COMPONENT: Diagnostic application
*----------------------------------------------------------------------
*
* DESCRIPTION: Systemadapter for Apple Chip
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 23.09.10  | TMS Plischke       | ETG-Traces added
* 12.02.14  | shw2abt            | Update for MIBE
*
*************************************************************************/

#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#include "dia_SAFeatureIPOD.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
#include <project/framework/sysadapters/dia_SAFeatureDiaglib.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include <common/framework/sysadapters/dia_SystemAdapterFacade.h>
#endif

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_STDVISITORS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_ERRORCODES
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_SYSADAPT
#include "trcGenProj/Header/dia_SAFeatureIPOD.cpp.trc.h"
#endif


#define DIA_U8_E_IPOD_COMMUNICATION_ERROR       ((tU8 ) 0x01)
#define DIA_U8_E_IPOD_DEVICE_CONNECTED          ((tU8 ) 0x02)
#define DIA_U8_E_IPOD_CHECKSUM_ERROR            ((tU8 ) 0x10)
#define DIA_U8_E_IPOD_RAMCHECK_ERROR            ((tU8 ) 0x20)
#define DIA_U8_E_IPOD_PRIVATE_KEY_ERROR         ((tU8 ) 0x40)
#define DIA_U8_E_IPOD_CERTIFICATE_ERROR         ((tU8 ) 0x80)


// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureIPOD, ahl_tclBaseWork)
   ON_MESSAGE(MIDW_DIAGLIBFI_C_U16_ROUTINECONTROL, vHandleRoutineControl)
   ON_MESSAGE(MIDW_DIAGLIBFI_C_U16_DIAGNOSISDATA,  vHandleDiagnosisData)
END_MSG_MAP()

//------------------------------------------------------------------------------

dia_SAFeatureIPOD::dia_SAFeatureIPOD (
      tCString name,    // feature name
      dia_SystemAdapterServicePluginDiaglib& pSrvPlugin
   )
    : dia_SystemAdapterFeatureDiaglib(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureIPOD::dia_SAFeatureIPOD");
}

//------------------------------------------------------------------------------

dia_SAFeatureIPOD::~dia_SAFeatureIPOD ( void )
{
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureIPOD::getDiaglibIDs ( std::list<tU32>& results ) const
{
   results.push_back(ROUTINEID_IPOD_SELF);
   results.push_back(DATAID_IPOD_FIRMWARE);

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureIPOD::vSelfTest ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureIPOD::vSelfTest");

   tDiaglibParamVector vecRequest;

   tBool bRetVal = dia_SAFeatureDiaglib::bRoutineControlStart(ROUTINEID_IPOD_SELF, 0, vecRequest, mpSrvPlugin);
   tDiaResult retCode = (bRetVal ? DIA_SUCCESS : DIA_FAILED);

   DIA_TR_INF("dia_SAFeatureIPOD::vSelfTest => post the message to IPOD");

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureIPOD::vGetVersion ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureIPOD::vGetVersion");

   tBool bRetVal = dia_SAFeatureDiaglib::bDiagDataReadStart(DATAID_IPOD_FIRMWARE, mpSrvPlugin);
   tDiaResult retCode = (bRetVal ? DIA_SUCCESS : DIA_FAILED);

   DIA_TR_INF("dia_SAFeatureIPOD::vGetVersion => post the message to Diaglib %d", retCode);

   return retCode;
}

//------------------------------------------------------------------------------

void
dia_SAFeatureIPOD::vHandleRoutineControl ( amt_tclServiceData* poMessage )
{
   dia_tclFnctTrace trc("dia_SAFeatureIPOD::vHandleRoutineControl");

    if ( !poMessage )
    {
        DIA_TR_ERR("dia_SAFeatureIPOD::vHandleRoutineControl => ERROR: Invalid Message Pointer !!!");
    }
    else
    {
       (void)dia_SAFeatureDiaglib::u32EvalRoutineCtrlMessage(poMessage, this);
    }

    // delete now if not delted
    if(poMessage != NULL)
    {
      (void)poMessage->bDelete();
      poMessage = NULL;
    }
}  //lint !e438 set to NULL done for security reasons & framework

//----------------------------------------------------------------------------------------

void
dia_SAFeatureIPOD::vHandleDiagnosisData ( amt_tclServiceData* poMessage )
{
   dia_tclFnctTrace trc("dia_SAFeatureIPOD::vHandleDiagnosisData");

    if ( !poMessage )
    {
        DIA_TR_ERR("dia_SAFeatureIPOD::vHandleDiagnosisData => ERROR: Invalid Message Pointer !!!");
    }
    else
    {
       (void)dia_SAFeatureDiaglib::u32EvalDiagnosisDataCtrlMessage(poMessage, this);
    }

    // delete now if not delted
    if(poMessage != NULL)
    {
      (void)poMessage->bDelete();
      poMessage = NULL;
    }
}  //lint !e438 set to NULL done for security reasons & framework

//----------------------------------------------------------------------------------------

void dia_SAFeatureIPOD::vOnRoutineCtrlResult (      tU32 u32RoutineId,
                                                     tenRoutineCtrlResult enRoutineStatus,
                                                     const tDiaglibParamVector& oStartResult
                                                 )
{
   dia_tclFnctTrace trc("dia_SAFeatureIPOD::vOnRoutineCtrlResult");

   switch (u32RoutineId)
   {
      case ROUTINEID_IPOD_SELF:
      {
         DIA_TR_INF("dia_SAFeatureIPOD::vOnRoutineCtrlResult => ROUTINEID_IPOD_SELF");

         dia_IMediaIPODListener* pListener = OSAL_NULL;

         if ((querySysAdapterListener<dia_IMediaIPODListener>(&pListener) == DIA_SUCCESS) &&
               (pListener != OSAL_NULL))
         {
            if ( enRoutineStatus == EN_ROUTINE_CONTROL_OK )
            {
               DIA_TR_INF("dia_SAFeatureIPOD::vOnRoutineCtrlResult => enRoutineStatus == EN_ROUTINE_CONTROL_OK");
               pListener->vOnSelfTestDone(DIA_SUCCESS); //vOnIPODSelfTestResult();
            }//if(enRoutineStatus == EN_ROUTINE_CONTROL_OK)
            else
            {
               DIA_TR_INF("dia_SAFeatureIPOD::vOnRoutineCtrlResult => enRoutineStatus != EN_ROUTINE_CONTROL_OK");
               if( oStartResult.size() >= 1 && oStartResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               {
                  //tenInternalError enErrorCode = oStartResult[0].u8ErrorValue;

                  DIA_TR_ERR("dia_SAFeatureIPOD::vOnRoutineCtrlResult => ERROR: EN_PARAMETER_TYPE_U8ERROR = 0x%02x", oStartResult[0].u8ErrorValue);

                  pListener->vOnSelfTestDone(DIA_FAILED); //vOnIPODSelfTestError(enErrorCode);
               }
               else if (oStartResult.size() >= 1)
               {
                  tU8 resultMask = oStartResult[ROUTINEID_IPOD_SELF_RESULT_u8ResultMask].u8Value;

                  if ( resultMask & DIA_U8_E_IPOD_COMMUNICATION_ERROR )
                  {
                     DIA_TR_INF("dia_SAFeatureIPOD::evalIPODMessage => IPOD SELFTEST : Communication Error");
                  }
                  if ( resultMask & DIA_U8_E_IPOD_DEVICE_CONNECTED )
                  {
                     DIA_TR_INF("dia_SAFeatureIPOD::evalIPODMessage => IPOD SELFTEST : Unable to run self  test while IPOD device is connected");
                  }
                  if ( resultMask & DIA_U8_E_IPOD_CHECKSUM_ERROR )
                  {
                     DIA_TR_INF("dia_SAFeatureIPOD::evalIPODMessage => IPOD SELFTEST : Checksum Error");
                  }
                  if ( resultMask & DIA_U8_E_IPOD_RAMCHECK_ERROR )
                  {
                     DIA_TR_INF("dia_SAFeatureIPOD::evalIPODMessage => IPOD SELFTEST : RAM Check Error");
                  }
                  if ( resultMask & DIA_U8_E_IPOD_PRIVATE_KEY_ERROR )
                  {
                     DIA_TR_INF("dia_SAFeatureIPOD::evalIPODMessage => IPOD SELFTEST : Private Key Error");
                  }
                  if ( resultMask & DIA_U8_E_IPOD_CERTIFICATE_ERROR )
                  {
                     DIA_TR_INF("dia_SAFeatureIPOD::evalIPODMessage => IPOD SELFTEST : Certificate Error");
                  }

                  pListener->vOnSelfTestDone(DIA_FAILED); //vOnIPODSelfTestError(resultMask);

               }// if( oRoutineResult.size() >= 1 && oRoutineResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               else
               {
                  pListener->vOnSelfTestDone(DIA_FAILED); //vOnIPODSelfTestError(EN_ERROR_NO_DATA);
               }
            }// else // if ( enRoutineStatus == EN_ROUTINE_CONTROL_OK )
         }// if(pListener != OSAL_NULL)
         else
         {
            DIA_ASSERT_ALWAYS();
         }
         break;
      }// case ROUTINEID_IPOD_SELF:

      default:
      {
         DIA_ASSERT_ALWAYS();
      }
   }// switch (u32RoutineId)
}

//-----------------------------------------------------------------------------

void dia_SAFeatureIPOD::vOnDiagnosisDataResult (       tU32 u32DiagnosisDataId,
                                                        tenDiagDataResult enResult,
                                                        const tDiaglibParamVector& oResult )
{
   dia_tclFnctTrace trc("dia_SAFeatureIPOD::vOnDiagnosisDataResult");

   switch (u32DiagnosisDataId)
   {
      case DATAID_IPOD_FIRMWARE:
      {
         DIA_TR_INF("dia_SAFeatureIPOD::vOnDiagnosisDataResult => case: DATAID_IPOD_FIRMWARE");
         dia_IMediaIPODListener* pListener = OSAL_NULL;
         if((querySysAdapterListener<dia_IMediaIPODListener>(&pListener) == DIA_SUCCESS) && (OSAL_NULL != pListener))
         {
            if ( enResult == EN_DIAGDATA_OK )
            {
               DIA_TR_INF("dia_SAFeatureIPOD::vOnDiagnosisDataResult => enResult == EN_DIAGDATA_OK");
               if( oResult.size() >= DATAID_IPOD_FIRMWARE_READ_RESULT_LEN)
               {
                  tU8 u8Major = oResult[DATAID_IPOD_FIRMWARE_READ_RESULT_u8MayorVersion].u8Value;
                  tU8 u8Minor = oResult[DATAID_IPOD_FIRMWARE_READ_RESULT_u8MinorVersion].u8Value;
                  DIA_TR_INF("dia_SAFeatureIPOD::vOnDiagnosisDataResult => Call Service Listener");
                  pListener->vOnSoftwareVersion(u8Major, u8Minor);
               }
               else
               {
                  DIA_TR_ERR("dia_SAFeatureIPOD::vOnDiagnosisDataResult => ERROR: No Data Available");
#if 0
                  //TODO: Error Handling
                  pListener->vOnRvcStatusError(DIA_E_INVALID_LENGTH);
#endif
               }
            }//if(enResult == EN_DIAGDATA_OK)
            else
            {
               DIA_TR_INF("dia_SAFeatureIPOD::vOnDiagnosisDataResult => enResult != EN_DIAGDATA_OK");

#if 0
               //TODO: Error Handling
               if( oResult.size() >= 1 && oResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               {
                  tenInternalError enErrorCode = oResult[0].u8ErrorValue;
                  pListener->vOnRvcStatusError(enErrorCode);
               }// if( oRoutineResult.size() >= 1 && oRoutineResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               else
               {
                  pListener->vOnRvcStatusError(DIA_E_INVALID_LENGTH);
               }
#endif
            }// else //if(enResult == EN_DIAGDATA_OK)
         }// if(OSAL_NULL != pListener
         else
         {
            DIA_TR_ERR("dia_SAFeatureIPOD::vOnDiagnosisDataResult => ERROR: OSAL_NULL == pListener");
            DIA_ASSERT_ALWAYS();
         }
         break;
      }// case DATAID_IPOD_FIRMWARE:

      default:
      {
         DIA_ASSERT_ALWAYS();
      }
   }// switch (u32DiagnosisDataId)
}

