/*!
 * \file       dia_SAFeatureHeatControlStub.h
 *
 * \brief      Stub to simulate input from Heat Control
 *
 * \details    -
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreSysAdapters
 *
 * \copyright  (c) 2019 Robert Bosch Car Multimedia
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __DIA_SA_FEATURE_HEAT_CONTROL_STUB__
#define __DIA_SA_FEATURE_HEAT_CONTROL_STUB__

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_HEATCONTROL_LISTENER__
#include "common/interfaces/dia_IHeatControlListener.h"
#endif

#ifndef __INCLUDED_DIA_SELF_TIMER__
#include "common/framework/application/dia_SelfTimer.h"
#endif

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------
namespace dia {

class SAFeatureHeatControlStub:
     public dia_IHeatControl
{
public:

   struct MsgTimeout {
   };

   SAFeatureHeatControlStub ();
   virtual ~SAFeatureHeatControlStub () {}



   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IHeatControl methods
   //
   //-------------------------------------------------------------------------

   //! request detailed information about the internal temperatures of the RNS
   virtual tDiaResult getTemperatures ( dia_eHeatCtrlTemperatureClass tempClass = DIA_EN_HEATCTRL_TEMPERATURE_CLASS_ALL);

   virtual tDiaResult getSensorState (dia_eHeatCtrlTemperatureClass tempClass = DIA_EN_HEATCTRL_TEMPERATURE_CLASS_ALL ) { 
      DIA_PARAMETER_INTENTIONALLY_UNUSED(tempClass);
      return DIA_E_NOT_IMPLEMENTED; 
   }

   virtual tDiaResult getFuncState ( ) { return DIA_E_NOT_IMPLEMENTED; }


   virtual tDiaResult getFanSpeed ( ) { return DIA_E_NOT_IMPLEMENTED; }

   void onTimeout(MsgTimeout *msg);


   private:
   RefCounter mRefCounter;
   SelfTimer<SAFeatureHeatControlStub, MsgTimeout> mTimer;

};

}
#endif
