/*!
 * \file       dia_SAFeatureHeatControlStub.cpp
 *
 * \brief      Stub to simulate input from Heat Control
 *
 * \details    -
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreSysAdapters
 *
 * \copyright  (c) 2019 Robert Bosch Car Multimedia
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __DIA_SA_FEATURE_HEAT_CONTROL_STUB__
#include "common/framework/sysadapters/dia_SAFeatureHeatControlStub.h"
#endif

namespace dia {

SAFeatureHeatControlStub::SAFeatureHeatControlStub():
   mTimer(this, this->mRefCounter)
{
   ScopeTrace oTrace("SAFeatureHeatControlStub:SAFeatureHeatControlStub()");
}

tDiaResult SAFeatureHeatControlStub::getTemperatures ( dia_eHeatCtrlTemperatureClass /* tempClass */) {
   ScopeTrace oTrace("SAFeatureHeatControlStub:getTemperatures()");
   // handle request on timeout to simulate async communication with heat-control
   mTimer.start(200);
   return DIA_SUCCESS;
}      

void SAFeatureHeatControlStub::onTimeout(MsgTimeout * /* msg */) {
   static const uint32_t propertyEntrySize=7;
   
   dia_IHeatControlListener* pListener = nullptr;
   querySysAdapterListener<dia_IHeatControlListener>(&pListener);
   if (nullptr == pListener) {
      DIA_TR_ERR("SAFeatureHeatControlStub:getTemperatures(): no listener");
      return;
   }
   
   
   std::vector<tU8> propDataVec;
   tDiaResult retCode = dia_getProperty(DIA_PROP_NEXT_TEMPERATURE_HISTOGRAM,propDataVec);
   if (retCode != DIA_SUCCESS) {
      DIA_TR_ERR("SAFeatureHeatControlStub:getTemperatures(): could not read property");
   }
   
   uint32_t propLen=(uint32_t)propDataVec.size();
   if (propLen % propertyEntrySize) {
      DIA_TR_ERR("SAFeatureHeatControlStub:getTemperatures(): invalid prop-len:%u", propLen);
   }
   
   std::list<dia_tHeatCtrlTemperature> outList;
   uint32_t numEntries=propLen / propertyEntrySize;
   for (uint32_t i=0; i<numEntries;++i) {
      dia_tHeatCtrlTemperature outEntry;
      uint8_t const *pRawEntry=&(propDataVec[0]) + i * propertyEntrySize;
      outEntry.mID=(dia_eHeatCtrlTemperatureID)utils::getU32(pRawEntry + 0);
      outEntry.mTemperature=(int16_t)utils::getU16(pRawEntry + 4);
      outEntry.mDiaQuality=(dia_eHeatCtrlTemperatureQuality)pRawEntry[6];
      outList.push_back(outEntry);
   }
   
   pListener->vOnTemperatureInfo(outList);
   
}

}
