/*
 * dia_SAFeatureGNSS.cpp
 *
 *  Created on: 13.08.2012
 *      Author: sta8hi
 *
 *---------------------------------------------------------------------------------------
 * Date        | Author        | Modification
 * 09.24.14    | JSE5KOR       | Jira issue fix SUZUKI-16737
 * 09.02.16    | BMA9KOR       | Updated vHandleGNSSData for GPS Reception level (AIVI-26188)
 * 26.10.16	   | MKY6KOR	   | Updated vHandleGNSSData (NCG3D-20763)
 ***************************************************************************************/

// system adapters
#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI

#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_TYPES
#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_FUNCTIONIDS
#include "sensor_fi_if.h"

#else

#define CMB_FI_S_IMPORT_INTERFACE_CMB_SENSORFI_TYPES
#define CMB_FI_S_IMPORT_INTERFACE_CMB_SENSORFI_FUNCTIONIDS
#include "cmb_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#endif
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard


#ifndef __INCLUDED_DIA_INTERFACE_SENSOR_LISTENER__
#include <common/interfaces/dia_ISensorListener.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_GNSS_LISTENER__
#include "common/interfaces/dia_IGNSSListener.h"
#endif

#include "dia_SAFeatureGNSS.h"


// MESSAGE MAP:
// Such a map and an own handler is needed for every service you are accessing!
// Enter the function IDs (FID) and the corresponding functions here.
// The function will be called when a message with the corresponding FID arrives

BEGIN_MSG_MAP(dia_SAFeatureGNSS, dia_SystemAdapterFeature)
#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
   ON_MESSAGE(SENSOR_LOCATIONFI_C_U16_GNSSDATA,                vHandleGNSSData)
   ON_MESSAGE(SENSOR_LOCATIONFI_C_U16_GNSSSATSYSTEM,           vHandleGNSSSystem)
   ON_MESSAGE(SENSOR_LOCATIONFI_C_U16_DIAGGNSSSATSYSTEM,       vHandleDiagGNSSSystem)
   ON_MESSAGE(SENSOR_LOCATIONFI_C_U16_GNSSCONFIGDATA,          vHandleGNSSConfigData)
#else
   ON_MESSAGE(CMB_SENSORFI_C_U16_GPSEXTDATA,                   vHandleGNSSExtendedData)
#endif

END_MSG_MAP()

//------------------------------------------------------------------------------

#ifndef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
bool dia_gps_compare_snr(const cmb_fi_tcl_GpsBigVarData& left_gps_data, const cmb_fi_tcl_GpsBigVarData& right_gps_data)
{
    return ((tU8)left_gps_data.CarrierToNoiseRatio > (tU8)right_gps_data.CarrierToNoiseRatio);
}
#endif

//------------------------------------------------------------------------------

dia_SAFeatureGNSS::dia_SAFeatureGNSS (
      tCString name,    // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureGNSS::dia_SAFeatureGNSS");
}

//-----------------------------------------------------------------------------

dia_SAFeatureGNSS::~dia_SAFeatureGNSS ( void )
{}

//-----------------------------------------------------------------------------

#if 0

tDiaResult
dia_SAFeatureGNSS::getGNSSAntennaCurrent ( tVoid )
{
    dia_tclFnctTrace trc("dia_SAFeatureGNSS::getGNSSAntennaCurrent()");

    tDiaResult retCode = DIA_FAILED;
#ifndef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
       DIA_TR_INF("dia_SAFeatureGNSS::getGNSSAntennaCurrent - send message.");
       gm_tclEmptyMessage oMessage (
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          CMB_SENSORFI_C_U16_ANTENNACURRENT,
          CCA_C_U8_OPCODE_GET
       );

         if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
          retCode = DIA_SUCCESS;
          DIA_TR_INF("dia_SAFeatureGNSS::getGNSSAntennaCurrent - transmitMessage success.");
       } else {
          DIA_TR_INF("dia_SAFeatureGNSS::getGNSSAntennaCurrent - transmitMessage failed.");
       }
    } else {
       DIA_TR_INF("dia_SAFeatureGNSS::getGNSSAntennaCurrent - getRegistrationID failed.");
       DIA_TR_INF("dia_SAFeatureGNSS::getGNSSAntennaCurrent - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }
#endif
    return retCode;
}

#endif

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureGNSS::getGNSSData ()
{
    dia_tclFnctTrace trc("dia_SAFeatureGNSS::getGNSSData()");

    tDiaResult retCode = DIA_FAILED;

    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
       DIA_TR_INF("dia_SAFeatureGNSS::getGNSSData - send message.");
#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
/*       sensor_locationfi_tclMsgGnssDataGet oMsgData;
       fi_tclVisitorMessage oMessage(oMsgData);
       mpSrvPlugin->vInitServiceData(oMessage, SENSOR_LOCATIONFI_C_U16_GNSSDATA, AMT_C_U8_CCAMSG_OPCODE_GET);*/
       gm_tclEmptyMessage oMessage (
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          SENSOR_LOCATIONFI_C_U16_GNSSDATA,
          CCA_C_U8_OPCODE_GET
       );
#else
       gm_tclEmptyMessage oMessage (
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          CMB_SENSORFI_C_U16_GPSEXTDATA,
          CCA_C_U8_OPCODE_GET
       );
#endif

       if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
          retCode = DIA_SUCCESS;
          DIA_TR_INF("dia_SAFeatureGNSS::getGNSSData - transmitMessage success.");
       } else {
          DIA_TR_INF("dia_SAFeatureGNSS::getGNSSData - transmitMessage failed.");
       }
    } else {
       DIA_TR_INF("dia_SAFeatureGNSS::getGNSSData - getRegistrationID failed.");
       DIA_TR_INF("dia_SAFeatureGNSS::getGNSSData - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }
    return retCode;
}
//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureGNSS::getGNSSConfigData ()
{
    dia_tclFnctTrace trc("dia_SAFeatureGNSS::getGNSSConfigData()");
    tDiaResult retCode = DIA_FAILED;
#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
       DIA_TR_INF("dia_SAFeatureGNSS::getGNSSConfigData - send message.");
/*       sensor_locationfi_tclMsgGnssConfigDataGet oMsgData;
       fi_tclVisitorMessage oMessage(oMsgData);
       mpSrvPlugin->vInitServiceData(oMessage, SENSOR_LOCATIONFI_C_U16_GNSSCONFIGDATA, AMT_C_U8_CCAMSG_OPCODE_GET);*/
       gm_tclEmptyMessage oMessage (
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          SENSOR_LOCATIONFI_C_U16_GNSSCONFIGDATA,
          CCA_C_U8_OPCODE_GET
       );

       if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
          retCode = DIA_SUCCESS;
          DIA_TR_INF("dia_SAFeatureGNSS::getGNSSConfigData - transmitMessage success.");
       } else {
          DIA_TR_INF("dia_SAFeatureGNSS::getGNSSConfigData - transmitMessage failed.");
       }
    }
    else
    {
       DIA_TR_INF("dia_SAFeatureGNSS::getGNSSConfigData - getRegistrationID failed.");
       DIA_TR_INF("dia_SAFeatureGNSS::getGNSSConfigData - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }
#endif
    return retCode;
}

//-----------------------------------------------------------------------------
#if 0
tDiaResult
dia_SAFeatureGNSS::getGNSSExtendedData ( tVoid )
{
    dia_tclFnctTrace trc("dia_SAFeatureGNSS::getGNSSAntennaStatus()");

    tDiaResult retCode = DIA_FAILED;
#ifndef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
       DIA_TR_INF("dia_SAFeatureGNSS::getGNSSAntennaStatus - send message.");
       gm_tclEmptyMessage oMessage (
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          CMB_SENSORFI_C_U16_GPSEXTDATA,
          CCA_C_U8_OPCODE_GET
       );

         if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
          retCode = DIA_SUCCESS;
          DIA_TR_INF("dia_SAFeatureGNSS::getGNSSAntennaStatus - transmitMessage success.");
       } else {
          DIA_TR_INF("dia_SAFeatureGNSS::getGNSSAntennaStatus - transmitMessage failed.");
       }
    } else {
       DIA_TR_INF("dia_SAFeatureGNSS::getGNSSAntennaStatus - getRegistrationID failed.");
       DIA_TR_INF("dia_SAFeatureGNSS::getGNSSAntennaStatus - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }
#endif
    return retCode;
}
#endif

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureGNSS::getGNSSSystem ( void )
{
    dia_tclFnctTrace trc("dia_SAFeatureGNSS::getGNSSSystem()");

    tDiaResult retCode = DIA_FAILED;

    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
       DIA_TR_INF("dia_SAFeatureGNSS::getGNSSSystem - send message.");
#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
/*       sensor_locationfi_tclMsgGnssSatSystemGet oMsgData;
       fi_tclVisitorMessage oMessage(oMsgData);
       mpSrvPlugin->vInitServiceData(oMessage, SENSOR_LOCATIONFI_C_U16_GNSSSATSYSTEM, AMT_C_U8_CCAMSG_OPCODE_GET);*/
       gm_tclEmptyMessage oMessage (
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          SENSOR_LOCATIONFI_C_U16_GNSSSATSYSTEM,
          CCA_C_U8_OPCODE_GET
       );
#else
       gm_tclEmptyMessage oMessage (
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          CMB_SENSORFI_C_U16_GNSSSATSYSTEM,
          CCA_C_U8_OPCODE_GET
       );
#endif

       if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
          retCode = DIA_SUCCESS;
          DIA_TR_INF("dia_SAFeatureGNSS::getGNSSSystem - transmitMessage success.");
       } else {
          DIA_TR_INF("dia_SAFeatureGNSS::getGNSSSystem - transmitMessage failed.");
       }
    } else {
       DIA_TR_INF("dia_SAFeatureGNSS::getGNSSSystem - getRegistrationID failed.");
       DIA_TR_INF("dia_SAFeatureGNSS::getGNSSSystem - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }

    return retCode;
}
//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureGNSS::getDiagGNSSSystem ( void )
{
    dia_tclFnctTrace trc("dia_SAFeatureGNSS::getDiagGNSSSystem()");

    tDiaResult retCode = DIA_FAILED;

    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
       DIA_TR_INF("dia_SAFeatureGNSS::getDiagGNSSSystem - send message.");
#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
/*       sensor_locationfi_tclMsgDiagGnssSatSystemGet oMsgData;
       fi_tclVisitorMessage oMessage(oMsgData);
       mpSrvPlugin->vInitServiceData(oMessage, SENSOR_LOCATIONFI_C_U16_DIAGGNSSSATSYSTEM, AMT_C_U8_CCAMSG_OPCODE_GET);*/
       gm_tclEmptyMessage oMessage (
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          SENSOR_LOCATIONFI_C_U16_DIAGGNSSSATSYSTEM,
          CCA_C_U8_OPCODE_GET
       );
#else
       //kaa1hi: missing declaration of oMessage
       DIA_TR_ERR("dia_SAFeatureGNSS::getDiagGNSSSystem - ERROR missing declaration of oMessage");
#endif

#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI    //kaa1hi: please remove this line if oMessage is defined in all cases
       if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
       {
          retCode = DIA_SUCCESS;
          DIA_TR_INF("dia_SAFeatureGNSS::getDiagGNSSSystem - transmitMessage success.");
       }
       else
       {
          DIA_TR_INF("dia_SAFeatureGNSS::getDiagGNSSSystem - transmitMessage failed.");
       }
#endif
    }
    else
    {
       DIA_TR_INF("dia_SAFeatureGNSS::getDiagGNSSSystem - getRegistrationID failed.");
       DIA_TR_INF("dia_SAFeatureGNSS::getDiagGNSSSystem - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }

    return retCode;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureGNSS::setGNSSSystem ( tU8 mode )
{
   dia_tclFnctTrace trc("dia_SAFeatureGNSS::setGNSSSystem()");
   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("dia_SAFeatureGNSS::setGNSSSystem - send message.");

       if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
         //fill data with the setting
#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
         sensor_locationfi_tclMsgGnssSatSystemSet oMsgData;
         oMsgData.TargetGnssSatSys.u8Value = mode;
         fi_tclVisitorMessage oMessage(oMsgData);
         mpSrvPlugin->vInitServiceData(oMessage, SENSOR_LOCATIONFI_C_U16_GNSSSATSYSTEM, AMT_C_U8_CCAMSG_OPCODE_SET);
#else
         cmb_sensorfi_tclMsgGnssSatSystemSet oMsgData;
         if (mode == 0) {
            oMsgData.TargetGnssSatSys.u8Value = cmb_fi_tcl_b8_GnssSatSys::FI_C_U8_BIT_GNSS_SATSYS_GPS;
            DIA_TR_INF("dia_SAFeatureGNSS::setGNSSSystem - GnssSatSys::FI_C_U8_BIT_GNSS_SATSYS_GPS.");
         } else if (mode == 1) {
            oMsgData.TargetGnssSatSys.u8Value = cmb_fi_tcl_b8_GnssSatSys::FI_C_U8_BIT_GNSS_SATSYS_GLONASS;
            DIA_TR_INF("dia_SAFeatureGNSS::setGNSSSystem - GnssSatSys::FI_C_U8_BIT_GNSS_SATSYS_GLONASS.");
         }

         fi_tclVisitorMessage oMessage(oMsgData);
         mpSrvPlugin->vInitServiceData(oMessage, CMB_SENSORFI_C_U16_GNSSSATSYSTEM, AMT_C_U8_CCAMSG_OPCODE_SET);
#endif

         if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
            retCode = DIA_SUCCESS;
            DIA_TR_INF("dia_SAFeatureGNSS::setGNSSSystem - transmitMessage success.");
         } else {
            DIA_TR_ERR("dia_SAFeatureGNSS::setGNSSSystem - transmitMessage failed.");
         }
      }
    } else {
       DIA_TR_ERR("dia_SAFeatureGNSS::setGNSSSystem - getRegistrationID failed.");
       DIA_TR_ERR("dia_SAFeatureGNSS::setGNSSSystem - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }

    return retCode;
}
//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureGNSS::setDiagGNSSSystem ( tU8 mode )
{
   dia_tclFnctTrace trc("dia_SAFeatureGNSS::setDiagGNSSSystem()");
   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
       DIA_TR_INF("dia_SAFeatureGNSS::setDiagGNSSSystem - send message.");

       if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID)
       {
         //fill data with the setting
#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
         sensor_locationfi_tclMsgDiagGnssSatSystemSet oMsgData;
         oMsgData.TargetGnssSatSys.u8Value = mode;
         fi_tclVisitorMessage oMessage(oMsgData);
         mpSrvPlugin->vInitServiceData(oMessage, SENSOR_LOCATIONFI_C_U16_DIAGGNSSSATSYSTEM, AMT_C_U8_CCAMSG_OPCODE_SET);
#else
         //kaa1hi: missing declaration of oMessage
         DIA_TR_ERR("dia_SAFeatureGNSS::setDiagGNSSSystem - ERROR missing declaration of oMessage, mode=%d", mode); //fixed LINT warning
#endif

#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI    //kaa1hi: please remove this line if oMessage is defined in all cases
         if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE)
         {
            retCode = DIA_SUCCESS;
            DIA_TR_INF("dia_SAFeatureGNSS::setDiagGNSSSystem - transmitMessage success.");
         }
         else
         {
            DIA_TR_ERR("dia_SAFeatureGNSS::setDiagGNSSSystem - transmitMessage failed.");
         }
#endif
      }
   }
   else
   {
       DIA_TR_ERR("dia_SAFeatureGNSS::setDiagGNSSSystem - getRegistrationID failed.");
       DIA_TR_ERR("dia_SAFeatureGNSS::setDiagGNSSSystem - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }

    return retCode;
}

//-----------------------------------------------------------------------------

#ifndef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI

tVoid
dia_SAFeatureGNSS::vHandleGNSSExtendedData ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureGNSS::vHandleGNSSExtendedData");

   // Extract the op code from the message.
   tU8 u8OpCode = poMessage->u8GetOpCode();

   // Switch on the opcode received
   switch (u8OpCode)
   {
   case AMT_C_U8_CCAMSG_OPCODE_STATUS:
      {
         fi_tclVisitorMessage oStatusMessage(poMessage);
         cmb_sensorfi_tclMsgGpsExtDataStatus oStatusMsgData;
         (tVoid) oStatusMessage.s32GetData(oStatusMsgData);

         // GNSS receiver status
         dia_tGNSSReceiverState info;
         info.m_u8FixStatus          = oStatusMsgData.GpsData.GpsExtBigConstData.FixStatus.u8Value;
         info.m_u8SatellitesHealthy  = oStatusMsgData.GpsData.GpsExtBigConstData.SatellitesHealthy;
         info.m_u8SatellitesReceived = oStatusMsgData.GpsData.GpsExtBigConstData.SatellitesReceived;
         info.m_u8SatellitesVisible  = oStatusMsgData.GpsData.GpsExtBigConstData.SatellitesVisible;
         info.m_u8SatellitesUsed     = oStatusMsgData.GpsData.GpsExtBigConstData.SatellitesUsed;

         std::vector<cmb_fi_tcl_GpsBigVarData> oDataVector;
         oDataVector.assign(oStatusMsgData.GpsData.GpsBigVarData.begin(), oStatusMsgData.GpsData.GpsBigVarData.end());
         std::sort(oDataVector.begin(), oDataVector.end(), dia_gps_compare_snr); //lint !e864 Info: Expression possibly depends on order of evaluation

         std::vector<dia_tGNSSBestSattelletes> oBestSattelletes;
         std::vector<cmb_fi_tcl_GpsBigVarData>::const_iterator it = oDataVector.begin();
         for ( ; it != oDataVector.end(); ++it )
         {
            dia_tGNSSBestSattelletes temp;
            temp.m_u8SatellitesNumber = it->SatId;
            temp.m_u8SignalQuality = (tU8)it->CarrierToNoiseRatio;
            oBestSattelletes.push_back(temp);
         }
         oDataVector.clear();

         // GNSS antenna status
         DIA_TR_INF("dia_SAFeatureGNSS::vHandleGNSSExtendedData - Received GNSS extended data");

         dia_IGNSSListener* pListener = 0;
         if ( (querySysAdapterListener<dia_IGNSSListener>(&pListener) == DIA_SUCCESS) && pListener )
         {
            pListener->vOnGNSSAntennaStatus(oStatusMsgData.GpsData.GpsExtBigConstData.AntennaStatus.enType);
            pListener->vOnGNSSReceiverStatus(info);
            pListener->vOnGNSSBestSattelites(oBestSattelletes);

            DIA_TR_INF("Antenna State = %d",oStatusMsgData.GpsData.GpsExtBigConstData.AntennaStatus.enType);
            DIA_TR_INF("dia_SAFeatureGNSS::vHandleGNSSExtendedData - antenna state forwarded to listener");

            // ******************************************
            // GPS Time
            // ******************************************
            tU16 u16Year     = oStatusMsgData.GpsData.GpsExtBigConstData.Year;
            tU8  u8Month     = oStatusMsgData.GpsData.GpsExtBigConstData.Month;
            tU8  u8Day       = oStatusMsgData.GpsData.GpsExtBigConstData.Day;
            tU8  u8Hour      = oStatusMsgData.GpsData.GpsExtBigConstData.Hour;
            tU8  u8Minutes   = oStatusMsgData.GpsData.GpsExtBigConstData.Minute;
            tU8  u8Seconds   = oStatusMsgData.GpsData.GpsExtBigConstData.Second;
            tU16 u16MSeconds  = tU16(oStatusMsgData.GpsData.GpsExtBigConstData.HundredthSecond * 10);

            DIA_TR_INF("dia_SAFeatureGNSS::vHandleGNSSExtendedData => GPS Time = %02d.%02d.%02d %02d:%02d:%02d:%d ",
                  u8Day,u8Month,u16Year,u8Hour,u8Minutes,u8Seconds,u16MSeconds);

            pListener->vOnGNSSTimeDate(u16Year,u8Month,u8Day,u8Hour,u8Minutes,u8Seconds,u16MSeconds);

            // ******************************************
            // GPS Position
            // ******************************************
            tS32  s32LongMSeconds = 0;
            tS32  s32LatMSeconds = 0;

            /* decide north or south, east or west */
            // (GpsExtBigConstData.LatitudeFiltered >= 0.0) ? 'N'(+ve): 'S'(-ve);
            // (GpsExtBigConstData.LongitudeFiltered >= 0.0) ? 'E'(+ve): 'W'(-ve);
            //======= longitude calculation =======
            /* convert to Milliseconds (+0.5 for rounding) */
            tF64 f64LongitudeMSeconds = (fabs(oStatusMsgData.GpsData.GpsExtBigConstData.Longitude) * 180.0 * 3600000.0 / 3.1415926535898) + 0.5;

            /* convert to unsigned integer */
            if (f64LongitudeMSeconds <= (tF64)0x7FFFFFFF)
            {
               s32LongMSeconds = (tS32)f64LongitudeMSeconds;
            }
            else
            {
               s32LongMSeconds = (tS32)0;
            }

            if (oStatusMsgData.GpsData.GpsExtBigConstData.Longitude >= 0)
            {
              // no correction
            }
            else
            {
               s32LongMSeconds = - s32LongMSeconds;
            }

            //======= latitude calculation =======
            /* convert to Milliseconds (+0.5 for rounding) */
            tF64 f64LatitudeMSeconds = (fabs(oStatusMsgData.GpsData.GpsExtBigConstData.Latitude) * 180.0 * 3600000.0 / 3.1415926535898) + 0.5;

            /* convert to unsigned integer */
            if (f64LatitudeMSeconds <= (tF64)0x7FFFFFFFF)
            {
               s32LatMSeconds = (tS32)f64LatitudeMSeconds;
            }
            else
            {
               s32LatMSeconds = (tS32)0;
            }

            if (oStatusMsgData.GpsData.GpsExtBigConstData.Latitude >= 0)
            {
               // no correction
            }
            else
            {
               s32LatMSeconds = - s32LatMSeconds;
            }

            tS16 s16Altitude = static_cast<tS16>(oStatusMsgData.GpsData.GpsExtBigConstData.AltitudeWGS84);

            DIA_TR_INF("dia_SAFeatureGNSS::vHandleGNSSExtendedData => GPS Pos = Lat:%d Long:%d Alt:%d",
                  s32LatMSeconds,s32LongMSeconds,s16Altitude);

            pListener->vOnGNSSPosition(s32LatMSeconds, s32LongMSeconds, s16Altitude);
         } //if (... pListener)

      }
      break;

   default:
      {
         DIA_TR_INF("dia_SAFeatureGNSS::vHandleGNSSExtendedData - OpCode not ok");
      }
      break;
   }

   // Delete the message we are unable process it at this time
   (tVoid) poMessage->bDelete();
}

#endif

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureGNSS::vHandleGNSSData ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureGNSS::vHandleGNSSData");

   dia_IGNSSListener* pListener = 0;
   if ( (querySysAdapterListener<dia_IGNSSListener>(&pListener) == DIA_SUCCESS) && pListener )
   {
      // Extract the op code from the message.
      tU8 u8OpCode = poMessage->u8GetOpCode();

      // Switch on the opcode received
      switch (u8OpCode)
      {
      case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            fi_tclVisitorMessage oStatusMessage(poMessage);
#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
            sensor_locationfi_tclMsgGnssDataStatus oStatusMsgData;
            tS32 s32Result = oStatusMessage.s32GetData(oStatusMsgData);

            if (s32Result)
            {
               DIA_TR_ERR("!!! dia_SAFeatureGNSS::vHandleGNSSData => ERROR: %d", s32Result);
            }
            else
            {
               // GNSS receiver status

               dia_tGNSSReceiverState info;
               info.m_u8SatellitesHealthy  = 0; //No longer supported by Sensor FI 5.0
               info.m_u8SatellitesReceived = oStatusMsgData.GnssData.GnssPvtData.SatellitesReceived;
               info.m_u8SatellitesVisible  = oStatusMsgData.GnssData.GnssPvtData.SatellitesVisible;
               info.m_u8SatellitesUsed     = oStatusMsgData.GnssData.GnssPvtData.SatellitesUsed;
               info.m_u8FixStatus =  0; //oStatusMsgData.GnssData.GnssPvtData.GnssStatus.GnssMode.enType;
               DIA_TR_INF("fix status = 0x%02x", oStatusMsgData.GnssData.GnssPvtData.GnssStatus.GnssMode.enType);
			   switch (oStatusMsgData.GnssData.GnssPvtData.GnssStatus.GnssMode.enType)
               {
               case sensor_fi_tcl_e8_GnssMode::FI_EN_GNSSMODE_NOFIX:
			    info.m_u8FixStatus |= 1;
                  break;
               case sensor_fi_tcl_e8_GnssMode::FI_EN_GNSSMODE_2DFIX:
                  info.m_u8FixStatus |= (1 << 1);
                  break;
               case sensor_fi_tcl_e8_GnssMode::FI_EN_GNSSMODE_3DFIX:
                  info.m_u8FixStatus |= (1 << 2);
                  break;
               default:
				   info.m_u8FixStatus = 0xFF;
                  break;
               }

               pListener->vOnGNSSReceiverStatus(info);

               dia_tGPSReceptionLevel GPS_info;
               GPS_info.SatellitesUsed     = (tU8)info.m_u8SatellitesUsed;
               GPS_info.FixStatus = (tU8)info.m_u8FixStatus;

               pListener->vOnGPSReceptionLevel(GPS_info);
               // GNSS Channel List

               std::vector<sensor_fi_tcl_GnssChanData>::const_iterator it = oStatusMsgData.GnssData.GnssChanDataList.begin();
               std::vector<dia_tGNSSSatellitesSignalQuality> oGNSSSatellitesSignalQuality;
               for ( ; it != oStatusMsgData.GnssData.GnssChanDataList.end(); ++it )
               {
                  DIA_TR_INF("--- dia_SAFeatureGNSS::vHandleGNSSData => Ch[%d] Status=0x%02x CNR=%d",
                        it->SvId, it->SatStatus.u8Value, it->CarrierToNoiseRatio);

                  dia_tGNSSSatellitesSignalQuality element(it->SvId, it->CarrierToNoiseRatio);
                  oGNSSSatellitesSignalQuality.push_back(element);
               }

               pListener->vOnGNSSSatellitesSignalQuality(oGNSSSatellitesSignalQuality);
      #if 0
               std::vector<cmb_fi_tcl_GpsBigVarData> oDataVector;
               oDataVector.assign(oStatusMsgData.GnssData.GpsBigVarData.begin(), oStatusMsgData.GnssData.GpsBigVarData.end());
               std::sort(oDataVector.begin(), oDataVector.end(), dia_gps_compare_snr); //lint !e864 Info: Expression possibly depends on order of evaluation

               std::vector<dia_tGNSSBestSattelletes> oBestSattelletes;
               std::vector<cmb_fi_tcl_GpsBigVarData>::const_iterator it = oDataVector.begin();
               for ( ; it != oDataVector.end(); ++it )
               {
                  dia_tGNSSBestSattelletes temp;
                  temp.m_u8SatellitesNumber = it->SatId;
                  temp.m_u8SignalQuality = (tU8)it->CarrierToNoiseRatio;
                  oBestSattelletes.push_back(temp);
               }
               oDataVector.clear();
      #endif

               // GNSS antenna status
               DIA_TR_INF("dia_SAFeatureGNSS::vHandleGNSSData - Received GNSS extended data");

      //            pListener->vOnGNSSAntennaStatus(oStatusMsgData.GnssData.GpsExtBigConstData.AntennaStatus.enType);
      //            pListener->vOnGNSSBestSattelites(oBestSattelletes);

      //            DIA_TR_INF("Antenna State = %d",oStatusMsgData.GnssData.GpsExtBigConstData.AntennaStatus.enType);
      //            DIA_TR_INF("dia_SAFeatureGNSS::vHandleGNSSData - antenna state forwarded to listener");

               // ******************************************
               // GPS Time
               // ******************************************
               tU16 u16Year     = oStatusMsgData.GnssData.GnssPvtData.UtcTimeDate.td_year;
               tU8  u8Month     = oStatusMsgData.GnssData.GnssPvtData.UtcTimeDate.td_month;
               tU8  u8Day       = oStatusMsgData.GnssData.GnssPvtData.UtcTimeDate.td_day;
               tU8  u8Hour      = oStatusMsgData.GnssData.GnssPvtData.UtcTimeDate.td_hour;
               tU8  u8Minutes   = oStatusMsgData.GnssData.GnssPvtData.UtcTimeDate.td_minute;
               tU8  u8Seconds   = oStatusMsgData.GnssData.GnssPvtData.UtcTimeDate.td_second;
               tU16 u16MSeconds  = oStatusMsgData.GnssData.GnssPvtData.UtcTimeDate.td_milliSeconds;

               DIA_TR_INF("--- dia_SAFeatureGNSS::vHandleGNSSData => GPS Time = %02d.%02d.%02d %02d:%02d:%02d:%d ",
                     u8Day,u8Month,u16Year,u8Hour,u8Minutes,u8Seconds,u16MSeconds);

               pListener->vOnGNSSTimeDate(u16Year,u8Month,u8Day,u8Hour,u8Minutes,u8Seconds,u16MSeconds);

               // ******************************************
               // GPS Position
               // ******************************************
               tS32  s32LongMSeconds = 0;
               tS32  s32LatMSeconds = 0;
               //tS16  s16Altitude = 0;

               /* decide north or south, east or west */
               // (GpsExtBigConstData.LatitudeFiltered >= 0.0) ? 'N'(+ve): 'S'(-ve);
               // (GpsExtBigConstData.LongitudeFiltered >= 0.0) ? 'E'(+ve): 'W'(-ve);
               //======= longitude calculation =======
               /* convert to Milliseconds (+0.5 for rounding) */
               tF64 f64LongitudeMSeconds = (fabs(oStatusMsgData.GnssData.GnssPvtData.Longitude) * 180.0 * 3600000.0 / 3.1415926535898) + 0.5;

               /* convert to unsigned integer */
               if (f64LongitudeMSeconds <= (tF64)0x7FFFFFFF)
               {
                  s32LongMSeconds = (tS32)f64LongitudeMSeconds;
               }
               else
               {
                  s32LongMSeconds = (tS32)0;
               }

               if (oStatusMsgData.GnssData.GnssPvtData.Longitude >= 0)
               {
                 // no correction
               }
               else
               {
                  s32LongMSeconds = - s32LongMSeconds;
               }

               //======= latitude calculation =======
               /* convert to Milliseconds (+0.5 for rounding) */
               tF64 f64LatitudeMSeconds = (fabs(oStatusMsgData.GnssData.GnssPvtData.Latitude) * 180.0 * 3600000.0 / 3.1415926535898) + 0.5;

               /* convert to unsigned integer */
               if (f64LatitudeMSeconds <= (tF64)0x7FFFFFFFF)
               {
                  s32LatMSeconds = (tS32)f64LatitudeMSeconds;
               }
               else
               {
                  s32LatMSeconds = (tS32)0;
               }

               if (oStatusMsgData.GnssData.GnssPvtData.Latitude >= 0)
               {
                  // no correction
               }
               else
               {
                  s32LatMSeconds = - s32LatMSeconds;
               }

               tS16 s16Altitude = static_cast<tS16>(oStatusMsgData.GnssData.GnssPvtData.AltitudeWGS84);

               DIA_TR_INF("--- dia_SAFeatureGNSS::vHandleGNSSData => GPS Pos = Lat:%d Long:%d Alt:%d ",
                     s32LatMSeconds,s32LongMSeconds,s16Altitude);

               pListener->vOnGNSSPosition(s32LatMSeconds, s32LongMSeconds, s16Altitude);
			   
			   
			  // ******************************************
			  // GNSS Velocity vector
			  // ******************************************
			  tS16  s16VelocityNorth = static_cast<tS16>(oStatusMsgData.GnssData.GnssPvtData.VelocityNorth);
			  tS16  s16VelocityEast  = static_cast<tS16>(oStatusMsgData.GnssData.GnssPvtData.VelocityEast);
			  tS16  s16VelocityUp    = static_cast<tS16>(oStatusMsgData.GnssData.GnssPvtData.VelocityUp);

			  pListener->vOnGNSSVelocity(s16VelocityNorth, s16VelocityEast, s16VelocityUp);
            }
#else
         // nothing to be done
#endif
         }
         break;

      default:
         {
            DIA_TR_INF("dia_SAFeatureGNSS::vHandleGNSSData - OpCode not ok");
         }
         break;
      }
   } //if (pListener)

   // Delete the message we are unable process it at this time
   (tVoid) poMessage->bDelete();
}

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureGNSS::vHandleGNSSConfigData ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureGNSS::vHandleGNSSConfigData");

   dia_IGNSSListener* pListener = 0;
   if ( (querySysAdapterListener<dia_IGNSSListener>(&pListener) == DIA_SUCCESS) && pListener )
   {
      // Extract the op code from the message.
      tU8 u8OpCode = poMessage->u8GetOpCode();

      // Switch on the opcode received
      switch (u8OpCode)
      {
      case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            fi_tclVisitorMessage oStatusMessage(poMessage);
#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
            sensor_locationfi_tclMsgGnssConfigDataStatus oStatusMsgData;
            tS32 s32Result = oStatusMessage.s32GetData(oStatusMsgData);
            DIA_TR_INF("dia_SAFeatureGNSS::vHandleGNSSConfigData GnssReceiverFirmwareCrc = %d.", ((tU32)oStatusMsgData.GnssConfigData.GnssReceiverFirmwareCrc));
            DIA_TR_INF("dia_SAFeatureGNSS::vHandleGNSSConfigData GnssReceiverFirmwareCrc = 0x%08X.", oStatusMsgData.GnssConfigData.GnssReceiverFirmwareCrc);
            DIA_TR_INF("dia_SAFeatureGNSS::vHandleGNSSConfigData GnssReceiverFirmwareVersion = %d.", ((tU32)oStatusMsgData.GnssConfigData.GnssReceiverFirmwareVersion));
            DIA_TR_INF("dia_SAFeatureGNSS::vHandleGNSSConfigData GnssReceiverFirmwareVersion = 0x%08x.", oStatusMsgData.GnssConfigData.GnssReceiverFirmwareVersion);
            if (s32Result)
            {
               DIA_TR_ERR("!!! dia_SAFeatureGNSS::vHandleGNSSConfigData => ERROR: %d", s32Result);
            }
            else
            {
               // GNSS receiver firmware status
               pListener->vOnGNSSRecFirmwareVersion(oStatusMsgData.GnssConfigData.GnssReceiverFirmwareVersion);
               pListener->vOnGNSSRecFrimwareCrc(oStatusMsgData.GnssConfigData.GnssReceiverFirmwareCrc);
            }
#else
         // nothing to be done
#endif
         }
         break;
      default:
         {
            DIA_TR_INF("dia_SAFeatureGNSS::vHandleGNSSConfigData - OpCode not ok");
         }
         break;
      }
   } //if (pListener)
   // Delete the message we are unable process it at this time
   (tVoid) poMessage->bDelete();
}

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureGNSS::vHandleGNSSSystem ( amt_tclServiceData* poMessage ) const
{
    dia_tclFnctTrace trc("dia_SAFeatureGNSS::vHandleGNSSSystem");

    // Extract the op code from the message.
    tU8 u8OpCode = poMessage->u8GetOpCode();

    // Switch on the opcode received
    switch (u8OpCode)
    {
    case AMT_C_U8_CCAMSG_OPCODE_STATUS:
        {
            fi_tclVisitorMessage oStatusMessage(poMessage);
#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
            sensor_locationfi_tclMsgGnssSatSystemStatus oStatusMsgData;
            tS32 s32Result = oStatusMessage.s32GetData(oStatusMsgData);
            if (s32Result)
            {
               DIA_TR_ERR("!!! dia_SAFeatureGNSS::vHandleGNSSSystem => ERROR: %d", s32Result);
            }
            else
            {
               DIA_TR_INF("dia_SAFeatureGNSS::vHandleGNSSSystem - Received GNSS System Mode");

               dia_IGNSSListener* pListener = 0;
               if ( (querySysAdapterListener<dia_IGNSSListener>(&pListener) == DIA_SUCCESS) && pListener )
               {
                   pListener->vOnGNSSSatSystem(oStatusMsgData.ActualGnssSatSys.u8Value);
                   DIA_TR_INF("GNSS sat system bit mask = 0x%02x",oStatusMsgData.ActualGnssSatSys.u8Value);
                   DIA_TR_INF("dia_SAFeatureGNSS::vHandleGNSSSystem - current forwarded to listener");
               }
            }
#else
            cmb_sensorfi_tclMsgGnssSatSystemStatus oStatusMsgData;
            (tVoid) oStatusMessage.s32GetData(oStatusMsgData);

            DIA_TR_INF("dia_SAFeatureGNSS::vHandleGNSSSystem - Received GNSS System Mode");

               dia_IGNSSListener* pListener = 0;
               if ( (querySysAdapterListener<dia_IGNSSListener>(&pListener) == DIA_SUCCESS) && pListener )
            {
                pListener->vOnGNSSSatSystem(tU8(oStatusMsgData.ActualGnssSatSys.u8Value - 1));
                DIA_TR_INF("GNSS sat system = %d",oStatusMsgData.ActualGnssSatSys.u8Value - 1);
                DIA_TR_INF("dia_SAFeatureGNSS::vHandleGNSSSystem - current forwarded to listener");
            }
#endif
        }
        break;

    default:
        {
           DIA_TR_INF("dia_SAFeatureGNSS::vHandleGNSSSystem - OpCode not ok");
        }
        break;
    }

    // Delete the message we are unable process it at this time
    (tVoid) poMessage->bDelete();
}
//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureGNSS::vHandleDiagGNSSSystem ( amt_tclServiceData* poMessage ) const
{
    dia_tclFnctTrace trc("dia_SAFeatureGNSS::vHandleDiagGNSSSystem");

    // Extract the op code from the message.
    tU8 u8OpCode = poMessage->u8GetOpCode();

    // Switch on the opcode received
    switch (u8OpCode)
    {
    case AMT_C_U8_CCAMSG_OPCODE_STATUS:
        {
            fi_tclVisitorMessage oStatusMessage(poMessage);
#ifdef VARIANT_S_FTR_ENABLE_NEW_SENSOR_FI
            sensor_locationfi_tclMsgDiagGnssSatSystemStatus oStatusMsgData;
            tS32 s32Result = oStatusMessage.s32GetData(oStatusMsgData);
            if (s32Result)
            {
               DIA_TR_ERR("!!! dia_SAFeatureGNSS::vHandleDiagGNSSSystem => ERROR: %d", s32Result);
            }
            else
            {
               DIA_TR_INF("dia_SAFeatureGNSS::vHandleDiagGNSSSystem - Received GNSS System Mode");

               dia_IGNSSListener* pListener = 0;
               if ( (querySysAdapterListener<dia_IGNSSListener>(&pListener) == DIA_SUCCESS) && pListener )
               {
                   pListener->vOnGNSSSatSystem(oStatusMsgData.ActualGnssSatSys.u8Value);
                   DIA_TR_INF("GNSS sat system bit mask = 0x%02x",oStatusMsgData.ActualGnssSatSys.u8Value);
                   DIA_TR_INF("dia_SAFeatureGNSS::vHandleDiagGNSSSystem - current forwarded to listener");
               }
            }
#endif
        }
        break;

    default:
        {
           DIA_TR_INF("dia_SAFeatureGNSS::vHandleDiagGNSSSystem - OpCode not ok");
        }
        break;
    }

    // Delete the message we are unable process it at this time
    (tVoid) poMessage->bDelete();
}

