/**
 * \file      dia_SAFeatureDiagConfigItem.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    abe6kor
 * \date      June 27, 2017
 *
 * \copyright Robert Bosch Car Multimedia 2015
 */

#ifndef dia_SAFeatureDiagConfigItem__H_
#define dia_SAFeatureDiagConfigItem__H_


#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_CONFIGITEM__
#include "common/interfaces/dia_IConfigItem.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_CONFIG__
#include "common/framework/config/dia_common_config.h"
#endif

#define DIAGNOSTICS_S_IMPORT_INTERFACE_GENERIC
#define DIAGNOSTICS_S_IMPORT_INTERFACE_MSG
#include "fc_diagnosis_if.h"

#include "common/interfaces/dia_IConfigItemListener.h"
#include "common/framework/sysadapters/dia_SystemAdapterFeature.h"

struct TNotificationConfigItem
{
	tU16 u16AppID;
	tU16 u16CmdCounter;
	tU16 u16RegisterID;
	tU32 u32CcaSubId;
};

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------
class dia_IConfigItemListener;

class dia_SAFeatureDiagConfigItem
: public dia_SystemAdapterFeature,
  public dia_IConfigItemListener

{
	DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SAFeatureDiagConfigItem);
public:
	//! default class constructor
	dia_SAFeatureDiagConfigItem( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin);
	//! destructor
	virtual ~dia_SAFeatureDiagConfigItem ( void );
	//! response to other ConfigItems
	virtual void vOnConfigItemUpdate ( tU32 ConfigItem );
	//! response to an asynchronous read
	virtual void vOnConfigItemGetComplete( tU32 ConfigItem, tDiaResult retCode, std::vector<tU8>& data, void* cookie);
	//! response to an asynchronous write
	virtual void vOnConfigItemSetComplete( tU32 ConfigItem, tDiaResult retCode, void* cookie);

protected:

	std::map<tU32,TNotificationConfigItem> tMapConfigItemEntryNotify;

	//! handle the result of a message
	tVoid vHandleDiagConfigItem ( amt_tclServiceData* poMessage );
    tVoid vSendDiagConfigItemEntry ( const ahl_tNotification* pNot, tU32 u32ConfigItem );
	bool bUpreg(amt_tclServiceData const* poMessage);
	bool bRelUpreg(amt_tclServiceData const* poMessage);
	tVoid vSendError ( tU16 u16TargetID, tU16 u16RegisterID, tU16 u16CmdCounter, tU16 u16Fid );

	DECLARE_MSG_MAP(dia_SAFeatureDiagConfigItem)

private:
	diagnostics_tclApp* m_poGWMain;

	tVoid vNotifyAllClients(fi_tclTypeBase const&, tU16);
	tVoid vSendStatusMsg(amt_tclServiceData const*, fi_tclTypeBase const&) const;
	tVoid vSendMsg(amt_tclServiceData const*, fi_tclTypeBase const&, tU8) const;
};

#endif /* dia_SAFeatureDiagConfigItem__H_ */
