/*
 * dia_SAFeatureDiagClient.h
 *
 *  Created on: 13.12.2016
 *      Author: stc2hi
 */

#ifndef __INCLUDED_DIA_SAFEATURE_DIAG_CLIENT__
#define __INCLUDED_DIA_SAFEATURE_DIAG_CLIENT__


#include "Midw_Diagnostics_FIClientBase.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterFeatureASF.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DIAGCLIENT__
#include <common/interfaces/dia_IDiagClient.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DIAGCLIENT_LISTENER__
#include <common/interfaces/dia_IDiagClientListener.h>
#endif

using namespace Midw_Diagnostics_FI;

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureDiagClient
   : public dia_SystemAdapterFeatureASF<Midw_Diagnostics_FIProxy>,
     public Midw_Diagnostics_FIClientBase,
     public dia_IDiagClient
{
public:
   //! constructor
   dia_SAFeatureDiagClient (dia_SystemAdapterServicePluginASF<Midw_Diagnostics_FIProxy>& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureDiagClient();

   //! start monitoring of properties
   virtual tDiaResult startMonitoring();
   //! stop monitoring of properties
   virtual tDiaResult stopMonitoring();

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IDiagClient methods
   //
   //-------------------------------------------------------------------------
   virtual tDiaResult sendMessage ( tU16 u16FunctionId, tU8 u8OpCode,  const std::vector<tU8>& payload );

   //-------------------------------------------------------------------------
   //
   // Overloaded Midw_Diagnostics_FIClientBase methods
   //
   //-------------------------------------------------------------------------
   virtual void onDiagConfigItemStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< DiagConfigItemStatus >& status);

   virtual void onDiagConfigItemError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< DiagConfigItemError >& error);

   virtual void onDiagRequestError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< DiagRequestError >& error);

   virtual void onDiagRequestResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< DiagRequestResult >& result);

#if 0
   virtual void onGetUpdateHistoryScopedError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy,
                                              const ::boost::shared_ptr< GetUpdateHistoryScopedError >& error);

   virtual void onGetUpdateHistoryScopedResponse(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy,
                                                 const ::boost::shared_ptr< GetUpdateHistoryScopedResponse >& response);

   virtual void onEnterRecoveryModeError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy,
                                         const ::boost::shared_ptr< EnterRecoveryModeError >& error);

   virtual void onEnterRecoveryModeResponse(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy,
                                            const ::boost::shared_ptr< EnterRecoveryModeResponse >& response);
#endif

protected:
   //! deprecated default constructor
   dia_SAFeatureDiagClient ();

   // Update to listeners
#if 0
   virtual void vOnSwUpdateInfo(const std::vector<dia_tProgramHistory>& progInfo);
   virtual void vOnNoOfSwReUpdate(tU32 numberOfUpateLogs);
#endif
};

#endif /* __INCLUDED_DIA_SAFEATURE_DIAG_CLIENT__ */
