/*
 * dia_SAFeatureDiagClient.cpp
 *
 *  Created on: 13.12.2016
 *      Author: stc2hi
 */

#include "dia_SAFeatureDiagClient.h"

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterServicePluginASF.h>
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGNOSTICSFI_FUNCTIONIDS
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

//------------------------------------------------------------------------------

dia_SAFeatureDiagClient::dia_SAFeatureDiagClient(
      dia_SystemAdapterServicePluginASF<Midw_Diagnostics_FIProxy>& pSrvPlugin
   )
    : dia_SystemAdapterFeatureASF(pSrvPlugin)
{
}
//-----------------------------------------------------------------------------

dia_SAFeatureDiagClient::~dia_SAFeatureDiagClient()
{
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDiagClient::startMonitoring()
{
   dia_tclFnctTrace trc("dia_SAFeatureDiagClient::startMonitoring");

   if( (mpSrvPlugin) && (mpSrvPlugin->getProxy())    )
   {
     // Register to properties
   }
   return DIA_SUCCESS;
}
//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDiagClient::stopMonitoring()
{
   dia_tclFnctTrace trc("dia_SAFeatureDiagClient::stopMonitoring");

   if( (mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
     // DeRegister properties
   }
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDiagClient::sendMessage ( tU16 u16FunctionId, tU8 u8OpCode,  const std::vector<tU8>& payload )
{
   dia_tclFnctTrace trc("dia_SAFeatureDiagClient::sendMessage");

   tDiaResult retCode = DIA_FAILED;

   if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
      act_t token = 0;

      bool valid;

      switch (u16FunctionId)
      {
         case MIDW_DIAGNOSTICSFI_C_U16_DIAGCONFIGITEM:
            if (u8OpCode == CCA_C_U8_OPCODE_GET)
            {
               tU32 configItem = 0;
               tU32 bytes = (payload.size() <= sizeof(configItem))? payload.size(): sizeof(configItem);

               for (tU32 i = 0; i < bytes; i++)
               {
                  configItem = (configItem << 8) | payload[i];
               }

               DIA_TR_INF("dia_SAFeatureDiagClient::sendMessage => sendDiagConfigItemGet with configItem = 0x%x", configItem);
               token = mpSrvPlugin->getProxy()->sendDiagConfigItemGet(*this, configItem);
            }
            if (u8OpCode == CCA_C_U8_OPCODE_SET)
            {
            	tU32 configItem = 0;
            	tU32 bytes = (payload.size() <= sizeof(configItem))? payload.size(): sizeof(configItem);

            	for (tU32 i = 0; i < bytes; i++)
            	{
            		configItem = (configItem << 8) | payload[i];
            	}
            	DIA_TR_INF("dia_SAFeatureDiagClient::sendMessage => sendDiagConfigItemSet with configItem = 0x%x", configItem);
            	std::vector<tU8> configItemContent;
            	for (tU32 i = bytes; i < payload.size(); i++)
            	{
            		configItemContent.push_back(payload[i]);
            	}

            	for (tU32 i = 0; i < configItemContent.size(); i++)
            	{
            		DIA_TR_INF("dia_SAFeatureDiagClient::sendMessage => sendDiagConfigItemSet with configItemContent = 0x%x",configItemContent[i]);
            	}


            	token = mpSrvPlugin->getProxy()->sendDiagConfigItemSet(*this, configItem , configItemContent );
            }
            else if (u8OpCode == CCA_C_U8_OPCODE_UPREG)
            {
            	tU32 configItem = 0;
            	tU32 bytes = (payload.size() <= sizeof(configItem))? payload.size(): sizeof(configItem);

            	for (tU32 i = 0; i < bytes; i++)
            	{
            	   configItem = (configItem << 8) | payload[i];
            	}

            	DIA_TR_INF("dia_SAFeatureDiagClient::sendMessage => sendDiagConfigItemUpReg with configItem = 0x%x", configItem);
            	token = mpSrvPlugin->getProxy()->sendDiagConfigItemUpReg(*this, configItem);
            }
            else if (u8OpCode == CCA_C_U8_OPCODE_RELUPREG)
            {
            	tU32 configItem = 0;
            	tU32 bytes = (payload.size() <= sizeof(configItem))? payload.size(): sizeof(configItem);

            	for (tU32 i = 0; i < bytes; i++)
            	{
            	   configItem = (configItem << 8) | payload[i];
            	}

                token = mpSrvPlugin->getProxy()->sendDiagConfigItemUpReg(*this, configItem);

                if(0!=token)
                {
                	 valid = mpSrvPlugin->getProxy()->sendDiagConfigItemRelUpReg(token);
                	 if(valid)DIA_TR_INF("dia_SAFeatureDiagClient::sendMessage => sendDiagConfigItemRelUpReg with configItem = 0x%x", configItem);
                }
            }
            break;

         case MIDW_DIAGNOSTICSFI_C_U16_DIAGREQUEST:
            if (u8OpCode == CCA_C_U8_OPCODE_METHODSTART)
            {
               midw_diagnostics_fi_types::T_DiagData request;

               for (unsigned i = 0; i < payload.size(); i++)
               {
                  request.push_back(payload[i]);
               }

               token = mpSrvPlugin->getProxy()->sendDiagRequestStart(*this, midw_diagnostics_fi_types::T_DiagProtocol__UDS, request, 0);
            }
            break;

         default:
            break;
      }

      if (0!=token)
      {
         retCode = DIA_SUCCESS;
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureDiagClient::sendMessage => mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

void dia_SAFeatureDiagClient::onDiagConfigItemStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< DiagConfigItemStatus >& status)
{
   dia_tclFnctTrace trc("dia_SAFeatureDiagClient::onDiagConfigItemStatus");

	if (proxy && status)
	{
	   DIA_TR_INF("DiagConfigItemStatus.ConfigItem = %d", status->getConfigItem());
      DIA_TR_INF("DiagConfigItemStatus.ConfigItemValid = %d", status->getConfigItemValid());

      midw_diagnostics_fi_types::T_ConfigItemList data = status->getConfigItemContent();
      DIA_TR_INF("DiagConfigItemStatus.ConfigItemContent = %d byte(s)", data.size());
      for (unsigned i = 0; i < data.size(); i++)
      {
         DIA_TR_INF("DiagConfigItemStatus.ConfigItemContent[%d] = 0x%02x", i, data[i]);
      }
	}
}

//-----------------------------------------------------------------------------

void dia_SAFeatureDiagClient::onDiagConfigItemError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< DiagConfigItemError >& error)
{
   dia_tclFnctTrace trc("dia_SAFeatureDiagClient::onDiagConfigItemError");

	if (proxy && error)
	{
	   DIA_TR_INF("dia_SAFeatureDiagClient::onDiagConfigItemError");
	}
}

//-----------------------------------------------------------------------------

void dia_SAFeatureDiagClient::onDiagRequestError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< DiagRequestError >& error)
{
   dia_tclFnctTrace trc("dia_SAFeatureDiagClient::onDiagRequestError");

}

//-----------------------------------------------------------------------------

void dia_SAFeatureDiagClient::onDiagRequestResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< DiagRequestResult >& result)
{
   dia_tclFnctTrace trc("dia_SAFeatureDiagClient::onDiagRequestResult");

}



