/*
 * dia_SAFeatureDeviceMGR.h
 *
 *  Created on: 11.01.2011
 *      Author: sta8hi
 */
 /*********************************************************************************************
* REVISION HISTORY:
* ------------------------------------------------------------------------------------------------
* Date             | Rev.             | Author             | Modification
* ------------------------------------------------------------------------------------------------
*--------------------------------------------------------------------------------------------------------------------
* 02.09.2016       | 1.1   | NLK1KOR (RBEI)   | Implemented feature AIVINS2-19070 Connection status - Optic Disk
                                                  Connection Status
*--------------------------------------------------------------------------------------------------------------------
*--------------------------------------------------------------------------------------------------------------------
*******************************************************************************************************************************/
#ifndef DIA_SAFEATUREDEVICEMGR_H_
#define DIA_SAFEATUREDEVICEMGR_H_

// implemented interfaces
#ifndef __INCLUDED_DIA_INTERFACE_DEVICE_MANAGER_LISTENER__
#include "common/interfaces/dia_IDeviceMGRListener.h"
#endif

#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_DEVICEMANAGERFI_FUNCTIONIDS
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_DEVICEMANAGERFI_TYPES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_DEVICEMANAGERFI_SERVICEINFO
#include "mplay_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard
class amt_tclServiceData;

class dia_SAFeatureDeviceMGR
    : public dia_SystemAdapterFeature,
      public dia_IDeviceMGR
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SAFeatureDeviceMGR);

public:
   //! default class constructor
   dia_SAFeatureDeviceMGR( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin);
   //! class destructor
   virtual ~dia_SAFeatureDeviceMGR( void );

   //
   // implementation of the dia_IDeviceMGR interface
   //
   virtual tDiaResult getSDCardDiagValues ( void );
   virtual tDiaResult getDevicesValues    ( void );
   virtual tDiaResult selectCDMode        ( dia_eDVM_CDModeSwitch2 switch2CDMode );

   //! This function registers to the property update of DevManagerNotifySlotStateOpticalDisc
   virtual tDiaResult regOpticDiskConnectionStatusValues(void);

protected:
   //! handle the result of a message
   void vHandleSDCardState       ( amt_tclServiceData* poMessage ) const;
   void vHandleDeviceState       ( amt_tclServiceData* poMessage ) const;
   void vHandleMountCDROMInternal( amt_tclServiceData* poMessage ) const;

   //! Call back function when there is property change for MPLAY_DEVICEMANAGERFI_C_U16_DEVMANAGERNOTIFYSLOTSTATEOPTICALDISC
   void vHandleOpticalDiskConnectionStatusResult( amt_tclServiceData* poMessage ) const;

   tBool bSendMessage( const tU8  u8MessageType, const tU16 u16FID, const tU8  u8Opcode,
                       const tU16 u16MsgLength,  const tU8  u8MsgBuffer[]   );
   //#ifdef VARIANT_S_FTR_ENABLE_RIVIE
   void ConvertOpticalDeviceStateToInternal(dia_eOpticalDiscSlotState &DeviceState,const mplay_fi_tcl_e8_SlotStateOpticalDiscType oFiOpticalDeviceState) const;
   //#endif
   // declare message map data structures
   DECLARE_MSG_MAP( dia_SAFeatureDeviceMGR )
};

#endif /* DIA_SAFEATUREDEVICEMGR_H_ */
