/*
 * dia_SAFeatureDeviceMGR.cpp
 *
 *  Created on: 13.08.2012
 *      Author: sta8hi, fgl2hi
 */
/*********************************************************************************************
* REVISION HISTORY:
* ------------------------------------------------------------------------------------------------
* Date            | Rev.             | Author             | Modification
* 02.09.2016      | 1.1              | NLK1KOR (RBEI)     | Implemented feature AIVINS2-19070 Connection status - Optic Disk
                                                            Connection Status
***********************************************************************************************/
#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#include "common/interfaces/dia_IDeviceMGRListener.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_DEVICEMANAGERFI_FUNCTIONIDS
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_DEVICEMANAGERFI_TYPES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_DEVICEMANAGERFI_SERVICEINFO
#include "mplay_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#include "dia_SAFeatureDeviceMGR.h"

/// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP( dia_SAFeatureDeviceMGR, dia_SystemAdapterFeature )
   ON_MESSAGE( MPLAY_DEVICEMANAGERFI_C_U16_DEVMANAGERNOTIFYSDCARD,         vHandleSDCardState )
   ON_MESSAGE( MPLAY_DEVICEMANAGERFI_C_U16_DEVMANAGERNOTIFYCONNECTION,     vHandleDeviceState )
   ON_MESSAGE( MPLAY_DEVICEMANAGERFI_C_U16_DEVMANAGERMOUNTCDROMINTERNAL,   vHandleMountCDROMInternal )
   //#ifdef VARIANT_S_FTR_ENABLE_RIVIE
   ON_MESSAGE( MPLAY_DEVICEMANAGERFI_C_U16_DEVMANAGERNOTIFYSLOTSTATEOPTICALDISC, vHandleOpticalDiskConnectionStatusResult)
   //#endif

END_MSG_MAP()

//------------------------------------------------------------------------------

dia_SAFeatureDeviceMGR::dia_SAFeatureDeviceMGR (
      tCString name,    // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureDeviceMGR::dia_SAFeatureDeviceMGR");
}

//-----------------------------------------------------------------------------

dia_SAFeatureDeviceMGR::~dia_SAFeatureDeviceMGR ( void )
{
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDeviceMGR::getSDCardDiagValues( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureDeviceMGR::getSDCardDiagValues()");

   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("dia_SAFeatureDeviceMGR::getSDCardDiagValues - send message.");
      gm_tclEmptyMessage oMessage ( mAppID, mpSrvPlugin->getClientID(),
                                    mpSrvPlugin->getRegistrationID(), 0,
                                    mpSrvPlugin->getServiceID(),
                                    MPLAY_DEVICEMANAGERFI_C_U16_DEVMANAGERNOTIFYSDCARD,
                                    CCA_C_U8_OPCODE_GET
                                  );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureDeviceMGR::getSDCardDiagValues - transmitMessage success.");
      }
      else
      {
         DIA_TR_INF("dia_SAFeatureDeviceMGR::getSDCardDiagValues - transmitMessage failed.");
      }
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureDeviceMGR::getSDCardDiagValues - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureDeviceMGR::getSDCardDiagValues - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}
//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDeviceMGR::getDevicesValues ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureDeviceMGR::getDevicesValues()");

   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("dia_SAFeatureDeviceMGR::getDevicesValues - send message.");
      gm_tclEmptyMessage oMessage ( mAppID, mpSrvPlugin->getClientID(),
                                    mpSrvPlugin->getRegistrationID(), 0,
                                    mpSrvPlugin->getServiceID(),
                                    MPLAY_DEVICEMANAGERFI_C_U16_DEVMANAGERNOTIFYCONNECTION,
                                    CCA_C_U8_OPCODE_GET
                                  );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureDeviceMGR::getDevicesValues - transmitMessage success.");
      }
      else
      {
         DIA_TR_ERR("dia_SAFeatureDeviceMGR::getDevicesValues - transmitMessage failed.");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureDeviceMGR::getDevicesValues - getRegistrationID failed.");
      DIA_TR_ERR("dia_SAFeatureDeviceMGR::getDevicesValues - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDeviceMGR::selectCDMode( dia_eDVM_CDModeSwitch2 switch2CDMode )
{
   dia_tclFnctTrace trc( "dia_SAFeatureDeviceMGR::selectCDMode()" );

   tDiaResult retCode = DIA_FAILED;

   if( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      //fill data with the setting
      mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodStart  oData;
      oData.Mount = ( switch2CDMode == DIA_EN_DEVMGR_CD_MODE_SWITCH_TO_CDROM ) ? TRUE : FALSE;
      DIA_TR_INF( "dia_SAFeatureDeviceMGR::selectCDMode - send message with Mount (CD ROM) = %d", oData.Mount );
      fi_tclVisitorMessage oMsg( oData );
      mpSrvPlugin->vInitServiceData( oMsg, MPLAY_DEVICEMANAGERFI_C_U16_DEVMANAGERMOUNTCDROMINTERNAL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART );

      if( mpSrvPlugin->bTransmitMessage( &oMsg ) == TRUE )
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF( "dia_SAFeatureDeviceMGR::selectCDMode - transmitMessage success." );
      }
      else
      {
         DIA_TR_INF( "dia_SAFeatureDeviceMGR::selectCDMode - transmitMessage failed." );
      }
   }
   else
   {
      DIA_TR_INF( "dia_SAFeatureDeviceMGR::selectCDMode - getRegistrationID failed." );
      DIA_TR_INF( "dia_SAFeatureDeviceMGR::selectCDMode - getRegistrationID == AMT_C_U16_REGID_INVALID." );
   }

   return retCode;
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureDeviceMGR::vHandleSDCardState(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc( "dia_SAFeatureDeviceMGR::vHandleSDCardState" );

   if( poMessage )
   {
      // Extract the op code from the message.
      tU8 u8OpCode = poMessage->u8GetOpCode();

      // Switch on the opcode received
      switch( u8OpCode )
      {
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            fi_tclVisitorMessage oStatusMessage( poMessage );
            mplay_devicemanagerfi_tclMsgDevManagerNotifySDCardStatus oStatusMsgData;
            (void)oStatusMessage.s32GetData( oStatusMsgData );

            DIA_TR_INF(("dia_SAFeatureDeviceMGR::vHandleSDCardState - Received SDCardState"));

            dia_IDeviceMGRListener* pListener = OSAL_NULL;
            querySysAdapterListener<dia_IDeviceMGRListener>(&pListener);
            if( pListener )
            {
               std::vector<mplay_fi_tcl_DevManager_SDCardInfo>::const_iterator it = oStatusMsgData.SDCardList.begin();
               std::vector<dia_tSdcStates> oSdcStates;
               dia_tSdcStates                tSdcStates;
               std::vector<dia_tSdcCIDs>   oSdcCid;
               dia_tSdcCIDs                  tSdcCid;

               if( !oStatusMsgData.SDCardList.empty() )
               {
                  // Evaluate list of all SD Card slot
                  for( ; it != oStatusMsgData.SDCardList.end(); ++it )
                  {
                     mplay_fi_tcl_DevManager_SDCardInfo oSDCardInfo = (*it);
                     // Set SD Card slot number for SDC states
                     tSdcStates.SlotNo = oSDCardInfo.SDCardSlot;
                     // evaluate SD Card media type to get the slot state
                     switch( oSDCardInfo.SDCardMedia.enType )
                     {
                        case mplay_fi_tcl_e8_DVM_MediaType::FI_EN_MEDIA_EJECTED:
                           tSdcStates.SlotState = DIA_EN_DEVMGR_SDC_SLOT_STATE_REMOVED;
                           DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState EJECTED oSDCardInfo.SDCardMedia.enType = %d", oSDCardInfo.SDCardMedia.enType);
                           break;
                        case mplay_fi_tcl_e8_DVM_MediaType::FI_EN_DATA_MEDIA:
                        case mplay_fi_tcl_e8_DVM_MediaType::FI_EN_INCORRECT_MEDIA:
                        case mplay_fi_tcl_e8_DVM_MediaType::FI_EN_UNKNOWN_MEDIA:
                           tSdcStates.SlotState = DIA_EN_DEVMGR_SDC_SLOT_STATE_INSERTED;
                           DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState INSERTED oSDCardInfo.SDCardMedia.enType = %d", oSDCardInfo.SDCardMedia.enType);
                           break;
                        default:
                           DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState ERROR oSDCardInfo.SDCardMedia.enType = %d", oSDCardInfo.SDCardMedia.enType);
                           break;
                     }
                     // evaluate HW write protection state
                     if( tSdcStates.SlotState == DIA_EN_DEVMGR_SDC_SLOT_STATE_REMOVED )         // Check if there is no SD Card inserted
                     {
                        DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState WriteProtectionState UNKNOWN");
                        tSdcStates.WriteProtectionState = DIA_EN_DEVMGR_SDC_WP_STATE_UNKNOWN;   // because the LINUX platform isn't able to give the WP state without inserted media
                     }
                     else                                                                       // SD Card inserted -> check for WP nWP
                     {
                        tSdcStates.WriteProtectionState = ( oSDCardInfo.HW_WriteProtected ) ? DIA_EN_DEVMGR_SDC_WP_STATE_PROTECTED : DIA_EN_DEVMGR_SDC_WP_STATE_NOT_PROTECTED;
                     }
                     // push SD Card states for one slot into list
                     oSdcStates.push_back( tSdcStates );

                     tUInt ui;
                     if(   (!oSDCardInfo.CardIdentifierRegister.CID.empty() )
                        && (oSDCardInfo.CardIdentifierRegister.CID.size() == SIZE_CID_REGISTER) )
                     {
                        // Copy Card Identifier (CID) register
                        for( ui=0; ui < SIZE_CID_REGISTER; ui++ )
                        {
                           tSdcCid.CID[ui] = oSDCardInfo.CardIdentifierRegister.CID[ui];
                        }
                     }
                     else
                     {
                        // Init CID register with 0
                        for( ui=0; ui < SIZE_CID_REGISTER; ui++ )
                        {
                           tSdcCid.CID[ui] = 0;
                        }
                        DIA_TR_INF(("dia_SAFeatureDeviceMGR::vHandleSDCardState: ERROR: oSDCardInfo.CardIdentifierRegister.CID is empty or has wrong size. Init with 0" ));
                     }
                     // Set SD Card slot number for SDC CID register
                     tSdcCid.SlotNo = oSDCardInfo.SDCardSlot;
                     // push SD Card states for one slot into list
                     oSdcCid.push_back( tSdcCid );
                     // trace out the Card Identifier register
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState    CardState= %d",oSDCardInfo.SDCardState.enType);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState    CardInfo = %d",oSDCardInfo.CardIdentifierRegister.CID[0]);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState    CardInfo = %d",oSDCardInfo.CardIdentifierRegister.CID[1]);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState    CardInfo = %d",oSDCardInfo.CardIdentifierRegister.CID[2]);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState    CardInfo = %d",oSDCardInfo.CardIdentifierRegister.CID[3]);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState    CardInfo = %d",oSDCardInfo.CardIdentifierRegister.CID[4]);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState    CardInfo = %d",oSDCardInfo.CardIdentifierRegister.CID[5]);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState    CardInfo = %d",oSDCardInfo.CardIdentifierRegister.CID[6]);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState    CardInfo = %d",oSDCardInfo.CardIdentifierRegister.CID[7]);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState    CardInfo = %d",oSDCardInfo.CardIdentifierRegister.CID[8]);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState    CardInfo = %d",oSDCardInfo.CardIdentifierRegister.CID[9]);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState    CardInfo = %d",oSDCardInfo.CardIdentifierRegister.CID[10]);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState    CardInfo = %d",oSDCardInfo.CardIdentifierRegister.CID[11]);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState    CardInfo = %d",oSDCardInfo.CardIdentifierRegister.CID[12]);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState    CardInfo = %d",oSDCardInfo.CardIdentifierRegister.CID[13]);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState    CardInfo = %d",oSDCardInfo.CardIdentifierRegister.CID[14]);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState    CardInfo = %d",oSDCardInfo.CardIdentifierRegister.CID[15]);
                     // trace out the other SD Card parameter
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState  1 SDCardSlot        = %d",oSDCardInfo.SDCardSlot);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState  2 SDCardMedia       = %d",oSDCardInfo.SDCardMedia.enType);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState  3 DeviceSerialNo    = %d",oSDCardInfo.DeviceSerialNo);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState  4 DevManufactureId  = %d",oSDCardInfo.DevManufactureId);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState  5 DevSpecVersion    = %d",oSDCardInfo.DevSpecVersion);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState  6 SW_WriteProtected = %d",oSDCardInfo.SW_WriteProtected);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState  7 HW_WriteProtected = %d",oSDCardInfo.HW_WriteProtected);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState  8 Mounted           = %d",oSDCardInfo.Mounted);
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState  9 TotalSize [MB]    = %d",(tU32) ((oSDCardInfo.TotalSize / 1024) / 1024));
                     DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState 10 MountPoint        = %s",oSDCardInfo.MountPoint.szValue);
                  } // for 'all devices'
               } // if( !SDCardList.empty() )
               else
               {
                  DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState SDCardList EMPTY!");
               }

               DIA_TR_INF(("dia_SAFeatureDeviceMGR::vHandleSDCardState - SDCardState forwarded to listener"));
               // forward to listener
               pListener->vOnSDStates( oSdcStates );
               pListener->vOnSDCIDRegister( oSdcCid );
            }
            break;
         }

         default:
            DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleSDCardState - OpCode not ok");
            break;
      }
      (void) poMessage->bDelete();
   }  // if( poMessage )
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureDeviceMGR::vHandleDeviceState( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureDeviceMGR::vHandleDeviceState");

   if( poMessage )
   {
      // Extract the operation code from the message.
      tU8 u8OpCode = poMessage->u8GetOpCode();

      // Switch on the opcode received
      switch (u8OpCode)
      {
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            fi_tclVisitorMessage oStatusMessage(poMessage);
            mplay_devicemanagerfi_tclMsgDevManagerNotifyConnectionStatus   oStatusMsgData;
            (void) oStatusMessage.s32GetData(oStatusMsgData);

            DIA_TR_INF(("dia_SAFeatureDeviceMGR::vHandleDeviceState - Received DeviceState"));

            dia_IDeviceMGRListener* pListener = OSAL_NULL;
            querySysAdapterListener<dia_IDeviceMGRListener>(&pListener);
            tU8 cdDriveCount=0;
            if ( pListener )
            {
               // Evaluate the USB Port list
               std::vector<mplay_fi_tcl_DevManager_PortStates>::const_iterator itPL = oStatusMsgData.USBPortList.begin();
               std::vector<dia_tUsbPortStates>   vecUsbPrtSt;
               dia_tUsbPortStates                  tUsbPrtSt;

               if (!oStatusMsgData.USBPortList.empty())
               {
                  DIA_TR_INF( "USBPortList.size() = %zu", oStatusMsgData.USBPortList.size() );

                  for (tU8 i=0; itPL != oStatusMsgData.USBPortList.end(); ++itPL, ++i )
                  {
                     mplay_fi_tcl_DevManager_PortStates oUsbPrtSt = (*itPL);
                     tUsbPrtSt.PortNo       = oUsbPrtSt.USBPortNo;
                     tUsbPrtSt.OverCurrent  = oUsbPrtSt.OverCurrent;
                     tUsbPrtSt.UnderVoltage = oUsbPrtSt.UnderVoltage;
                     tUsbPrtSt.HubConnected = oUsbPrtSt.HubConnected;
                     tUsbPrtSt.OpenCircuit  = oUsbPrtSt.OpenCircuit;
                     tUsbPrtSt.PowerOn      = oUsbPrtSt.USBPowerON;
                     vecUsbPrtSt.push_back( tUsbPrtSt );

                     DIA_TR_INF( "[%d]UsbPortStates (PortNo=%d,OverC=%d,UnderV=%d,HubC=%d,OpenCir=%d,PwOOn=%d) added", i, tUsbPrtSt.PortNo, tUsbPrtSt.OverCurrent, tUsbPrtSt.UnderVoltage, tUsbPrtSt.HubConnected, tUsbPrtSt.OpenCircuit, tUsbPrtSt.PowerOn );
                  }
               }

               // Now evaluate the device list
               std::vector<mplay_fi_tcl_DevManager_DeviceProperty>::const_iterator itDL = oStatusMsgData.Devicetype.begin();
               std::vector<dia_tDeviceInfo>   vecUsbDeviceInfo;
               dia_tDeviceInfo                  tDeviceInfo;

               if( !oStatusMsgData.Devicetype.empty() )
               {
                  DIA_TR_INF( "dia_SAFeatureDeviceMGR::vHandleDeviceState: MPLAY_DEVICEMANAGERFI_C_U16_SERVICE_MAJORVERSION=%u", (tU16)MPLAY_DEVICEMANAGERFI_C_U16_SERVICE_MAJORVERSION);
                  DIA_TR_INF( "Devicetype.size() = %zu", oStatusMsgData.Devicetype.size() );

                  for (tU8 i=0; itDL != oStatusMsgData.Devicetype.end(); ++itDL, ++i )
                  {
                     mplay_fi_tcl_DevManager_DeviceProperty oUSBDeviceInfo = (*itDL);
                     tDeviceInfo.PortNo      = static_cast<tU32>(atoi((char const*)oUSBDeviceInfo.USBPortNo.szValue));
                     tDeviceInfo.VendorID    = oUSBDeviceInfo.VendorID;
                     tDeviceInfo.ProductID   = oUSBDeviceInfo.ProductID;
                     tDeviceInfo.Size        = oUSBDeviceInfo.TotalSize;
                     switch( oUSBDeviceInfo.DeviceType.enType )
                     {
                       case mplay_fi_tcl_e8_Device::FI_EN_DTY_CDROM:
                       case mplay_fi_tcl_e8_Device::FI_EN_DTY_CDDA:
                       if((oUSBDeviceInfo.DeviceConnectStatus.enType)==(mplay_fi_tcl_e8_DeviceConnectStatus::FI_EN_USB_DEV_CONNECTED))
                          cdDriveCount++;
                           break;
                       default:
                           break;
                     }
                     switch( oUSBDeviceInfo.DeviceType.enType )
                     {
                        case mplay_fi_tcl_e8_Device::FI_EN_DTY_USB:
                           tDeviceInfo.DeviceType = DIA_EN_DEVMGR_DEVICE_TYPE_USB_MS;
                           break;
                        case mplay_fi_tcl_e8_Device::FI_EN_DTY_IPOD:
                        case mplay_fi_tcl_e8_Device::FI_EN_DTY_IPHONE:
                        case mplay_fi_tcl_e8_Device::FI_EN_DTY_IPAD:
                           tDeviceInfo.DeviceType = DIA_EN_DEVMGR_DEVICE_TYPE_USB_IPOD;
                           break;
                        case mplay_fi_tcl_e8_Device::FI_EN_DTY_MTP:
                           tDeviceInfo.DeviceType = DIA_EN_DEVMGR_DEVICE_TYPE_USB_MTP;
                           break;
                        case mplay_fi_tcl_e8_Device::FI_EN_DTY_MSZUNE:
                           tDeviceInfo.DeviceType = DIA_EN_DEVMGR_DEVICE_TYPE_USB_MSZUNE;
                           break;
                        case mplay_fi_tcl_e8_Device::FI_EN_DTY_SDCARD_INTERNAL:
                        case mplay_fi_tcl_e8_Device::FI_EN_DTY_NOT_SUPPORTED:
                        case mplay_fi_tcl_e8_Device::FI_EN_DTY_HUB:
                           tDeviceInfo.DeviceType = DIA_EN_DEVMGR_DEVICE_TYPE_USB_NOT_SUPPORTED;
                           break;
                        // None USB devices
                        case mplay_fi_tcl_e8_Device::FI_EN_DTY_SDCARD:
                           tDeviceInfo.DeviceType = DIA_EN_DEVMGR_DEVICE_TYPE_SDCARD;
                           break;
                        case mplay_fi_tcl_e8_Device::FI_EN_DTY_CDROM:
                           tDeviceInfo.DeviceType = DIA_EN_DEVMGR_DEVICE_TYPE_CDROM;
                           break;
                        default:
                           tDeviceInfo.DeviceType = DIA_EN_DEVMGR_DEVICE_TYPE_UNKNOWN;
                           break;
                     }
                     switch( oUSBDeviceInfo.DeviceConnectStatus.enType )
                     {
                        case mplay_fi_tcl_e8_DeviceConnectStatus::FI_EN_USB_DEV_CONNECTED:
                           tDeviceInfo.ConnectionState = DIA_EN_DEVMGR_CONNECT_STATE_CONNECTED;
                           break;
                        case mplay_fi_tcl_e8_DeviceConnectStatus::FI_EN_USB_DEV_REMOVED_BY_USR:
                           tDeviceInfo.ConnectionState = DIA_EN_DEVMGR_CONNECT_STATE_REMOVED;
                           break;
                        case mplay_fi_tcl_e8_DeviceConnectStatus::FI_EN_USB_DEV_UNAVAIL_BAT_LOWVOLT:
                           tDeviceInfo.ConnectionState = DIA_EN_DEVMGR_CONNECT_STATE_UNAVAIL_BAT_LOWVOLT;
                           break;
                        case mplay_fi_tcl_e8_DeviceConnectStatus::FI_EN_USB_DEV_UNAVAIL_HW_MALFUNC:
                           tDeviceInfo.ConnectionState = DIA_EN_DEVMGR_CONNECT_STATE_UNAVAIL_HW_MALFUNC;
                           break;
                        case mplay_fi_tcl_e8_DeviceConnectStatus::FI_EN_USB_DEV_UNDEFINED:
                        default:
                           tDeviceInfo.ConnectionState = DIA_EN_DEVMGR_CONNECT_STATE_UNKNOWN;
                           break;
                     }

                     switch( oUSBDeviceInfo.DeviceSpeedUsb.enType )
                     {
                        case mplay_fi_tcl_e8_DVM_DeviceSpeedUsb::FI_EN_LOW_SPEED:
                           tDeviceInfo.DeviceSpeed = DIA_EN_DEVMGR_DEVICE_SPEED_LOW;
                        break;
                        case mplay_fi_tcl_e8_DVM_DeviceSpeedUsb::FI_EN_FULL_SPEED:
                           tDeviceInfo.DeviceSpeed = DIA_EN_DEVMGR_DEVICE_SPEED_FULL;
                        break;
                        case mplay_fi_tcl_e8_DVM_DeviceSpeedUsb::FI_EN_HI_SPEED:
                           tDeviceInfo.DeviceSpeed = DIA_EN_DEVMGR_DEVICE_SPEED_HIGH;
                        break;
                        case mplay_fi_tcl_e8_DVM_DeviceSpeedUsb::FI_EN_SUPER_SPEED:
                           tDeviceInfo.DeviceSpeed = DIA_EN_DEVMGR_DEVICE_SPEED_SUPER;
                        break;

                        default:
                           tDeviceInfo.DeviceSpeed = DIA_EN_DEVMGR_DEVICE_SPEED_UNKNOWN;
                        break;
                     }
                     tDeviceInfo.DeviceBaseClass   = oUSBDeviceInfo.BaseClassCodeUsb;
                     tDeviceInfo.DeviceSubClass    = oUSBDeviceInfo.SubClassCodeUsb;
                     tDeviceInfo.Protocol          = oUSBDeviceInfo.ProtocolUsb;

                     switch( oUSBDeviceInfo.FileSystemType.enType )
                     {
                        case mplay_fi_tcl_e8_FileSystem::FI_EN_FSTY_FAT:
                           tDeviceInfo.FileSystem = DIA_EN_DEVMGR_FILE_SYSTEM_FAT;
                        break;
                        case mplay_fi_tcl_e8_FileSystem::FI_EN_FSTY_NTFS:
                           tDeviceInfo.FileSystem = DIA_EN_DEVMGR_FILE_SYSTEM_NTFS;
                        break;
                        case mplay_fi_tcl_e8_FileSystem::FI_EN_FSTY_EXT4:
                           tDeviceInfo.FileSystem = DIA_EN_DEVMGR_FILE_SYSTEM_EXT4;
                        break;
                        case mplay_fi_tcl_e8_FileSystem::FI_EN_FSTY_HFS:
                           tDeviceInfo.FileSystem = DIA_EN_DEVMGR_FILE_SYSTEM_HFS;
                        break;
                        case mplay_fi_tcl_e8_FileSystem::FI_EN_FSTY_EXFAT:
                           tDeviceInfo.FileSystem = DIA_EN_DEVMGR_FILE_SYSTEM_EXFAT;
                        break;
                        case mplay_fi_tcl_e8_FileSystem::FI_EN_FSTY_ISO9660:
                           tDeviceInfo.FileSystem = DIA_EN_DEVMGR_FILE_SYSTEM_ISO9660;
                        break;
                        case mplay_fi_tcl_e8_FileSystem::FI_EN_FSTY_UDF:
                           tDeviceInfo.FileSystem = DIA_EN_DEVMGR_FILE_SYSTEM_UDF;
                        break;

                        default:
                           tDeviceInfo.FileSystem = DIA_EN_DEVMGR_FILE_SYSTEM_UNKNOWN;
                        break;
                     }

                     if (i!=0)
                     {
                        DIA_TR_INF( "------------------------------------");
                     }

                     DIA_TR_INF( "[%d]PortNo (string)     = %s", i, (char*)oUSBDeviceInfo.USBPortNo);
                     DIA_TR_INF( "[%d]PortNo (dec)        = %d", i, tDeviceInfo.PortNo);
                     DIA_TR_INF( "[%d]VendorID            = 0x%04X", i, tDeviceInfo.VendorID);
                     DIA_TR_INF( "[%d]ProductID           = 0x%04X", i, tDeviceInfo.ProductID);
                     DIA_TR_INF( "[%d]Size                = 0x%08llX", i, tDeviceInfo.Size);
                     DIA_TR_INF( "[%d]DeviceType          = %d", i, tDeviceInfo.DeviceType);
                     DIA_TR_INF( "[%d]ConnectionState     = %d", i, tDeviceInfo.ConnectionState);
                     DIA_TR_INF( "[%d]DeviceSpeed         = %d", i, tDeviceInfo.DeviceSpeed);
                     DIA_TR_INF( "[%d]DeviceBaseClass     = %d", i, tDeviceInfo.DeviceBaseClass);
                     DIA_TR_INF( "[%d]DeviceSubClass      = %d", i, tDeviceInfo.DeviceSubClass);
                     DIA_TR_INF( "[%d]Protocol            = %d", i, tDeviceInfo.Protocol);
                     DIA_TR_INF( "[%d]FileSystem          = %d", i, tDeviceInfo.FileSystem);

                     DIA_TR_INF( "[%d]oUSBDeviceInfo.DeviceType          = %d", i, oUSBDeviceInfo.DeviceType.enType );
                     DIA_TR_INF( "[%d]oUSBDeviceInfo.DeviceConnectStatus = %d", i, oUSBDeviceInfo.DeviceConnectStatus.enType );
                     DIA_TR_INF( "[%d]oUSBDeviceInfo.DeviceSpeedUsb      = %d", i, oUSBDeviceInfo.DeviceSpeedUsb.enType );
                     DIA_TR_INF( "[%d]oUSBDeviceInfo.TotalSize in MB     = %d", i, (tU32) ((oUSBDeviceInfo.TotalSize/1024)/1024) );

                     // Push the device data into corresponding list (USB, SD, CD)
                     switch( tDeviceInfo.DeviceType )
                     {
                        case DIA_EN_DEVMGR_DEVICE_TYPE_SDCARD:
      //                     oSdcDeviceInfo.push_back( tDeviceInfo );
                           break;
                        case DIA_EN_DEVMGR_DEVICE_TYPE_CDROM:
      //                     oCdDeviceInfo.push_back( tDeviceInfo );
                           break;
                        default: // DIA_EN_DEVMGR_DEVICE_TYPE_USB_MS, DIA_EN_DEVMGR_DEVICE_TYPE_USB_IPOD, DIA_EN_DEVMGR_DEVICE_TYPE_USB_MTP, ...

                           //Christian Koechling: interface changed of vd_dvm: backward compatible integration
                           if ((MPLAY_DEVICEMANAGERFI_C_U16_SERVICE_MAJORVERSION <=2 /*old version*/) && (i == 0 /*first element ignored*/))
                           {
                              //Ignore this element with index=0, because index=0 means that this device was put to the socket as a last (and could not be present anymore)
                              DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleDeviceState: vddvm: old interface -- ignore this element");
                           }
                           else
                           {
                              vecUsbDeviceInfo.push_back( tDeviceInfo );
                           }
                           break;
                     }
                  }
               }

               DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleDeviceState - USB device info forwarded to listener");
               pListener->vOnUSBDeviceInfo( vecUsbDeviceInfo );
               pListener->vOnUSBPortStates( vecUsbPrtSt );
               pListener->vOnGetCDInsertCount( cdDriveCount );
            }
            break;
         }

         default:
            DIA_TR_INF(("dia_SAFeatureDeviceMGR::vHandleDeviceState - OpCode not ok"));
            break;
      }

      // Delete the message we are unable process it at this time
      (void) poMessage->bDelete();
   }  // if( poMessage )
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureDeviceMGR::vHandleMountCDROMInternal( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc( "dia_SAFeatureDeviceMGR::vHandleMountCDROMInternal" );

   if( poMessage )
   {
      // Extract the operation code from the message.
      tU8 u8OpCode = poMessage->u8GetOpCode();

      // Switch on the opcode received
      switch( u8OpCode )
      {
         case CCA_C_U8_OPCODE_METHODRESULT:
         {
            DIA_TR_INF(( "dia_SAFeatureDeviceMGR::vHandleMountCDROMInternal - Received MethodResult: MountCDROMInternal" ));
            fi_tclVisitorMessage                                                 oReceivedMsg( poMessage );
            mplay_devicemanagerfi_tclMsgDevManagerMountCDROMInternalMethodResult oReceivedData;
            (void)oReceivedMsg.s32GetData( oReceivedData );

            dia_IDeviceMGRListener* pListener = OSAL_NULL;
            querySysAdapterListener<dia_IDeviceMGRListener>(&pListener);
            if ( pListener )
            {
               DIA_TR_INF(( "dia_SAFeatureDeviceMGR::vHandleMountCDROMInternal: call vOnCDModeChangeResultDVM( )" ));
               tDiaResult eDiaResult = (oReceivedData.Success) ? DIA_SUCCESS : DIA_FAILED;
               pListener->vOnCDModeChangeResultDVM( eDiaResult );
            }
            break;
         }
         default:
            DIA_TR_INF(( "dia_SAFeatureDeviceMGR::vHandleMountCDROMInternal - OpCode not ok" ));
            break;
      }
      // Delete the message we are unable process it at this time
      (void) poMessage->bDelete();
   }  // if( poMessage )
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDeviceMGR::regOpticDiskConnectionStatusValues( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureDeviceMGR::regOpticDiskConnectionStatusValues()");

   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("dia_SAFeatureDeviceMGR::regOpticDiskConnectionStatusValues - send message.");
      gm_tclEmptyMessage oMessage ( mAppID, mpSrvPlugin->getClientID(),
                                    mpSrvPlugin->getRegistrationID(), 0,
                                    mpSrvPlugin->getServiceID(),
                                    MPLAY_DEVICEMANAGERFI_C_U16_DEVMANAGERNOTIFYSLOTSTATEOPTICALDISC,
                                    CCA_C_U8_OPCODE_UPREG
                                  );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureDeviceMGR::regOpticDiskConnectionStatusValues - transmitMessage success.");
      }
      else
      {
         DIA_TR_INF("dia_SAFeatureDeviceMGR::regOpticDiskConnectionStatusValues - transmitMessage failed.");
      }
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureDeviceMGR::regOpticDiskConnectionStatusValues - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureDeviceMGR::regOpticDiskConnectionStatusValues - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureDeviceMGR::ConvertOpticalDeviceStateToInternal(dia_eOpticalDiscSlotState &opticalDiscStatusInternal,const mplay_fi_tcl_e8_SlotStateOpticalDiscType enSlotStateOpticalDisc) const
{
   dia_tclFnctTrace trc("dia_SAFeatureDeviceMGR::ConvertOpticalDeviceStateToInternal");

    switch (enSlotStateOpticalDisc.enType)
    {
    case mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_INITIALISING:
        opticalDiscStatusInternal = DIA_EN_OPTDISC_INITIALISING;
        break;
    case mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_INITIALISED:
        opticalDiscStatusInternal = DIA_EN_OPTDISC_INITIALISED;
        break;
    case mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_LASTMODE_EMTPY:
        opticalDiscStatusInternal = DIA_EN_OPTDISC_LASTMODE_EMTPY;
        break;
    case mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_LASTMODE_INSERTED_CDDA:
        opticalDiscStatusInternal = DIA_EN_OPTDISC_LASTMODE_INSERTED_CDDA;
        break;
    case mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_LASTMODE_INSERTED_CDROM:
        opticalDiscStatusInternal = DIA_EN_OPTDISC_LASTMODE_INSERTED_CDROM;
        break;
    case mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_LASTMODE_INSERTED_CDERROR:
        opticalDiscStatusInternal = DIA_EN_OPTDISC_LASTMODE_INSERTED_CDERROR;
        break;
    case mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_INSERTING:
        opticalDiscStatusInternal = DIA_EN_OPTDISC_INSERTING;
        break;
    case mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_INSERTED_CDAUDIO:
        opticalDiscStatusInternal = DIA_EN_OPTDISC_INSERTED_CDAUDIO;
        break;
    case mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_INSERTED_CDROM:
        opticalDiscStatusInternal = DIA_EN_OPTDISC_INSERTED_CDROM;
        break;
    case mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_INSERTED_CDERROR:
        opticalDiscStatusInternal = DIA_EN_OPTDISC_INSERTED_CDERROR;
        break;
    case mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_INSERTED_AUTOMATIC_CDAUDIO:
        opticalDiscStatusInternal = DIA_EN_OPTDISC_INSERTED_AUTOMATIC_CDAUDIO;
        break;
    case mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_INSERTED_AUTOMATIC_CDROM:
        opticalDiscStatusInternal = DIA_EN_OPTDISC_INSERTED_AUTOMATIC_CDROM;
        break;
    case mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_INSERTED_AUTOMATIC_CDERROR:
        opticalDiscStatusInternal = DIA_EN_OPTDISC_INSERTED_AUTOMATIC_CDERROR;
        break;
    case mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_EJECTING:
        opticalDiscStatusInternal = DIA_EN_OPTDISC_EJECTING;
        break;
    case mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_EJECTED_READY_TO_REMOVE:
        opticalDiscStatusInternal = DIA_EN_OPTDISC_EJECTED_READY_TO_REMOVE;
        break;
    case mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_EJECTED_EMPTY:
        opticalDiscStatusInternal = DIA_EN_OPTDISC_EJECTED_EMPTY;
        break;
    case mplay_fi_tcl_e8_SlotStateOpticalDiscType::FI_EN_UNDEFINED:
    default:
        opticalDiscStatusInternal = DIA_EN_OPTDISC_UNDEFINED_STATE;
        break;


    }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureDeviceMGR::vHandleOpticalDiskConnectionStatusResult( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc( "dia_SAFeatureDeviceMGR::vHandleOpticalDiskConnectionStatusResult" );

   if( poMessage )
   {
      // Extract the operation code from the message.
      tU8 u8OpCode = poMessage->u8GetOpCode();
      // Switch on the opcode received
      switch( u8OpCode )
      {
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            DIA_TR_INF(( "dia_SAFeatureDeviceMGR::vHandleOpticalDiskConnectionStatusResult - Received Optic Disk Connection Status Notification" ));
            fi_tclVisitorMessage                                                 oReceivedMsg( poMessage );
            mplay_devicemanagerfi_tclMsgDevManagerNotifySlotStateOpticalDiscStatus oReceivedData;
            (void)oReceivedMsg.s32GetData( oReceivedData );

            dia_eOpticalDiscSlotState eOpticDiskConnectionStatus;

            dia_IDeviceMGRListener* pListener = OSAL_NULL;
            querySysAdapterListener<dia_IDeviceMGRListener>(&pListener);
            if ( pListener )
            {
               if(!oReceivedData.OpticalDiscSlotState.empty())
               {
                   mplay_fi_tcl_e8_SlotStateOpticalDiscType oFiOpticalDiscStatus;
                   oFiOpticalDiscStatus = oReceivedData.OpticalDiscSlotState.front();
                   ConvertOpticalDeviceStateToInternal(eOpticDiskConnectionStatus,oFiOpticalDiscStatus);
                   DIA_TR_INF(( "dia_SAFeatureDeviceMGR::vHandleOpticalDiskConnectionStatusResult: call vOnOpticDiskConnectionStatus( )" ));
                   pListener->vOnOpticDiskConnectionStatus( eOpticDiskConnectionStatus );
               }
               else
               {
                   DIA_TR_INF( "dia_SAFeatureDeviceMGR::vHandleOpticalDiskConnectionStatusResult oReceivedData.OpticalDiscSlotState is empty." );
               }
            }
            break;
         }

         default:
            DIA_TR_INF("dia_SAFeatureDeviceMGR::vHandleOpticalDiskConnectionStatusResult - OpCode not ok (%d)", u8OpCode);
         break;
      }
      // Delete the message we are unable process it at this time
      (void) poMessage->bDelete();
   }
}
