/*
 * dia_SAFeatureDefaultSettingsCompatible.h
 *
 *  Created on: 27.09.2011
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_SAFEATURE_DEFAULT_SETTINGS_COMPATIBLE__
#define __INCLUDED_DIA_SAFEATURE_DEFAULT_SETTINGS_COMPATIBLE__

#ifndef __INCLUDED_DIA_COMMON_CONFIG__
#include "common/framework/config/dia_common_config.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MODULE__
#include <common/framework/sysset/dia_SystemSettingsModule.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__
#include <common/framework/sysadapters/dia_SystemAdapterFeature.h>
#endif

class amt_tclServiceData;
class dia_SystemAdapterServicePlugin;

class dia_SAFeatureDefaultSettingsCompatible
   : public dia_SystemAdapterFeature,
     public dia_SystemSettingsModule
{
public:
   // constructor
   dia_SAFeatureDefaultSettingsCompatible (
         tCString name,
         tU32 u32SystemSetId,
         tU32 u32SystemSetTypes,
         dia_SystemAdapterServicePlugin& pSrvPlugin,
         tU8  defsetGroup,
         tU16 u16MethodFunctionId,
         tU16 u16PropertyFunctionId = 0xFFFF
   );
   // destructor
   virtual ~dia_SAFeatureDefaultSettingsCompatible ( tVoid );

   //--------------------------------------------------------------------------
   // Methods inherited from dia_SystemSettingsModule
   //--------------------------------------------------------------------------

   //! prepare the module for the system setting
   virtual tDiaResult prepareSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData );
   //! execute the system setting
   virtual tDiaResult executeSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData  );
   //! finalize the system setting
   virtual tDiaResult finalizeSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData  );

   //--------------------------------------------------------------------------
   // Methods inherited from dia_SystemAdapterFeature
   //--------------------------------------------------------------------------

   virtual tDiaResult getFunctionIDs ( std::list<tU16>& results ) const;
   virtual tDiaResult dispatchMessage (amt_tclBaseMessage *pBaseMessage);

protected:
   // constructor
   dia_SAFeatureDefaultSettingsCompatible ( void ); // Not implemented, do not use

   //! handler for coding and defset results
   virtual void vEvalMethodResponse ( amt_tclServiceData* poMessage );
   virtual void vEvalPropertyResponse ( amt_tclServiceData* poMessage );

   bool bSendMethodStart ( dia_UID typeUID );

//   void vHandleDefsetMessage ( amt_tclServiceData* poMessage );// const

   dia_UID mSystemSettingTypeUID;
   tU32 mu32SystemSetId;
   tU32 mu32SystemSetTypes;
   tU8  mu8DefsetGroup;
   tU16 mu16MethodFid;
   tU16 mu16PropertyFid;

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureDefaultSettingsCompatible)
};

#endif /* __INCLUDED_DIA_SAFEATURE_DEFAULT_SETTINGS_COMPATIBLE__ */
