/**
 * \file      dia_SAFeatureCodingUpdate.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      30.01.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */


#ifndef __INCLUDED_DIA_SAFEATURE_CODING_UPDATE__
#define __INCLUDED_DIA_SAFEATURE_CODING_UPDATE__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_DIAGLIB__
#include "dia_SystemAdapterFeatureDiaglib.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_NOTIFIER__
#include "common/framework/config/dia_ConfigNotifier.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SYSTEM_SETTINGS_DIAGLIB_LISTENER__
#include "../../depricated/SystemAdapter/dia_IDiaglibSysSetListener.h"
#endif

class amt_tclServiceData;

//-----------------------------------------------------------------------------

class dia_SAFeatureCodingUpdate
   : public dia_SystemAdapterFeatureDiaglib,
     public dia_ConfigNotifier,
     public dia_IDiaglibSysSetListener
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SAFeatureCodingUpdate);

public:
   //! class constructor
   dia_SAFeatureCodingUpdate ( tCString name, tU32 propID, tU32 systemSetID, dia_SystemAdapterServicePluginDiaglib& pSrvPlugin );
   //! class destructor
   virtual ~dia_SAFeatureCodingUpdate ( tVoid );

   virtual tDiaResult getDiaglibIDs ( std::list<tU32>& results ) const;

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_RemoteControlPlugin methods
   //
   //-------------------------------------------------------------------------

   //! send notification for property propID to system settings listener identified by systemSetID
   virtual tDiaResult onPropertyUpdate ( tU32 propID );

   //--------------------------------------------------------------------------
   //
   // Overloaded dia_IDiaglibSysSetListener methods
   //
   //--------------------------------------------------------------------------

   //! receive result from diaglib
   virtual tVoid vOnSystemSetResult ( tenSystemSetResult enSystemSetResult, const tDiaglibParamVector& oErrorList );
   //! dispatch message for evaluation to diaglib system adapter
   virtual tDiaResult dispatchMessage ( amt_tclBaseMessage *pBaseMessage );

protected:
   //! handle incoming CCA message
   tVoid vHandleSystemSetMessage ( amt_tclServiceData* poMessage );

protected:
   //!
   //! diaglib system settings id
   tU32 mSysSetID;
};

#endif /* __INCLUDED_DIA_SAFEATURE_CODING_UPDATE__ */
