/*
 * dia_SAFeatureTunerMaster.h
 *
 *  Created on: 12.10.2012
 *      Author: shw2abt
 */

#ifndef DIA_SAFEATUREAUDIOMANAGER_H_
#define DIA_SAFEATUREAUDIOMANAGER_H_

#include <org/genivi/audiomanager/CommandInterfaceProxy.h>
#include <org/genivi/audiomanager/CommandInterfaceClientBase.h>

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterFeatureASF.h>
#endif

#ifndef __INCLUDED_DIA_IAUDIO_SOURCE_LISTENER__
#include <common/interfaces/dia_IAudioSourceListener.h>
#endif

using namespace org::genivi::audiomanager::CommandInterface;

enum dia_AudioManagerConnectionState
{
   CS_UNKNOWN = 0,
   CS_CONNECTING,
   CS_CONNECTED,
   CS_DISCONNECTING,
   CS_DISCONNECTED,
   CS_SUSPENDED
};

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureAudioManager
   : public dia_SystemAdapterFeatureASF<CommandInterfaceProxy>,
     public CommandInterfaceClientBase,
     public dia_IAudioSource
{
public:
   //! constructor
   dia_SAFeatureAudioManager ( dia_SystemAdapterServicePluginASF<CommandInterfaceProxy>& pSrvPlugin );
   //! destructor
   virtual ~dia_SAFeatureAudioManager();

   //! start monitoring of properties
   virtual tDiaResult startMonitoring();
   //! stop monitoring of properties
   virtual tDiaResult stopMonitoring();

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IAudioSource methods
   //
   //-------------------------------------------------------------------------

#ifdef __DIA_NEW_AUDIO_SOURCE_SWITCHING_FSM__
   //! set the audio source
   virtual tDiaResult setAudioSource ( dia_eAudioSource src );
#endif
   //! set the audio source
   virtual tDiaResult setAudioSource ( tU8 sourceID, tU8 sinkID );
   //! retrieve the currently activated audio source
   virtual tDiaResult getAudioSource();
   //! retrieve the list of existing audio connections
   virtual tDiaResult getAudioConnections ( void );
   //! retrieve list of all possible sources with their ID
   virtual tDiaResult getAudioSourceList();
   //! retrieve list of all possible sinks with their dynamic ID
   virtual tDiaResult getAudioSinkList();

   // NumberOfMainConnectionsChangedCallbackIF
   virtual void onNumberOfMainConnectionsChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< NumberOfMainConnectionsChangedError >& error);
   virtual void onNumberOfMainConnectionsChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< NumberOfMainConnectionsChangedSignal >& signal);

   // MainConnectionStateChangedCallbackIF
   virtual void onMainConnectionStateChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< MainConnectionStateChangedError >& error);
   virtual void onMainConnectionStateChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< MainConnectionStateChangedSignal >& signal);

   // GetListMainConnectionsCallbackIF
   virtual void onGetListMainConnectionsError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetListMainConnectionsError >& error);
   virtual void onGetListMainConnectionsResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetListMainConnectionsResponse >& response);

   // GetListMainSourcesCallbackIF
   virtual void onGetListMainSourcesError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetListMainSourcesError >& error);
   virtual void onGetListMainSourcesResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetListMainSourcesResponse >& response);

   // GetListMainSinksCallbackIF'
   virtual void onGetListMainSinksError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetListMainSinksError >& error);
   virtual void onGetListMainSinksResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< GetListMainSinksResponse >& response);

   // ConnectCallbackIF
   virtual void onConnectError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< ConnectError >& error);
   virtual void onConnectResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< ConnectResponse >& response);

   //! update the connection response to the listeners
   virtual void onGetListMainSourcesResponse(const std::vector<dia_tAudioSourceType>& audioSrcList); //lint !e1411 Warning : Member with different signature hides virtual member
   virtual void onGetListMainSinksResponse( const std::vector<dia_tAudioSinkType>& audioSinkList); //lint !e1411 Warning : Member with different signature hides virtual member
   virtual void onGetListMainConnectionsResponse ( const std::vector<dia_tAudioConnectionType>& connectionInfoRep ); //lint !e1411 Warning : Member with different signature hides virtual member
   virtual void onMainConnectionStateChanged ( const dia_tAudioConnectionType& connectionInfo ); //lint !e1411 Warning : Member with different signature hides virtual member
   virtual void onAudioSourceConnectionFailed ( tDiaResult errCode );

   ////////////////////////////////////////////////////////////////////////
   // deprecated methods
   ////////////////////////////////////////////////////////////////////////

#ifndef __DIA_NEW_AUDIO_SOURCE_SWITCHING_FSM__
   virtual tDiaResult setAudioSource ( dia_eAudioSource /*src*/ ) { return DIA_E_NOT_SUPPORTED; }
   virtual void onAudioSourceConnectionDone ( tU32 status );
   virtual void onGetListMainConnectionsResponse(tU8 audioSrcId); //lint !e1411 Warning : Member with different signature hides virtual member
#endif

protected:
   //! deprecated default constructor
   dia_SAFeatureAudioManager ();

   //! extract source identifier and device information from source name
   void evaluateSourceName ( const std::string& sourceName, dia_tAudioSourceType& srcInfo ) const;
   //! extract sink identifier and device information from source name
   void evaluateSinkName ( const std::string& sinkName, dia_tAudioSinkType& sinkInfo ) const;

   dia_tAudioSourceType* querySourceByID ( int sourceID );
   dia_tAudioSourceType* querySourceByEnum ( dia_eAudioSource sourceID );
   dia_tAudioSinkType* querySinkByID ( int sinkID );
   dia_tAudioSinkType* querySinkByEnum ( dia_eAudioSink sinkID );
   dia_tAudioConnectionType* queryConnectionByID ( tU32 connectionID );
   dia_tAudioConnectionType* queryConnectionByEnum ( dia_eAudioSource sourceID, dia_eAudioSink sinkID );

   tU8 readDevIDFromSourceID ( int startPos, const std::string& sourceName ) const;

protected:
   act_t mNumberOfMainConnectionsChangeReg;
   act_t mMainConnectionStateChangeReg;
   //! member that stores information about the requested connection
   dia_tAudioConnectionType mRequestedConnection;
   //! repository of available sources
   std::vector<dia_tAudioSourceType> mSourceInfoRep;
   //! repository of available sinks
   std::vector<dia_tAudioSinkType> mSinkInfoRep;
   //! repository of available connections
   std::vector<dia_tAudioConnectionType> mConnectionInfoRep;
};

#endif /* DIA_SAFEATUREAUDIOMANAGER_H_ */
