/*
 * dia_RemoteControlPluginHMI.h
 *
 *  Created on: 24.06.2017
 *      Author: abe6kor
 */

#ifndef __INCLUDED_DIA_REMOTE_CONTROL_PLUGIN_HMI__
#define __INCLUDED_DIA_REMOTE_CONTROL_PLUGIN_HMI__


#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif


#define DIAGNOSTICS_S_IMPORT_INTERFACE_GENERIC
#define DIAGNOSTICS_S_IMPORT_INTERFACE_MSG
#include "fc_diagnosis_if.h"

#ifndef __INCLUDED_DIA_REMOTE_CONTROL_PLUGIN__
#include "common/framework/application/dia_RemoteControlPlugin.h"
#endif

#include "common/framework/sysadapters/dia_SystemAdapterFeature.h"

#ifndef __INCLUDED_DIA_INTERFACE_REMOTECONTROL_LISTENER__
#include "common/interfaces/dia_IRemoteControlListener.h"
#endif
//-----------------------------------------------------------------------------

#define U8RCTRLSOURCE_TEF       (tU8)0x01

class dia_IRemoteControlListener;

class dia_RemoteControlPluginHMI
: public dia_SystemAdapterFeature,
  public dia_RemoteControlPlugin
{
	DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_RemoteControlPluginHMI);

public:
	//! class constructor
	dia_RemoteControlPluginHMI ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin);

	//! destructor
	virtual ~dia_RemoteControlPluginHMI ( void );
	//! set remote control to the specified mode
	virtual tDiaResult requestRemoteControlMode ( dia_eRemoteCtrlMode mode, dia_RemoteControlSettings settings = DIA_C_U32_REMOTE_CTRL_SETTINGS_DEFAULT);


protected:
	tVoid vHandleRemoteControlMessage ( amt_tclServiceData* poMessage );
	bool  bUpreg(amt_tclServiceData const* poMessage);
	bool  bRelUpreg(amt_tclServiceData const* poMessage);
	DECLARE_MSG_MAP(dia_RemoteControlPluginHMI)

private:
	diagnostics_tclApp* m_poGWMain;
	tVoid vNotifyAllClients(fi_tclTypeBase const&, tU16);
	tVoid vSendStatusMsg(amt_tclServiceData const*, fi_tclTypeBase const&) const;
	tVoid vSendMsg(amt_tclServiceData const*, fi_tclTypeBase const&, tU8) const;
};

#endif /* __INCLUDED_DIA_REMOTE_CONTROL_PLUGIN_HMI__ */
