/*
 * dia_RemoteControlPluginHMI.cpp
 *
 *  Created on: 24.06.2017
 *      Author: abe6kor
 */

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef __INCLUDED_DIA_REMOTE_CONTROL_PLUGIN_HMI__
#include "dia_RemoteControlPluginHMI.h"
#endif


#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard


BEGIN_MSG_MAP( dia_RemoteControlPluginHMI, dia_SystemAdapterFeature )
ON_MESSAGE(MIDW_DIAGNOSTICSFI_C_U16_REMOTECONTROL, vHandleRemoteControlMessage)
END_MSG_MAP()

//-----------------------------------------------------------------------------
dia_RemoteControlPluginHMI::dia_RemoteControlPluginHMI (
		tCString name,    // feature name
		dia_SystemAdapterServicePlugin& pSrvPlugin
)
: dia_SystemAdapterFeature(name,pSrvPlugin),
  dia_RemoteControlPlugin("RemotePluginHMI",DIA_EN_REMOTE_PLUGIN_HMI)
{
	dia_tclFnctTrace trc("dia_RemoteControlPluginHMI::dia_RemoteControlPluginHMI");
	m_poGWMain = diagnostics_tclApp::getInstance();
}
//-----------------------------------------------------------------------------

dia_RemoteControlPluginHMI::~dia_RemoteControlPluginHMI ( void )
{
}
//-----------------------------------------------------------------------------

tDiaResult
dia_RemoteControlPluginHMI::requestRemoteControlMode(dia_eRemoteCtrlMode mode, dia_RemoteControlSettings settings)
{
	dia_tclFnctTrace oTrace("dia_RemoteControlPluginHMI::requestRemoteControlMode()"); //lint !e1788 ok --> scoped trace

	DIA_TR_INF("requestRemoteControlMode():mode=%d, settings=%d.", mode, settings);

	if ( !(settings & DIA_C_U32_REMOTE_CTRL_SETTINGS_NO_HMI) )
	{
		// create status result object
		midw_diagnosticsfi_tclMsgRemoteControlStatus oStatusData;
		oStatusData.src.enType = static_cast<midw_fi_tcl_e8_RCtrlSource::tenType>(U8RCTRLSOURCE_TEF);
		if (mode == DIA_EN_REMOTE_CONTROL_MODE_ACTIVE)
		{
			oStatusData.cmd.enType = static_cast<midw_fi_tcl_e8_RCtrlCommand::tenType>(0x01);
			DIA_TR_INF(">> REQUESTING HMI REMOTE CONTROL ACTIVATION <<");
		}
		else
		{
			oStatusData.cmd.enType = static_cast<midw_fi_tcl_e8_RCtrlCommand::tenType>(0x00);
			DIA_TR_INF(">> REQUESTING HMI REMOTE CONTROL DEACTIVATION <<");
		}
		oStatusData.signal.enType = static_cast<midw_fi_tcl_e8_RCtrlSignal::tenType>(0xFF);
		oStatusData.status = TRUE;

		DIA_TR_INF(">> UPDATE REGISTERED CLIENTS <<");

		vNotifyAllClients(oStatusData, MIDW_DIAGNOSTICSFI_C_U16_REMOTECONTROL);
	}
	else
	{
		DIA_TR_INF("requestRemoteControlMode: HMI has been skipped.");

		vOnRemoteControlUpdate(mode);
	}

	return DIA_SUCCESS;
}

tVoid
dia_RemoteControlPluginHMI::vHandleRemoteControlMessage(amt_tclServiceData* poMessage)
{
	dia_tclFnctTrace oTrace("dia_RemoteControlPluginHMI::vHandleRemoteControlMessage()"); //lint !e1788 ok --> scoped trace

	OSAL_vAssert(poMessage->bIsServerMessage() == FALSE);

	if (OSAL_NULL == m_poGWMain)
		return;

	// the opcode tells what we should do
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_UPREG:
	{
		DIA_TR_INF("vHandleRemoteControlMessage --> AMT_C_U8_CCAMSG_OPCODE_UPREG !!");
		if (!bUpreg(poMessage))
		{
			// create and send error  message
			amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_UPREG_FAILURE);
			m_poGWMain->enPostMessage(&oErrorMessage);
			DIA_ASSERT_ALWAYS();
		}
		else
		{
			DIA_TR_INF("vHandleRemoteControlMessage --> vSendStatusMsg !!");
			// Upreg successful : send a status message.
			midw_diagnosticsfi_tclMsgRemoteControlSet oStatusData;
			// send dummy status data
			vSendStatusMsg(poMessage, oStatusData);
		}
	}
	break;

	case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
	{
		DIA_TR_INF("vHandleRemoteControlMessage --> AMT_C_U8_CCAMSG_OPCODE_RELUPREG !!");
		if (!bRelUpreg(poMessage))
		{
			// Relupreg failed: send an error message
			amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_RELUPREG_FAILURE);
			m_poGWMain->enPostMessage(&oErrorMessage);
			DIA_ASSERT_ALWAYS();
		}
		else
		{
			// Relupreg successful : no action
		}
	}
	break;

	case AMT_C_U8_CCAMSG_OPCODE_SET:
	{
		DIA_TR_INF("vHandleRemoteControlMessage --> AMT_C_U8_CCAMSG_OPCODE_SET !!");

		fi_tclVisitorMessage oResultMsg(poMessage);
		midw_diagnosticsfi_tclMsgRemoteControlSet oRemoteCtrlResp;
		(tVoid) oResultMsg.s32GetData(oRemoteCtrlResp);

		dia_eRemoteCtrlMode mode = (oRemoteCtrlResp.cmd.enType == midw_fi_tcl_e8_RCtrlCommand::FI_EN_RCTRL_CMD_ACTIVATE)
        								 ? DIA_EN_REMOTE_CONTROL_MODE_ACTIVE : DIA_EN_REMOTE_CONTROL_MODE_NOT_ACTIVE;

		if (oRemoteCtrlResp.status == TRUE)
		{
			vOnRemoteControlUpdate(mode);
		}

		else
		{
			DIA_TR_INF("##### FAILED TO SET REQUESTED REMOTE CONTROL MODE #####");
		}
	}
	break;

	default:
	{
		// unknown opcode: just delete message
		DIA_TR_INF("vHandleRemoteControlMessage --> AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED (0x%02x) !!", poMessage->u8GetOpCode());
		// create and send error  message
		amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED);
		m_poGWMain->enPostMessage(&oErrorMessage);
	}
	break;
	}

	(tVoid) poMessage->bDelete();
}

tVoid
dia_RemoteControlPluginHMI::vNotifyAllClients(fi_tclTypeBase const& oFIData, tU16 u16FuncId)
{
	DIA_TR_INF(("--> dia_RemoteControlPluginHMI::vNotifyAllClients"));

	//potclService->vUpdateAllClients(oFIData, u16FuncId);

	if (m_poGWMain && m_poGWMain->m_poNotTable)
	{
		ahl_bEnterCritical(diagnostics_tclApp::m_hNotTableSem);

		m_poGWMain->m_poNotTable->vTraceTable(TR_CLASS_DIAGNOSTICS_BASE);

		// Run through the table to find all registered clients
		ahl_tNotification* pNot = m_poGWMain->m_poNotTable->poGetNotificationList(u16FuncId);

		DIA_TR_INF("--> dia_RemoteControlPluginHMI::vNotifyAllClients pNot %p",pNot);

		for (; pNot != OSAL_NULL; pNot = pNot->pNext)
		{
			// construct result message
			fi_tclVisitorMessage oResultMsg(oFIData);
			// initialise result message
			oResultMsg.vInitServiceData(DIA_USED_APP_ID, // source
					pNot->u16AppID, // Target
					AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
					0, // StreamCounter
					pNot->u16RegisterID, // RegisterID
					pNot->u16CmdCounter, // nCmdCounter,
					DIA_USED_SRV_ID, // nServiceID,
					u16FuncId, // function ID
					AMT_C_U8_CCAMSG_OPCODE_STATUS, AMT_C_U16_DEFAULT_NULL, pNot->u16SubID);


			// send it
			//vTraceSimple(I_DIA_HMI_UPDATEALLCLIENTS_03);
			if (m_poGWMain->enPostMessage(&oResultMsg) != AIL_EN_N_NO_ERROR) {
				(tVoid) oResultMsg.bDelete();
			}
		}
		ahl_bReleaseCritical(diagnostics_tclApp::m_hNotTableSem);
	}
	else
	{
		DIA_TR_INF(("!!! dia_RemoteControlPluginHMI::vNotifyAllClients => ERROR: Null pointer - m_poGWMain or m_poNotTable"));
	}
	DIA_TR_INF(("<-- dia_RemoteControlPluginHMI::vNotifyAllClients"));
}


bool
dia_RemoteControlPluginHMI::bUpreg(amt_tclServiceData const* poMessage)
{
	dia_tclFnctTrace trc("dia_RemoteControlPluginHMI::bUpreg");

	if ( (!m_poGWMain) || (!(m_poGWMain->m_poNotTable)) || (!poMessage) ) return false;

	tBool bRegOpStatus = FALSE;

	if(poMessage->u16GetFunctionID())
	{
		ahl_bEnterCritical(diagnostics_tclApp::m_hNotTableSem);

		// Add the client to notification table
		bRegOpStatus = m_poGWMain->m_poNotTable->bAddNotification (
				poMessage->u16GetFunctionID(),
				poMessage->u16GetSourceAppID(),
				poMessage->u16GetRegisterID(),
				1,
				poMessage->u16GetCmdCounter(),
				poMessage->u16GetSourceSubID());

		ahl_bReleaseCritical(diagnostics_tclApp::m_hNotTableSem);
	}

	return (bRegOpStatus == TRUE) ? true : false;
}

///////////////////////////////////////////////////////////////////////////
//
// FUNCTION:   dia_RemoteControlPluginHMI::bRelUpreg
//
// DESCRIPTION:   Removes the sender of the message from the NotifcationTable
//
// PARAMETER:  Relupreg request message
//
// RETURNVALUE:   true  : Client dereqistration successful
//                false : Client deregistration failed
//
///////////////////////////////////////////////////////////////////////////
//
bool
dia_RemoteControlPluginHMI::bRelUpreg(amt_tclServiceData const* poMessage)
{
	//   vTraceSimple(I_DIA_HMI_RELUPREG_01);

	if ( (!m_poGWMain) || (!(m_poGWMain->m_poNotTable)) || (!poMessage) ) return false;

	tBool bRegOpStatus = FALSE;

	if ( (MIDW_DIAGNOSTICSFI_C_U16_REMOTECONTROL == poMessage->u16GetFunctionID()) )
	{
		ahl_bEnterCritical(diagnostics_tclApp::m_hNotTableSem);

		// Delete the client from notification table
		bRegOpStatus = m_poGWMain->m_poNotTable->bRemoveNotification (
				poMessage->u16GetFunctionID(),
				poMessage->u16GetSourceAppID(),
				poMessage->u16GetRegisterID(),
				1,
				poMessage->u16GetCmdCounter(),
				poMessage->u16GetSourceSubID()
		);

		ahl_bReleaseCritical(diagnostics_tclApp::m_hNotTableSem);
	}

	return (bRegOpStatus == TRUE) ? true : false;
}

///////////////////////////////////////////////////////////////////////////
//  FUNCTION:    dia_RemoteControlPluginHMI::vSendStatusMsg
//
//  DESCRIPTION: sends a CCA Status message
//
//  PARAMETER:   poMessage - incoming request
//                oFIData - property data
//
//  RETURNVALUE: NONE
///////////////////////////////////////////////////////////////////////////
//

tVoid
dia_RemoteControlPluginHMI::vSendStatusMsg(amt_tclServiceData const* poMessage, fi_tclTypeBase const& oFIData) const
{
	// Check the validity of incoming data
	if (NULL == poMessage)
	{
		return;
	}
	// initialise result message
	vSendMsg(poMessage, oFIData, AMT_C_U8_CCAMSG_OPCODE_STATUS);
}

///////////////////////////////////////////////////////////////////////////
//  FUNCTION:    dia_RemoteControlPluginHMI::vSendMsg
//
//  DESCRIPTION: sends a CCA message
//
//  PARAMETER:   poMessage - incoming request
//                oFIData - property data
//                u8OpCode - CCA op code
//
//  RETURNVALUE: NONE
///////////////////////////////////////////////////////////////////////////
//
tVoid
dia_RemoteControlPluginHMI::vSendMsg(amt_tclServiceData const* poMessage, fi_tclTypeBase const& oFIData, tU8 u8OpCode) const
{
	// Check the validity of incoming data
	if (NULL == poMessage)
	{
		return;
	}
	// construct result message
	fi_tclVisitorMessage oResultMsg(oFIData);
	// initialise result message
	oResultMsg.vInitServiceData(DIA_USED_APP_ID, // source
			poMessage->u16GetSourceAppID(), // Target
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
			0, // StreamCounter
			poMessage->u16GetRegisterID(), // RegisterID
			poMessage->u16GetCmdCounter(), // nCmdCounter,
			DIA_USED_SRV_ID, // nServiceID,
			poMessage->u16GetFunctionID(), // function ID
			u8OpCode, AMT_C_U16_DEFAULT_NULL, poMessage->u16GetSourceSubID());
	// send it
	if (NULL != m_poGWMain) {
		if (m_poGWMain->enPostMessage(&oResultMsg) != AIL_EN_N_NO_ERROR)
		{
			(tVoid) oResultMsg.bDelete();
		}
	}
}

