/*
 * dia_RemoteControlPluginAudio.h
 *
 *  Created on: 08.05.2014
 *      Author: shw2abt
 */

#ifndef __INCLUDED_DIA_REMOTE_CONTROL_PLUGIN_AUDIO__
#define __INCLUDED_DIA_REMOTE_CONTROL_PLUGIN_AUDIO__

#include <org/genivi/audiomanager/CommandInterfaceProxy.h>
#include <org/genivi/audiomanager/CommandInterfaceClientBase.h>

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterFeatureASF.h>
#endif

#ifndef __INCLUDED_DIA_REMOTE_CONTROL_PLUGIN__
#include "common/framework/application/dia_RemoteControlPlugin.h"
#endif

using namespace org::genivi::audiomanager::CommandInterface;

//-----------------------------------------------------------------------------

class dia_RemoteControlPluginAudio
   : public dia_SystemAdapterFeatureASF<CommandInterfaceProxy>,
     public CommandInterfaceClientBase,
     public dia_RemoteControlPlugin
{
      DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_RemoteControlPluginAudio);

public:
   //! class constructor
   dia_RemoteControlPluginAudio ( tCString name, dia_SystemAdapterServicePluginASF<CommandInterfaceProxy>& pSrvPlugin );

   //! class destructor
   virtual ~dia_RemoteControlPluginAudio ( void );

   //! start monitoring of properties
   virtual tDiaResult startMonitoring();
   //! stop monitoring of properties
   virtual tDiaResult stopMonitoring();

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_RemoteControlPlugin methods
   //
   //-------------------------------------------------------------------------

   //! set remote control to the specified mode
   virtual tDiaResult requestRemoteControlMode ( dia_eRemoteCtrlMode mode, dia_RemoteControlSettings settings = DIA_C_U32_REMOTE_CTRL_SETTINGS_DEFAULT );

   //-------------------------------------------------------------------------
   //
   // Overloaded CommandInterfaceClientBase methods
   //
   //-------------------------------------------------------------------------

   //! receive result from Audio via ASF
   virtual void onSetSystemPropertyResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SetSystemPropertyResponse >& response);
   virtual void onSetSystemPropertyError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SetSystemPropertyError >& error);

   //! signal indication from SystemPropertyChangedCallbackIF
   virtual void onSystemPropertyChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SystemPropertyChangedError >& error);
   virtual void onSystemPropertyChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< SystemPropertyChangedSignal >& signal);

   //! update the remote control mode of this plugin
   virtual void vOnRemoteControlUpdateAudio ( dia_eRemoteCtrlMode activeMode ) { vOnRemoteControlUpdate(activeMode); }

protected:
   //! Acknowledgement from ASF for SystemPropertyChanged signal
   act_t mSystemPropertyChangeAct;
};

#endif /* __INCLUDED_DIA_REMOTE_CONTROL_PLUGIN_AUDIO__ */
