/*!
 * \file       dia_security.h
 *
 * \brief      Defines common enumerations and types for the security framework
 *
 * \details    Defines common enumerations and types for the security framework
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreSecurity
 *
 * \copyright  (c) 2014-2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_SECURITY__
#define __INCLUDED_DIA_SECURITY__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

// Names of Security Level
#define DIA_NAME_SECURITY_LEVEL_UNKNOWN                        "DIA_SECURITY_LEVEL_UNKNOWN"
#define DIA_NAME_SECURITY_LEVEL_NOT_ACTIVE                     "DIA_SECURITY_LEVEL_NOT_ACTIVE"
#define DIA_NAME_SECURITY_LEVEL_ALD                            "DIA_SECURITY_LEVEL_ALD"
#define DIA_NAME_SECURITY_LEVEL_BOSCH                          "DIA_SECURITY_LEVEL_BOSCH"
#define DIA_NAME_SECURITY_LEVEL_UNIT_TEST                      "DIA_SECURITY_LEVEL_UNIT_TEST"
#define DIA_NAME_SECURITY_LEVEL_PROJECT_01                     "DIA_SECURITY_LEVEL_PROJECT_01"
#define DIA_NAME_SECURITY_LEVEL_PROJECT_02                     "DIA_SECURITY_LEVEL_PROJECT_02"
#define DIA_NAME_SECURITY_LEVEL_PROJECT_03                     "DIA_SECURITY_LEVEL_PROJECT_03"
#define DIA_NAME_SECURITY_LEVEL_PROJECT_04                     "DIA_SECURITY_LEVEL_PROJECT_04"
#define DIA_NAME_SECURITY_LEVEL_PROJECT_05                     "DIA_SECURITY_LEVEL_PROJECT_05"
#define DIA_NAME_SECURITY_LEVEL_PROJECT_06                     "DIA_SECURITY_LEVEL_PROJECT_06"
#define DIA_NAME_SECURITY_LEVEL_PROJECT_07                     "DIA_SECURITY_LEVEL_PROJECT_07"
#define DIA_NAME_SECURITY_LEVEL_PROJECT_08                     "DIA_SECURITY_LEVEL_PROJECT_08"
#define DIA_NAME_SECURITY_LEVEL_PROJECT_09                     "DIA_SECURITY_LEVEL_PROJECT_09"
#define DIA_NAME_SECURITY_LEVEL_PROJECT_10                     "DIA_SECURITY_LEVEL_PROJECT_10"

// UIDs of Security Levels
#define DIA_UID_SECURITY_LEVEL_UNKNOWN                         ((dia_UID)  0x01BCB090) // DIA_NAME_SECURITY_LEVEL_UNKNOWN
#define DIA_UID_SECURITY_LEVEL_NOT_ACTIVE                      ((dia_UID)  0x7A210DAC) // DIA_NAME_SECURITY_LEVEL_NOT_ACTIVE
#define DIA_UID_SECURITY_LEVEL_ALD                             ((dia_UID)  0xD605B311) // DIA_NAME_SECURITY_LEVEL_ALD
#define DIA_UID_SECURITY_LEVEL_BOSCH                           ((dia_UID)  0x6E52C1AF) // DIA_NAME_SECURITY_LEVEL_BOSCH
#define DIA_UID_SECURITY_LEVEL_UNIT_TEST                       ((dia_UID)  0xD8D5567F) // DIA_NAME_SECURITY_LEVEL_UNIT_TEST
#define DIA_UID_SECURITY_LEVEL_PROJECT_01                      ((dia_UID)  0xFB3059D7) // DIA_NAME_SECURITY_LEVEL_PROJECT_01
#define DIA_UID_SECURITY_LEVEL_PROJECT_02                      ((dia_UID)  0xFB3059D8) // DIA_NAME_SECURITY_LEVEL_PROJECT_02
#define DIA_UID_SECURITY_LEVEL_PROJECT_03                      ((dia_UID)  0xFB3059D9) // DIA_NAME_SECURITY_LEVEL_PROJECT_03
#define DIA_UID_SECURITY_LEVEL_PROJECT_04                      ((dia_UID)  0xFB3059DA) // DIA_NAME_SECURITY_LEVEL_PROJECT_04
#define DIA_UID_SECURITY_LEVEL_PROJECT_05                      ((dia_UID)  0xFB3059DB) // DIA_NAME_SECURITY_LEVEL_PROJECT_05
#define DIA_UID_SECURITY_LEVEL_PROJECT_06                      ((dia_UID)  0xFB3059DC) // DIA_NAME_SECURITY_LEVEL_PROJECT_06
#define DIA_UID_SECURITY_LEVEL_PROJECT_07                      ((dia_UID)  0xFB3059DD) // DIA_NAME_SECURITY_LEVEL_PROJECT_07
#define DIA_UID_SECURITY_LEVEL_PROJECT_08                      ((dia_UID)  0xFB3059DE) // DIA_NAME_SECURITY_LEVEL_PROJECT_08
#define DIA_UID_SECURITY_LEVEL_PROJECT_09                      ((dia_UID)  0xFB3059DF) // DIA_NAME_SECURITY_LEVEL_PROJECT_09
#define DIA_UID_SECURITY_LEVEL_PROJECT_10                      ((dia_UID)  0xFB3059F7) // DIA_NAME_SECURITY_LEVEL_PROJECT_10

// type to be used for lock levels
typedef dia_UID dia_SecurityLevelID;

// UIDs of Security Level (replacements for obsolete enum values) -- ### DO NOT EXTEND THIS LIST ###
#define DIA_EN_SECURITY_LEVEL_UNKNOWN                          ((dia_UID)  0x01BCB090) // DIA_NAME_SECURITY_LEVEL_UNKNOWN
#define DIA_EN_SECURITY_LEVEL_NOT_ACTIVE                       ((dia_UID)  0x7A210DAC) // DIA_NAME_SECURITY_LEVEL_NOT_ACTIVE
#define DIA_EN_SECURITY_LEVEL_ALD                              ((dia_UID)  0xD605B311) // DIA_NAME_SECURITY_LEVEL_ALD
#define DIA_EN_SECURITY_LEVEL_BOSCH                            ((dia_UID)  0x6E52C1AF) // DIA_NAME_SECURITY_LEVEL_BOSCH
#define DIA_EN_SECURITY_LEVEL_UNIT_TEST                        ((dia_UID)  0xD8D5567F) // DIA_NAME_SECURITY_LEVEL_UNIT_TEST
#define DIA_EN_SECURITY_LEVEL_PROJECT_01                       ((dia_UID)  0xFB3059D7) // DIA_NAME_SECURITY_LEVEL_PROJECT_01
#define DIA_EN_SECURITY_LEVEL_PROJECT_02                       ((dia_UID)  0xFB3059D8) // DIA_NAME_SECURITY_LEVEL_PROJECT_02
#define DIA_EN_SECURITY_LEVEL_PROJECT_03                       ((dia_UID)  0xFB3059D9) // DIA_NAME_SECURITY_LEVEL_PROJECT_03
#define DIA_EN_SECURITY_LEVEL_PROJECT_04                       ((dia_UID)  0xFB3059DA) // DIA_NAME_SECURITY_LEVEL_PROJECT_04
#define DIA_EN_SECURITY_LEVEL_PROJECT_05                       ((dia_UID)  0xFB3059DB) // DIA_NAME_SECURITY_LEVEL_PROJECT_05
#define DIA_EN_SECURITY_LEVEL_PROJECT_06                       ((dia_UID)  0xFB3059DC) // DIA_NAME_SECURITY_LEVEL_PROJECT_06
#define DIA_EN_SECURITY_LEVEL_PROJECT_07                       ((dia_UID)  0xFB3059DD) // DIA_NAME_SECURITY_LEVEL_PROJECT_07
#define DIA_EN_SECURITY_LEVEL_PROJECT_08                       ((dia_UID)  0xFB3059DE) // DIA_NAME_SECURITY_LEVEL_PROJECT_08
#define DIA_EN_SECURITY_LEVEL_PROJECT_09                       ((dia_UID)  0xFB3059DF) // DIA_NAME_SECURITY_LEVEL_PROJECT_09
#define DIA_EN_SECURITY_LEVEL_PROJECT_10                       ((dia_UID)  0xFB3059F7) // DIA_NAME_SECURITY_LEVEL_PROJECT_10

// UIDs of predefined lock levels
#define DIA_UID_SECURITY_LOCK_LEVEL_DISABLED                   ((dia_UID)  0x8B8014A0) // "DIA_SECURITY_LOCK_LEVEL_DISABLED"
#define DIA_UID_SECURITY_LOCK_LEVEL_LOCKED                     ((dia_UID)  0xE955FE9A) // "DIA_SECURITY_LOCK_LEVEL_LOCKED"
#define DIA_UID_SECURITY_LOCK_LEVEL_CUSTOMER                   ((dia_UID)  0x3C580F9A) // "DIA_SECURITY_LOCK_LEVEL_CUSTOMER"
#define DIA_UID_SECURITY_LOCK_LEVEL_SUPPLIER_PRODUCTION        ((dia_UID)  0xCFC1E063) // "DIA_SECURITY_LOCK_LEVEL_SUPPLIER_PRODUCTION"
#define DIA_UID_SECURITY_LOCK_LEVEL_SUPPLIER_DEVELOPMENT       ((dia_UID)  0xE1D7FB1E) // "DIA_SECURITY_LOCK_LEVEL_SUPPLIER_DEVELOPMENT"

// type to be used for lock levels
typedef dia_UID dia_SecurityLockLevelID;

enum dia_eSecurityLevelStatus
{
   DIA_EN_SECURITY_LEVEL_STATUS_UNKNOWN = 0,
   DIA_EN_SECURITY_LEVEL_STATUS_NOT_ACTIVE,
   DIA_EN_SECURITY_LEVEL_STATUS_ACTIVE,
   DIA_EN_SECURITY_LEVEL_STATUS_COUNT
};

#define DIA_C_U32_SECURITY_LEVEL_MASK_COMMON       ((tU32) 0xFFFF0000)
#define DIA_C_U32_SECURITY_LEVEL_MASK_PROJECT      ((tU32) 0x0000FFFF)

// common diagnostic security level bitmask
#define DIA_U32_BITMASK_SECURITY_LEVEL_UNKNOWN         ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_COMMON  & 0x00000000))

//! place holder for common diagnostic security level bitmask
#define DIA_U32_BITMASK_SECURITY_LEVEL_COMMON_01       ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_COMMON  & 0x00010000))
#define DIA_U32_BITMASK_SECURITY_LEVEL_COMMON_02       ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_COMMON  & 0x00020000))
#define DIA_U32_BITMASK_SECURITY_LEVEL_COMMON_03       ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_COMMON  & 0x00040000))
#define DIA_U32_BITMASK_SECURITY_LEVEL_COMMON_04       ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_COMMON  & 0x00080000))
#define DIA_U32_BITMASK_SECURITY_LEVEL_COMMON_05       ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_COMMON  & 0x00100000))
#define DIA_U32_BITMASK_SECURITY_LEVEL_COMMON_06       ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_COMMON  & 0x00200000))
#define DIA_U32_BITMASK_SECURITY_LEVEL_COMMON_07       ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_COMMON  & 0x00400000))
#define DIA_U32_BITMASK_SECURITY_LEVEL_COMMON_08       ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_COMMON  & 0x00800000))
#define DIA_U32_BITMASK_SECURITY_LEVEL_COMMON_09       ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_COMMON  & 0x01000000))
#define DIA_U32_BITMASK_SECURITY_LEVEL_COMMON_10       ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_COMMON  & 0x02000000))
#define DIA_U32_BITMASK_SECURITY_LEVEL_COMMON_11       ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_COMMON  & 0x04000000))
#define DIA_U32_BITMASK_SECURITY_LEVEL_COMMON_12       ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_COMMON  & 0x08000000))
#define DIA_U32_BITMASK_SECURITY_LEVEL_COMMON_13       ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_COMMON  & 0x10000000))
#define DIA_U32_BITMASK_SECURITY_LEVEL_COMMON_14       ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_COMMON  & 0x20000000))
#define DIA_U32_BITMASK_SECURITY_LEVEL_COMMON_15       ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_COMMON  & 0x40000000))
#define DIA_U32_BITMASK_SECURITY_LEVEL_COMMON_16       ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_COMMON  & 0x80000000))

#define DIA_U32_BITMASK_SECURITY_LEVEL_ALD             DIA_U32_BITMASK_SECURITY_LEVEL_COMMON_01
#define DIA_U32_BITMASK_SECURITY_LEVEL_MAUSKEY         DIA_U32_BITMASK_SECURITY_LEVEL_COMMON_02
#define DIA_U32_BITMASK_SECURITY_LEVEL_UNIT_TEST       DIA_U32_BITMASK_SECURITY_LEVEL_COMMON_16 // left most level bit

//! place holder for project specific diagnostic security level bitmask
#define DIA_U32_BITMASK_SECURITY_LEVEL_PROJECT_01      ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_PROJECT & 0x00000001))
#define DIA_U32_BITMASK_SECURITY_LEVEL_PROJECT_02      ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_PROJECT & 0x00000002))
#define DIA_U32_BITMASK_SECURITY_LEVEL_PROJECT_03      ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_PROJECT & 0x00000004))
#define DIA_U32_BITMASK_SECURITY_LEVEL_PROJECT_04      ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_PROJECT & 0x00000008))
#define DIA_U32_BITMASK_SECURITY_LEVEL_PROJECT_05      ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_PROJECT & 0x00000010))
#define DIA_U32_BITMASK_SECURITY_LEVEL_PROJECT_06      ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_PROJECT & 0x00000020))
#define DIA_U32_BITMASK_SECURITY_LEVEL_PROJECT_07      ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_PROJECT & 0x00000040))
#define DIA_U32_BITMASK_SECURITY_LEVEL_PROJECT_08      ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_PROJECT & 0x00000080))
#define DIA_U32_BITMASK_SECURITY_LEVEL_PROJECT_09      ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_PROJECT & 0x00000100))
#define DIA_U32_BITMASK_SECURITY_LEVEL_PROJECT_10      ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_PROJECT & 0x00000200))
#define DIA_U32_BITMASK_SECURITY_LEVEL_PROJECT_11      ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_PROJECT & 0x00000400))
#define DIA_U32_BITMASK_SECURITY_LEVEL_PROJECT_12      ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_PROJECT & 0x00000800))
#define DIA_U32_BITMASK_SECURITY_LEVEL_PROJECT_13      ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_PROJECT & 0x00001000))
#define DIA_U32_BITMASK_SECURITY_LEVEL_PROJECT_14      ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_PROJECT & 0x00002000))
#define DIA_U32_BITMASK_SECURITY_LEVEL_PROJECT_15      ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_PROJECT & 0x00004000))
#define DIA_U32_BITMASK_SECURITY_LEVEL_PROJECT_16      ((tU32) (DIA_C_U32_SECURITY_LEVEL_MASK_PROJECT & 0x00008000))

#endif /* __INCLUDED_DIA_SECURITY__ */

/**
 *
 * \defgroup diaCoreSecurity                 Security
 * \ingroup  diaCore
 * \image html dia_SecurityLevelFSM.jpg
 *
 *
 */
