/*
 * dia_SecurityModule.h
 *
 *  Created on: 30.08.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_SECURITY_MODULE__
#define __INCLUDED_DIA_SECURITY_MODULE__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SECURITY__
#include "common/framework/security/dia_security.h"
#endif

class dia_SecurityModule
   : public dia_ObjectWithUID
{
public:
   //! (deprecated) default class constructor
   virtual ~dia_SecurityModule ( void );
   //!
   //! lock the security module
   virtual tDiaResult lockAccess ( dia_SecurityLockLevelID lockLevelID = DIA_UID_SECURITY_LOCK_LEVEL_LOCKED ) = 0; //lint !e1735 Info: verified that subclasses use same default parameter
   //! lock the security module
   virtual tDiaResult unlockAccess ( void ) = 0;
   //! return the locking state
   virtual bool isAccessLocked ( void ) const { return mIsAccessLocked; }

protected:
   //! (deprecated) default class constructor without implementation
   dia_SecurityModule ( void );
   //! class constructor to be used by subclasses
   dia_SecurityModule ( tCString name );

protected:
   //! locking status
   bool mIsAccessLocked;
};

#endif /* __INCLUDED_DIA_SECURITY_MODULE__ */
