/*
 * dia_SecurityLevelConfiguration.h
 *
 * \copyright  (c) 2015 Robert Bosch Car Multimedia
 */

#ifndef __INCLUDED_DIA_SECURITY_LEVEL_CONFIGURATION__
#define __INCLUDED_DIA_SECURITY_LEVEL_CONFIGURATION__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SECURITY__
#include <common/framework/security/dia_security.h>
#endif

// as default we don't lock
#define DIA_C_U16_SECURITY_DEFAULT_VALUE_LOGIN_MAX_ATTEMPTS    ((tU16) 0xFFFF)
#define DIA_C_U16_SECURITY_DEFAULT_VALUE_LOGIN_LOCK_TIME       ((tU16) 0x0000)

class dia_SecurityLevelConfiguration
{
   friend class dia_SecurityLevel;

public:
   //! default class constructor
   dia_SecurityLevelConfiguration ( void );
   //! class destructor
   virtual ~dia_SecurityLevelConfiguration ( void ) {}

   //! set/get UDS id used for seed request
   void setAccessTypeSeed ( tU16 id ) { mAccessTypeSeed = id; }
   tU16 getAccessTypeSeed ( void ) const { return mAccessTypeSeed; }

   //! set/get UDS id used for key request
   void setAccessTypeKey ( tU16 id ) { mAccessTypeKey = id; }
   tU16 getAccessTypeKey ( void ) const { return mAccessTypeKey; }

   //! add the access types of the given security level to the access types vector
   virtual tDiaResult getAccessTypes ( std::vector<tU16>& accessTypesVec ) const;

   //! set/get security level bitmask value to be used in security level bitmask on application processor
   void setSecurityLevelBitmask ( tU32 securityBitmask ) { mSecurityLevelBitmask = securityBitmask; }
   tU32 getSecurityLevelBitmask ( void ) const { return mSecurityLevelBitmask; }

   //! set/get security level bitmask value to be used in security level bitmask on SCC processor
   void setSecurityLevelBitmaskSCC ( tU32 securityBitmask ) { mSecurityLevelBitmaskSCC = securityBitmask; }
   tU32 getSecurityLevelBitmaskSCC ( void ) const { return mSecurityLevelBitmaskSCC; }

   //! set/get the maximum number of login attempts before the device is getting locked
   void setMaxNumberOfLogins ( tU16 maxAttempts ) { mMaxLoginAttempts = maxAttempts; }
   tU16 getMaxNumberOfLogins ( void ) const { return mMaxLoginAttempts; }

   //! set/get the time the system is getting locked before the user can retry to login
   void setLoginLockTime ( tU16 lockTime ) { mLoginLockTime = lockTime; }
   tU16 getLoginLockTime ( void ) const { return mLoginLockTime; }

   void setSeedSize ( tU16 numOfBytes ) { mSeedSize = numOfBytes; }
   tU16 getSeedSize ( void ) const { return mSeedSize; }

   void setKeySize ( tU16 numOfBytes ) { mKeySize = numOfBytes; }
   tU16 getKeySize ( void ) const { return mKeySize; }

   void setSimulationMode ( bool mode ) { mSimulationModeEnabled = mode; }
   bool getSimulationMode ( void ) const { return mSimulationModeEnabled; }

protected:
   //! associated UDS DID for seed handling
   tU16 mAccessTypeSeed;
   //! associated UDS DID for key handling
   tU16 mAccessTypeKey;
   //! security level bitmask value to be used on application processor
   tU32 mSecurityLevelBitmask;
   //! security level bitmask value to be used on SCC processor
   tU32 mSecurityLevelBitmaskSCC;
   //! maximum number of attempts to access the security level
   tU16 mMaxLoginAttempts;
   //! locking time of the security access in case of too many invalid attempts
   tU16 mLoginLockTime;
   //! size of the seed in bytes
   tU16 mSeedSize;
   //! size of the key in bytes
   tU16 mKeySize;
   //! enable simulation mode (disabled per default)
   bool mSimulationModeEnabled;
};

#endif /* __INCLUDED_DIA_SECURITY_LEVEL_CONFIGURATION__ */
