/*
 * dia_SecurityLevelConfiguration.cpp
 *
 * \copyright  (c) 2015 Robert Bosch Car Multimedia
 */

#ifndef __INCLUDED_DIA_SECURITY_LEVEL_CONFIGURATION__
#include <common/framework/security/dia_SecurityLevelConfiguration.h>
#endif

const tU16 DIA_C_U16_DEFAULT_SECURITY_LEVEL_SEED_SIZE = 64;
const tU16 DIA_C_U16_DEFAULT_SECURITY_LEVEL_KEY_SIZE  = 64;

//-----------------------------------------------------------------------------

dia_SecurityLevelConfiguration::dia_SecurityLevelConfiguration ( void )
   : mAccessTypeSeed(0),
     mAccessTypeKey(0),
     mSecurityLevelBitmask(0),
     mSecurityLevelBitmaskSCC(0),
     mMaxLoginAttempts(DIA_C_U16_SECURITY_DEFAULT_VALUE_LOGIN_MAX_ATTEMPTS),
     mLoginLockTime(DIA_C_U16_SECURITY_DEFAULT_VALUE_LOGIN_LOCK_TIME),
     mSeedSize(DIA_C_U16_DEFAULT_SECURITY_LEVEL_SEED_SIZE),
     mKeySize(DIA_C_U16_DEFAULT_SECURITY_LEVEL_KEY_SIZE),
	 mSimulationModeEnabled(false)
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SecurityLevelConfiguration::getAccessTypes ( std::vector<tU16>& accessTypesVec ) const
{
   if ( mAccessTypeSeed ) accessTypesVec.push_back(mAccessTypeSeed);
   if ( mAccessTypeKey  ) accessTypesVec.push_back(mAccessTypeKey);
   return DIA_SUCCESS;
}

