/**
 * \file    dia_SecurityLevelBosch.h
 *
 * \brief   Class dia_SecurityLevelBosch provides a seed/key based method using
 *          the MAUS protocol. A random seed is returned to the tester. The tester
 *          forwards the seed to the MAUS key server for encryption and retrieves
 *          the corresponding key. The key is send to the ECU. The ECU encrypts the
 *          stored seed and compares the result with the received key. If the values
 *          are matching access for the security level is granted to the tester.
 *
 * \author  gib2hi
 * \date    2012/08/10
 */

#ifndef __INCLUDED_DIA_SECURITY_LEVEL_BOSCH__
#define __INCLUDED_DIA_SECURITY_LEVEL_BOSCH__

#ifndef __INCLUDED_DIA_SECURITY_LEVEL__
#include <common/framework/security/dia_SecurityLevel.h>
#endif

class dia_SecurityLevelBosch
   : public dia_SecurityLevel
{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SecurityLevelBosch);

public:
   //! class constructor
   dia_SecurityLevelBosch ( dia_SecurityLevelConfiguration& config );
   //! class destructor
   virtual ~dia_SecurityLevelBosch ( void );

   //! method used to retrieve the seed value
   virtual tDiaResult getSeed ( void /*std::vector<tU8>& seedValue*/ );
   //! method used to deliver a key
   virtual tDiaResult acceptKey ( std::vector<tU8>& keyValue );

//   //! return the access types for this security level
//   virtual tDiaResult getAccessTypes ( std::vector<tU8>& accessTypes );

protected:
   //! load the configuration
   virtual tDiaResult loadConfiguration ( void );
   //! load the configuration
   virtual tDiaResult storeConfiguration ( void );
   //! generate the seed
   virtual void generateSeed ( void );
   //! method used to randomize the seed
   virtual tU32 randomizeSeed ( tU16 data ) const;
   //! method used to scramble the seed
   virtual tU16 scrambleGeneratedSeed ( tU16 data ) const;

   virtual tDiaResult checkKey ( std::vector<tU8>& keyValue );

   //! load the lock status of the security level
   virtual void loadLockStatus ( void );
   virtual tDiaResult saveLockStatus ( dia_UID uid ) const;

   //
   // FSM methods
   //
   virtual void vFsmCopyKeyCtrlFromNvm ( void* pArg );
   virtual void vFsmEvaluateOperationMode ( void* /*pArg*/ );
   virtual void vFsmSaveKeyCtrlToNvm ( void* pArg );
   virtual void vFsmCalculateSeed ( void* pArg );
   virtual void vFsmSendSeed ( void* pArg );
   virtual void vFsmSendSeedWhenActive ( void* pArg );
   virtual bool isKeyInvalid ( void* pArg );
   virtual void vFsmValidateKey ( void* /*pArg*/ );

protected:
   //! key identifier
   tU16 mKeyID;
   //! flag used to indicate if the passed key matches or not
   bool mIsPassedKeyValid;

   // some constants
   static const tU8  cu8SeedLength = 8;
   static const tU8  cu8ByteSize   = 8;
   static const tU32 cu32ByteMask  = 0xFFFFFFFF;
};

#endif /* __INCLUDED_DIA_SECURITY_LEVEL_BOSCH__ */
