/*
 * dia_RoutineCtrlTimer.h
 *
 *  Created on: 15.06.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_TIMER__
#define __INCLUDED_DIA_ROUTINE_CONTROL_TIMER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrl.h"
#endif

#define DIA_C_U32_UDS_RTCTRL_TIMER_DEFAULT_TIMEOUT    ((tU32) 1000) // timeout value in milliseconds
#define DIA_C_U32_UDS_RTCTRL_TIMER_DEFAULT_CYCLETIME  ((tU32) 1000) // timeout value in milliseconds

using namespace std;

class dia_RoutineCtrlTimerClient;

////////////////////////////////////////////////////////////////////////////////
//
//
//
////////////////////////////////////////////////////////////////////////////////

class dia_RoutineCtrlTimer
#ifndef __DIA_UNIT_TESTING__
   : protected OSAL_tclTimer
#endif
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_RoutineCtrlTimer);

public:
   //! start the timer
   tBool start (
         tU32 timeoutValue = DIA_C_U32_UDS_RTCTRL_TIMER_DEFAULT_TIMEOUT,
         tU32 cycleValue   = DIA_C_U32_UDS_RTCTRL_TIMER_DEFAULT_CYCLETIME
         );

   //! stop the timer
   tBool stop ( void );
   //! check if the timer is running
   tBool bIsRunning ( void ) const;

   //! add a timer client
   virtual tDiaResult addTimerClient ( dia_RoutineCtrlTimerClient* pClient );
   //! remove a timer client
   virtual tDiaResult removeTimerClient ( dia_RoutineCtrlTimerClient* pClient );

   //! internal callback function called by the OSAL timer
   virtual void vOnAlarm ( void );

#ifdef __DIA_UNIT_TESTING__
   virtual tS32 s32Delete ( void ) { return OSAL_OK; }
   virtual tS32 s32Create ( void ) { return OSAL_OK; }
   virtual tS32 s32SetTime(OSAL_tMSecond /*msec*/, OSAL_tMSecond /*interval*/) { return 0; }
#endif

protected:
   //! default constructor
   dia_RoutineCtrlTimer ( void );
   //! class destructor
   virtual ~dia_RoutineCtrlTimer ( void );

   //! setup (create objects,...)
   tDiaResult setup ( void );
   //! tear down (destroy objects,...)
   tDiaResult tearDown ( void );

protected:
   //! flag to indicate if the timer was already set up
   bool mIsSetup;
   //! flag to indicate if the timer is active or not
   bool mbIsActive;
   //! list of timer clients
   std::list<dia_RoutineCtrlTimerClient*> mClientRep;
};

///////////////////////////////////////////////////////////////////////////////
//
// Factory Methods
//
///////////////////////////////////////////////////////////////////////////////

//! Factory method for creating the singleton timer object
dia_RoutineCtrlTimer* getInstanceOfRoutineCtrlTimer ( void );
//! Factory method for destroying the singleton factory object
void releaseInstanceOfRoutineCtrlTimer ( void );

#endif /* __INCLUDED_DIA_ROUTINE_CONTROL_TIMER__ */
