/*
 * dia_RoutineCtrl.h
 *
 *  Created on: 28.06.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL__
#define __INCLUDED_DIA_ROUTINE_CONTROL__

////////////////////////////////////////////////////////////////////////////////
//
// Defines
//
////////////////////////////////////////////////////////////////////////////////

#define DIA_C_U8_UDS_RTCTRL_ROUTINE_START          (( tU8) 0x01)
#define DIA_C_U8_UDS_RTCTRL_ROUTINE_STOP           (( tU8) 0x02)
#define DIA_C_U8_UDS_RTCTRL_ROUTINE_RESULT         (( tU8) 0x03)

#define DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE   (( tU8) 0xFF)
#define DIA_C_U16_RTCTRL_TIMER_TIMEOUT_INFINITE    ((tU16) 0xFFFF)

////////////////////////////////////////////////////////////////////////////////
//
// Types
//
////////////////////////////////////////////////////////////////////////////////

// Enum that specifies the type of routine

enum dia_eRoutineType
{
   DIA_EN_RTCTRL_TYPE_UNKNOWN = 0,
   DIA_EN_RTCTRL_TYPE_SHORT_TERM,
   DIA_EN_RTCTRL_TYPE_LONG_TERM,
   DIA_EN_RTCTRL_TYPE_COUNT
};

// Enum of unique identifiers for concrete routines

enum dia_eRoutineID
{
   DIA_EN_RTCTRL_ID_UNKNOWN = 0,
   DIA_EN_RTCTRL_ID_SELFTEST_DIAGNOSIS,
   DIA_EN_RTCTRL_ID_RESET_CONFIGURATION,
   DIA_EN_RTCTRL_ID_ALIGNMENT_TOUCHPANEL,
   DIA_EN_RTCTRL_ID_IPOD_SELFTEST,
   DIA_EN_RTCTRL_ID_START_DOWNLOAD,
   DIA_EN_RTCTRL_ID_RESET_SYSTEM_RESET_INFORMATION,
   DIA_EN_RTCTRL_ID_RESET_TO_DELIVERY,
   DIA_EN_RTCTRL_ID_RESET_TO_DELIVERY_CUSTOMER,
   DIA_EN_RTCTRL_ID_START_CD_DRIVE_SELFTEST,
   DIA_EN_RTCTRL_ID_START_SW_UPDATE_OF_SUB_MODULE,
   DIA_EN_RTCTRL_ID_SYSTEM_OPERATION_TIME_RESET,
   DIA_EN_RTCTRL_ID_BT_PAIRED_DEVICE_DELETE,
   DIA_EN_RTCTRL_ID_CALC_CM_CONFIG_FINGERPRINT,
   DIA_EN_RTCTRL_ID_CALC_CUSTOMER_DEFAULT_CONFIG_FINGERPRINT,
   DIA_EN_RTCTRL_ID_CALC_CUSTOMER_CONFIG_FINGERPRINT,
   DIA_EN_RTCTRL_ID_ROUTE_CALCULATION,
   DIA_EN_RTCTRL_ID_PHONE_BT_CONNECTION,
   DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_NOR_RAW,
   DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_V850_APP,
   DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_V850_BOOT,
   DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_EMMC_FFS,
   DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_EMMC_FFS_ROOT,
   DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_EMMC_FFS_STATIC,
   DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_EMMC_FFS_MAP_DATA,
   DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_EMMC_FFS_SDB,
   DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_EMMC_FFS_GRACENOTE,
   DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_EMMC_FASTBOOT,
   DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_EMMC_RAW,
   DIA_EN_RTCTRL_ID_CALC_AND_VERIFY_CHECKSUM_NAVI_RAW,
   DIA_EN_RTCTRL_ID_CLEAR_MCAN_CONNECTION_HISTORY,
   DIA_EN_RTCTRL_ID_DEFAULT_SETTING_ADVANCED_WARNING,
   DIA_EN_RTCTRL_ID_TLIN_SELFTEST,
   DIA_EN_RTCTRL_ID_BLUETOOTH_FIELDSTRENGTH,
   DIA_EN_RTCTRL_ID_GET_WIFI_SNR,
   DIA_EN_RTCTRL_ID_SIMULATE_ITC,
   DIA_EN_RTCTRL_ID_EM_ERASE,
   DIA_EN_RTCTRL_ID_EM_PRINT_TO_TRACE,
   DIA_EN_RTCTRL_ID_GET_PROC_STAT_BY_PROCESSNAME,
   DIA_EN_RTCTRL_ID_GET_PROC_STATM_BY_PROCESSNAME,
   DIA_EN_RTCTRL_ID_ECHO,
   DIA_EN_RTCTRL_ID_TOUCH_SELFTEST,
   DIA_EN_RTCTRL_ID_LOCK_PRODUCTION_DIAGNOSIS,
   DIA_EN_RTCTRL_ID_GYRO_SELFTEST,
   DIA_EN_RTCTRL_ID_ACC_SELFTEST,
   DIA_EN_RTCTRL_ID_GNSS_FIRMWARE,
   DIA_EN_RTCTRL_ID_DIAG_RUN_IN,
   DIA_EN_RTCTRL_ID_DIAG_RUN_IN_CLEAR_RESULTS,
   DIA_EN_RTCTRL_ID_DIAG_STRESS_TEST_1,
   DIA_EN_RTCTRL_ID_DIAG_STRESS_TEST_2,
   DIA_EN_RTCTRL_ID_DIAG_DIAGNOSIS_DISPLAY_SLIDESHOW,
   DIA_EN_RTCTRL_ID_SELF_DIAGNOSIS,

   DIA_EN_RTCTRL_ID_READ_RESET_INFORMATION_FOR_SW_VERSION,
   DIA_EN_RTCTRL_ID_READ_WAKEUP_HISTORY_FOR_SW_VERSION,
   DIA_EN_RTCTRL_ID_READ_RESET_HISTORY_FOR_SW_VERSION,
   DIA_EN_RTCTRL_ID_READ_STATE_HISTORY_FOR_SW_VERSION,
   DIA_EN_RTCTRL_ID_READ_ERROR_STATE_HISTORY_FOR_SW_VERSION,
   DIA_EN_RTCTRL_ID_READ_SYSTEM_OPERATION_TIME_FOR_SW_VERSION,
   DIA_EN_RTCTRL_ID_READ_AVERAGE_CPU_LOAD_FOR_SW_VERSION,
   DIA_EN_RTCTRL_ID_READ_MAXIMUM_RAM_CONSUMPTION_FOR_SW_VERSION,
   DIA_EN_RTCTRL_ID_READ_STARTUP_TIME_STATISTIC_FOR_SW_VERSION,


   DIA_EN_RTCTRL_ID_PROJECT_01,     // may be redefined in project/framework/dia_defsProject.h
   DIA_EN_RTCTRL_ID_PROJECT_02,
   DIA_EN_RTCTRL_ID_PROJECT_03,
   DIA_EN_RTCTRL_ID_PROJECT_04,
   DIA_EN_RTCTRL_ID_PROJECT_05,
   DIA_EN_RTCTRL_ID_PROJECT_06,
   DIA_EN_RTCTRL_ID_PROJECT_07,
   DIA_EN_RTCTRL_ID_PROJECT_08,
   DIA_EN_RTCTRL_ID_PROJECT_09,
   DIA_EN_RTCTRL_ID_PROJECT_10,
   DIA_EN_RTCTRL_ID_PROJECT_11,
   DIA_EN_RTCTRL_ID_PROJECT_12,
   DIA_EN_RTCTRL_ID_PROJECT_13,
   DIA_EN_RTCTRL_ID_PROJECT_14,
   DIA_EN_RTCTRL_ID_PROJECT_15,
   DIA_EN_RTCTRL_ID_PROJECT_16,
   DIA_EN_RTCTRL_ID_PROJECT_17,
   DIA_EN_RTCTRL_ID_PROJECT_18,
   DIA_EN_RTCTRL_ID_PROJECT_19,

   DIA_EN_RTCTRL_ID_UNIT_TEST,

   DIA_EN_RTCTRL_ID_COUNT
};

// Enum that specifies who controls the signal. Either ECU itself or the tester

enum dia_eRoutineStatus
{
   DIA_EN_RTCTRL_STATUS_UNKNOWN = 0,
   DIA_EN_RTCTRL_STATUS_IDLE,
   DIA_EN_RTCTRL_STATUS_IN_PROGRESS,
   DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK,
   DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK,
   DIA_EN_RTCTRL_STATUS_ABORTED,
   DIA_EN_RTCTRL_STATUS_TIMED_OUT,
   DIA_EN_RTCTRL_STATUS_COUNT
};

// Enum that specifies if the remote control mode is controlled by a timer

enum dia_eRoutineCtrlMonitoringMode
{
   DIA_EN_RTCTRL_MONITORING_MODE_UNDEFINED = 0,
   DIA_EN_RTCTRL_MONITORING_MODE_ENABLED,
   DIA_EN_RTCTRL_MONITORING_MODE_DISABLED,
   DIA_EN_RTCTRL_MONITORING_MODE_NOT_SUPPORTED,
   DIA_EN_RTCTRL_NUM_OF_MONITORING_MODES
};

// Enum that specifies the type of routine

enum dia_eRoutineEntryOption
{
   DIA_EN_RTCTRL_ENTRY_OPTION_UNKNOWN = 0,
   DIA_EN_RTCTRL_ENTRY_OPTION_START,
   DIA_EN_RTCTRL_ENTRY_OPTION_STOP,
   DIA_EN_RTCTRL_ENTRY_OPTION_RESULT_GET,
   DIA_EN_RTCTRL_ENTRY_OPTION_COUNT
};

// Enum that specifies the bytes order in RoutineControl message

enum dia_eRoutineMessageIndex
{
   DIA_EN_RTCTRL_INDX_OPTION_BYTE1 = 0,
   DIA_EN_RTCTRL_INDX_OPTION_BYTE2,
   DIA_EN_RTCTRL_INDX_OPTION_BYTE3
};

////////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
////////////////////////////////////////////////////////////////////////////////

class dia_Routine;
class dia_RoutineShortTerm;
class dia_RoutineLongTerm;
class dia_RtCtrlTimer;
class dia_RtCtrlTimerClient;

#endif /* __INCLUDED_DIA_ROUTINE_CONTROL__ */
