/**
 * \file    dia_Routine.h
 *
 * \brief   TBD
 *
 * \author  gib2hi
 * \date    2012/04/11
 */

#ifndef __INCLUDED_DIA_ROUTINE__
#define __INCLUDED_DIA_ROUTINE__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrl.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_TIMER_CLIENT__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrlTimerClient.h"
#endif

#define DIA_C_U32_ROUTINE_CONTROL_MAX_PROCESSING_TIME_DEFAULT     ((tU32) 10000)

////////////////////////////////////////////////////////////////////////////////
//
//
//
////////////////////////////////////////////////////////////////////////////////

class dia_Routine
   : public virtual dia_Object,
     public dia_RoutineCtrlTimerClient
{
public:
   //! class constructor
   dia_Routine (
      tCString name,
      tU16 udsID, // uds subfunction
      dia_eRoutineID ID, // unique internal identifier
      dia_eRoutineType routineType=DIA_EN_RTCTRL_TYPE_SHORT_TERM, // short-term or long-term
      dia_eRoutineCtrlMonitoringMode monitoring=DIA_EN_RTCTRL_MONITORING_MODE_NOT_SUPPORTED
      );

   dia_Routine (
      tCString name,
      tU16 udsID, // uds subfunction
      dia_eRoutineType routineType=DIA_EN_RTCTRL_TYPE_SHORT_TERM, // short-term or long-term
      dia_eRoutineCtrlMonitoringMode monitoring=DIA_EN_RTCTRL_MONITORING_MODE_NOT_SUPPORTED
      );

   dia_Routine (
      const std::string& name,
      tU16 udsID, // uds subfunction
      dia_eRoutineType routineType=DIA_EN_RTCTRL_TYPE_SHORT_TERM, // short-term or long-term
      dia_eRoutineCtrlMonitoringMode monitoring=DIA_EN_RTCTRL_MONITORING_MODE_NOT_SUPPORTED
      );

   //! class destructor
   virtual ~dia_Routine ( void );

   //! retrieve the levels name
   virtual tCString getName ( void ) const;
   //! return the type of the signal
   virtual tU16 getDID ( void ) const;
   //! return the type of the signal
   //virtual dia_eRoutineID eGetID ( void ) const;
   dia_UID getUID ( void ) const;
   //! return the type of the signal
   virtual dia_eRoutineType getType ( void ) const;

   //! return true if the subfunction RequestResult is supported as UDS request
   virtual tBool isSubfunctionRequestResultSupported(void) const { return mType!=DIA_EN_RTCTRL_TYPE_SHORT_TERM; }
   //! return true if the subfunction Stop is supported as UDS request
   virtual tBool isSubfunctionStopSupported(void) const { return mType!=DIA_EN_RTCTRL_TYPE_SHORT_TERM; }

   //! get the status of the IOCtrl signal
   virtual dia_eRoutineStatus getStatus ( void ) const;
   //! set the status of the IOCtrl signal
   virtual void setStatus ( dia_eRoutineStatus newStatus );

   //! return the timer mode for the signal
   virtual dia_eRoutineCtrlMonitoringMode getMonitoringMode ( void ) const;
   //! set the control mode for the signal
   virtual void setMonitoringMode ( dia_eRoutineCtrlMonitoringMode mode, tU8 timerValue = DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE );

   //! retrieve the value of the maximum processing time in ms
   virtual tU32 getMaxProcessingTime ( void ) const { return DIA_C_U32_ROUTINE_CONTROL_MAX_PROCESSING_TIME_DEFAULT; }

   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ) = 0; //lint !e1735 Info: verified that subclasses use same default parameter
   //! stop the specified routine
   virtual tDiaResult stop ( std::vector<tU8>& /*params*/ ) { return DIA_E_ROUTINE_SUBFUNCTION_NOT_SUPPORTED; }
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestResult ( void ) { return DIA_E_ROUTINE_SUBFUNCTION_NOT_SUPPORTED; }
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestResult ( std::vector<tU8>& results ) = 0;

   //! check if the routine specific timer is elapsed
// virtual tBool bIsTimerElapsed ( void ) const;

   //! return the timer value for this routine
   virtual tU8 getUdsTimerValue ( void ) const;

   //! overloaded method called by the timer after a timer tick (resolution 1s)
   virtual tDiaResult onTimerTickRoutineCtrl ( void );

   //! handle the elapsed short term adjustment timer
   virtual void vOnRoutineTimeout ( void );
   //! handle timeout from UDS session object
   virtual void vOnServiceTimeout ( void ) {}

   //! check if the result of the request is available
   virtual tBool bIsResultReady ( void ) const;
   //! check if the result of the request is available
   virtual bool isResultReady ( void ) const { return (mIsResultReady == TRUE) ? true : false; }
   //! check if the result of the request is available
   virtual void setResultReady ( bool mode=true ) { mIsResultReady = (mode) ? TRUE : FALSE; }

   //! set the timer for this signal (specified in seconds
   virtual void vSetTimer ( tU16 seconds );
   //! get the status of the routine control
   dia_eRoutineStatus eGetStatus ( void ) const { return getStatus(); }
   //! set the status of the routine control
   virtual void eSetStatus ( dia_eRoutineStatus newStatus ) { return setStatus(newStatus); }

protected:
   //! deprecated default constructor
   dia_Routine ( void );

   //! initialize the routine before we start processing
   virtual void vInitialize ( void );

   //! Map the routines current mStatus to an UDS result code
   virtual uint8_t mapStatus2UDSResult(void) const;
   //! Map the given status to an UDS result code
   static uint8_t mapStatus2UDSResult(dia_eRoutineStatus Status);

protected:
   //! name of the routine
   tCString mName;
   //! uds identifier
   tU16 mUdsID;
   //! unique internal identifier
   //dia_eRoutineID mID;
   //! unique ioctrl identifier
   dia_UID mUID;
   //! type of the signal
   dia_eRoutineType mType;
   //! status of the signal
   dia_eRoutineStatus mStatus;
   //! specifies if remote control is only used for a short term adjustment
   dia_eRoutineCtrlMonitoringMode mTimerMode;
   //! timer value delivered via the UDS request
   tU8  mTimerValue;
   //! timer counter decremented by the IOCtrlTimer
   tU16 mTimerCounter;
   //! routine results
   std::vector<tU8> mResults;
   //! flag to indicate if we are waiting for a result (e.g. from a component)
   tBool mIsResultReady;
};

#endif /* __INCLUDED_DIA_ROUTINE__ */
