/*
 * dia_IOCtrlTimer.h
 *
 *  Created on: 15.06.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_IOCTRL_TIMER__
#define __INCLUDED_DIA_IOCTRL_TIMER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_LOCK__
#include <common/framework/application/dia_Lock.h>
#endif

#ifndef __INCLUDED_DIA_IOCTRL__
#include <common/framework/protocols/uds/ioctrl/dia_IOCtrl.h>
#endif

#define DIA_C_U32_UDS_IOCTRL_TIMER_DEFAULT_TIMEOUT    ((tU32) 1000) // timeout value in milliseconds
#define DIA_C_U32_UDS_IOCTRL_TIMER_DEFAULT_CYCLETIME  ((tU32) 1000) // timeout value in milliseconds

class dia_IOCtrlTimerClient;

///////////////////////////////////////////////////////////////////////////////
//
//
//
///////////////////////////////////////////////////////////////////////////////

class dia_IOCtrlTimer
#ifndef __DIA_UNIT_TESTING__
   : protected OSAL_tclTimer
#endif
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_IOCtrlTimer);

public:
   //! start the timer
   virtual tDiaResult start ( tU32 timeoutValue, tU32 cycleValue);
   //! stop the timer
   virtual tDiaResult stop ( void );
   //! check if the timer is running
   virtual bool bIsRunning ( void ) const;

   //! add a timer client
   virtual tDiaResult addTimerClient ( dia_IOCtrlTimerClient* pClient );
   //! remove a timer client
   virtual tDiaResult removeTimerClient ( dia_IOCtrlTimerClient* pClient );

   //! internal callback function called by the OSAL timer
   virtual void vOnAlarm ( void );

#ifdef __DIA_UNIT_TESTING__
   virtual tS32 s32Delete ( void ) { return OSAL_OK; }
   virtual tS32 s32Create ( void ) { return OSAL_OK; }
   virtual tS32 s32SetTime(OSAL_tMSecond , OSAL_tMSecond ) { return 0; }
#endif

protected:
   //! default constructor
   dia_IOCtrlTimer ( void );
   //! class destructor
   virtual ~dia_IOCtrlTimer ( void );
   //! setup (create objects,...)
   tDiaResult setup ( void );
   //! tear down (destroy objects,...)
   tDiaResult tearDown ( void );

protected:
   mutable dia::Lock mSyncObj;
   //! flag to indicate if the timer was already set up
   bool mIsSetup;
   //! flag to indicate if the timer is active or not
   bool mIsActive;

   //! list of timer clients
   std::list<dia_IOCtrlTimerClient*> mClientRep;
};

///////////////////////////////////////////////////////////////////////////////
//
// Factory Methods
//
///////////////////////////////////////////////////////////////////////////////

//! Factory method for creating the singleton timer object
dia_IOCtrlTimer* getInstanceOfIOCtrlTimer ( void );
//! Factory method for destroying the singleton factory object
void releaseInstanceOfIOCtrlTimer ( void );

#endif /* __INCLUDED_DIA_IOCTRL_TIMER__ */
