/*
 * dia_IOCtrlTimer.cpp
 *
 *  Created on: 03.07.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_IOCTRL_MANAGER__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlManager.h"
#endif

#ifndef __INCLUDED_DIA_IOCTRL_TIMER__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlTimer.h"
#endif

#ifndef __INCLUDED_DIA_IOCTRL_TIMER_CLIENT__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlTimerClient.h"
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include <common/framework/application/dia_LockScope.h>
#endif

using namespace dia;

#ifndef __DIA_UNIT_TESTING__

dia_IOCtrlTimer*
getInstanceOfIOCtrlTimer ( void )
{
   return dia_IOCtrlTimer::getInstance();
}

void
releaseInstanceOfIOCtrlTimer ( void )
{
   return dia_IOCtrlTimer::deleteInstance();
}

#endif

// implementation of the singleton methods
DIA_IMPL_SINGLETON_WITH_SETUP_AND_TEARDOWN(dia_IOCtrlTimer)

//------------------------------------------------------------------------------

dia_IOCtrlTimer::dia_IOCtrlTimer ( void )
   : mSyncObj("dia_IOCtrlTimer_LK"),
     mIsSetup(false),
     mIsActive(false)
{
   ScopeTrace oTrace("dia_IOCtrlTimer::dia_IOCtrlTimer");
}

//------------------------------------------------------------------------------

dia_IOCtrlTimer::~dia_IOCtrlTimer ( void )
{
// ScopeTrace oTrace("dia_IOCtrlTimer::~dia_IOCtrlTimer");
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlTimer::setup ( void )
{
   if ( !mIsSetup )
   {
#ifndef __DIA_UNIT_TESTING__
      s32Create();
#endif
      mIsSetup = true;
   }
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlTimer::tearDown ( void )
{
   if ( mIsSetup )
   {
      stop();
      s32Delete();
      mIsSetup = false;
   }

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlTimer::start ( tU32 timeoutValue, tU32 cycleValue )
{
   ScopeTrace oTrace("dia_IOCtrlTimer::start()");

   tDiaResult retCode = DIA_FAILED;

   if ( !mIsActive && !mClientRep.empty() )
   {
#ifndef __DIA_UNIT_TESTING__
      if ( s32SetTime(timeoutValue,cycleValue) == OSAL_OK )
      {
         retCode   = DIA_SUCCESS;
         mIsActive = true;
      }
#else
      DIA_PARAMETER_INTENTIONALLY_UNUSED(timeoutValue);
      DIA_PARAMETER_INTENTIONALLY_UNUSED(cycleValue);
#endif
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlTimer::stop ( void )
{
   ScopeTrace oTrace("dia_IOCtrlTimer::stop()");

   tDiaResult retCode = DIA_FAILED;

   if ( mIsActive )
   {
#ifndef __DIA_UNIT_TESTING__
      if ( s32SetTime(0,0) == OSAL_OK )
      {
         retCode   = DIA_SUCCESS;
         mIsActive = false;
      }
#endif
   }

   return retCode;
}

//------------------------------------------------------------------------------

bool
dia_IOCtrlTimer::bIsRunning ( void ) const
{
   return mIsActive;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlTimer::addTimerClient ( dia_IOCtrlTimerClient* pClient )
{
   ScopeTrace oTrace("dia_IOCtrlTimer::addTimerClient()");

   LockScope oLock(mSyncObj);

   if ( pClient )
   {
      std::list<dia_IOCtrlTimerClient*>::iterator iter = find(mClientRep.begin(), mClientRep.end(), pClient);
      if ( iter == mClientRep.end() )
      {
         mClientRep.push_back(pClient);
         return DIA_SUCCESS;
      }
   }

   return DIA_FAILED;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlTimer::removeTimerClient ( dia_IOCtrlTimerClient* pClient )
{
   ScopeTrace oTrace("dia_IOCtrlTimer::removeTimerClient()");

   LockScope oLock(mSyncObj);

   if ( pClient )
   {
      std::list<dia_IOCtrlTimerClient*>::iterator iter = find(mClientRep.begin(), mClientRep.end(), pClient);
      if ( iter != mClientRep.end() )
      {
         mClientRep.erase(iter);
         return DIA_SUCCESS;
      }
   }

   return DIA_FAILED;
}

//------------------------------------------------------------------------------

void
dia_IOCtrlTimer::vOnAlarm ( void )
{
   ScopeTrace oTrace("dia_IOCtrlTimer::vOnAlarm()");

   LockScope oLock(mSyncObj);

   std::vector<dia_IOCtrlTimerClient*> elapsedTimers;

   // iterate through the timer list and record elapsed timers
   std::list<dia_IOCtrlTimerClient*>::iterator iter = mClientRep.begin();
   for ( ; iter != mClientRep.end(); ++iter )
   {
      dia_IOCtrlTimerClient* pClient = (*iter);

      DIA_TR_INF("Calling TimerClient::Tick() on Client 0x%p",pClient);

      if ( pClient && ( pClient->onTimerTickIOCtrl() == DIA_E_TIMEOUT ) )
      {
         DIA_TR_INF( "Timer of TimerClient 0x%p is elapsed...",pClient);
         elapsedTimers.push_back(*iter);
      }
   }

   // remove elapsed timers from the client repository
   if ( !elapsedTimers.empty() )
   {
      std::vector<dia_IOCtrlTimerClient*>::iterator iterElapsed = elapsedTimers.begin();
      for ( ; iterElapsed != elapsedTimers.end(); ++iterElapsed )
      {
         dia_IOCtrlTimerClient* pClient = (*iterElapsed);

         DIA_TR_INF( "Removing TimerClient 0x%p from repository...",pClient);
         removeTimerClient(pClient);
      }

      // at least one timer has been elapsed, so we need to update the ioctrl signal states
      dia_IOCtrlManager* pIOCtrlManager = getInstanceOfIOCtrlManager();
      if ( pIOCtrlManager ) pIOCtrlManager->vUpdateIOCtrlStatus();
   }

   // stop the timer if all signal timers are elapsed
   if ( mClientRep.empty() )
   {
      DIA_TR_INF( "TimerClientRep is empty. Stop the timer !!");
      stop();
   }
}
