/*
 * dia_IOCtrlSignalRestrictedToRemoteControl.cpp
 *
 *  Created on: 30.01.2015
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL_RESTRICTED_TO_REMOTE_CONTROL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignalRestrictedToRemoteControl.h"
#endif

#ifndef __INCLUDED_DIA_REMOTECONTROL__
#include "common/framework/application/dia_RemoteControl.h"
#endif

//-------------------------------------------------------------------------------

dia_IOCtrlSignalRestrictedToRemoteControl::dia_IOCtrlSignalRestrictedToRemoteControl (
      tCString name, tU16 udsID, tU8 ctrlValueSize, dia_eIOCtrlMode mode, dia_eIOCtrlMonitoringMode monitoring
   )
   : dia_IOCtrlSignal(name,udsID,ctrlValueSize,mode,monitoring)
{}

//-------------------------------------------------------------------------------

dia_IOCtrlSignalRestrictedToRemoteControl::dia_IOCtrlSignalRestrictedToRemoteControl (
      tU16 udsID, dia_eIOCtrlSignalType type, tU8 ctrlValueSize, dia_eIOCtrlMode mode, dia_eIOCtrlMonitoringMode monitoring
   )
   : dia_IOCtrlSignal(udsID,type,ctrlValueSize,mode,monitoring)
{}

//-------------------------------------------------------------------------------

dia_IOCtrlSignalRestrictedToRemoteControl::~dia_IOCtrlSignalRestrictedToRemoteControl ( void )
{}

//-------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlSignalRestrictedToRemoteControl::checkPreconditions ( void ) const
{
   dia_tclFnctTrace oTrace("dia_IOCtrlSignalRestrictedToRemoteControl::checkPreconditions()");
   tDiaResult retCode = DIA_E_IOCTRL_PRECONDITIONS_NOT_MATCHED;

   if ( getInstanceOfRemoteControl()->getRemoteControlMode() == DIA_EN_REMOTE_CONTROL_MODE_ACTIVE )
   {
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

//-------------------------------------------------------------------------------

bool
dia_IOCtrlSignalRestrictedToRemoteControl::isFrozen ( void ) const
{
   return true;
}

