/*
 * dia_IOCtrlSignal.cpp
 *
 *  Created on: 03.07.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include <common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h>
#endif

#ifndef __INCLUDED_DIA_HASH_CALCULATOR__
#include <common/framework/utils/dia_HashCalculator.h>
#endif

static tCString arIOCtrlSignalNameMapping[DIA_EN_IOCTRL_NUM_OF_SIGNALS] = {
   "DIA_EN_IOCTRL_SIGTYPE_UNKNOWN",
   "DIA_EN_IOCTRL_SIGTYPE_ACTIVE_VIDEO_SOURCE",
   "DIA_EN_IOCTRL_SIGTYPE_ACTUATOR_FRONT_LEFT",
   "DIA_EN_IOCTRL_SIGTYPE_ACTUATOR_FRONT_RIGHT",
   "DIA_EN_IOCTRL_SIGTYPE_ACTUATOR_REAR_LEFT",
   "DIA_EN_IOCTRL_SIGTYPE_ACTUATOR_REAR_RIGHT",
   "DIA_EN_IOCTRL_SIGTYPE_AUDIO_BALANCE",
   "DIA_EN_IOCTRL_SIGTYPE_AUDIO_FADER",
   "DIA_EN_IOCTRL_SIGTYPE_AUDIO_SELECT_COMPRESSED_AUDIO_TITLE",
   "DIA_EN_IOCTRL_SIGTYPE_AUDIO_SOURCE",
   "DIA_EN_IOCTRL_SIGTYPE_AUDIO_TESTTONE",
   "DIA_EN_IOCTRL_SIGTYPE_AUDIO_LINEARMODE",
   "DIA_EN_IOCTRL_SIGTYPE_AUDIO_VOLUME",
   "DIA_EN_IOCTRL_SIGTYPE_AUDIO_EXT_AMPL_CONTLINE",
   "DIA_EN_IOCTRL_SIGTYPE_BLUETOOTH_PAGING",
   "DIA_EN_IOCTRL_SIGTYPE_BLUETOOTH_MODE",
   "DIA_EN_IOCTRL_SIGTYPE_BLUETOOTH_MODULE_RESET",
   "DIA_EN_IOCTRL_SIGTYPE_BLUETOOTH_SEARCH_DEVICES",
   "DIA_EN_IOCTRL_SIGTYPE_CDDRIVE_TEST_QUICK",
   "DIA_EN_IOCTRL_SIGTYPE_CD_MODE_CONTROL",
   "DIA_EN_IOCTRL_SIGTYPE_DATASET_BLOCK_SIZE",
   "DIA_EN_IOCTRL_SIGTYPE_DISPLAY_BRIGHTNESS",
   "DIA_EN_IOCTRL_SIGTYPE_DISPLAY_TEST",
   "DIA_EN_IOCTRL_SIGTYPE_DISPLAY_TEST_PATTERN",
   "DIA_EN_IOCTRL_SIGTYPE_CDROM_EJECT",
   "DIA_EN_IOCTRL_SIGTYPE_IPSIM_KEY_CODE_SIMULATION",
   "DIA_EN_IOCTRL_SIGTYPE_IPSIM_PRESSED_KEY",
   "DIA_EN_IOCTRL_SIGTYPE_IPSIM_LOCK_INFO_CONTROL",
   "DIA_EN_IOCTRL_SIGTYPE_IPSIM_VOLUME_SIMULATION",
   "DIA_EN_IOCTRL_SIGTYPE_IPSIM_CONTROL_KNOB_SIMULATION",
   "DIA_EN_IOCTRL_SIGTYPE_FAN",
   "DIA_EN_IOCTRL_SIGTYPE_GNSS_SYSTEM",
   "DIA_EN_IOCTRL_SIGTYPE_HMI_LANGUAGE",
   "DIA_EN_IOCTRL_SIGTYPE_KEYILLUMINATION_BRIGHTNESS",
   "DIA_EN_IOCTRL_SIGTYPE_PLAYED_TRACK",
   "DIA_EN_IOCTRL_SIGTYPE_PRESSED_KEY",
   "DIA_EN_IOCTRL_SIGTYPE_REMOTE_CONTROL_STATE",
   "DIA_EN_IOCTRL_SIGTYPE_SYSTEM_HMI_ON",
   "DIA_EN_IOCTRL_SIGTYPE_SYSTEM_REMOTE_CONTROL",
   "DIA_EN_IOCTRL_SIGTYPE_TUNER_SEL_ACTIVE_TUNER_AMFM",
   "DIA_EN_IOCTRL_SIGTYPE_TUNERAMFM_ANT1_POWER_SUPPLY",
   "DIA_EN_IOCTRL_SIGTYPE_TUNERDAB_ANT1_POWER_SUPPLY",
   "DIA_EN_IOCTRL_SIGTYPE_TUNER_SET_BAND_AMFM",
   "DIA_EN_IOCTRL_SIGTYPE_TUNER_SET_FREQUENCY_AMFM",
   "DIA_EN_IOCTRL_SIGTYPE_TUNER_SETTINGS",
   "DIA_EN_IOCTRL_SIGTYPE_TUNERDRM_ANT_SERVICE_ID",
   "DIA_EN_IOCTRL_SIGTYPE_TUNERDRM_ANT_ENSEMBLE_FREQUENCY",
   "DIA_EN_IOCTRL_SIGTYPE_TUNERXM_1_Channel",
   "DIA_EN_IOCTRL_SIGTYPE_RVC_CONTROLLINE",
   "DIA_EN_IOCTRL_SIGTYPE_CD_RESET_LINE",
   "DIA_EN_IOCTRL_SIGTYPE_MICROPHONE_POWER_SUPPLY",
   "DIA_EN_IOCTRL_SIGTYPE_MICROPHONE_POWER_SUPPLY_2",
   "DIA_EN_IOCTRL_SIGTYPE_TUNERAMFM_ANT2_POWER_SUPPLY",
   "DIA_EN_IOCTRL_SIGTYPE_TUNERDAB_ANT1_ENSEMBLE_FREQUENCY",
   "DIA_EN_IOCTRL_SIGTYPE_TUNERDAB_ANT1_SERVICE_ID",
   "DIA_EN_IOCTRL_SIGTYPE_KEY_ILLUMINATION_PWM",
   "DIA_EN_IOCTRL_SIGTYPE_USB_POWER_SUPPLY_1",
   "DIA_EN_IOCTRL_SIGTYPE_USB_POWER_SUPPLY_2",
   "DIA_EN_IOCTRL_SIGTYPE_USB_POWER_SUPPLY_3",
   "DIA_EN_IOCTRL_SIGTYPE_VIDEO_SOURCE",
   "DIA_EN_IOCTRL_SIGTYPE_NEONODE_RESETLINE"

};

//------------------------------------------------------------------------------

dia_IOCtrlSignal::dia_IOCtrlSignal (
   tU16 udsID,                    // DID
   dia_eIOCtrlSignalType type,    // described in dia_IOCtrl.h
   tU8 ctrlValueSize,             // payload Length - can be overloaded by checkPayloadCorrectness in SH
   dia_eIOCtrlMode mode,          // e.g. DIA_EN_IOCTRL_CTRLMODE_ECU
   dia_eIOCtrlMonitoringMode monitoring  // Defines time for monitoring
   )
   : mName(arIOCtrlSignalNameMapping[type]),
     mUdsID(udsID),
     mCtrlValueSize(ctrlValueSize),
     mStatus(DIA_EN_IOCTRL_STATUS_INACTIVE),
     mMode(mode),
     mTimerMode(monitoring),
     mTimerValue(IOCTRL_U8_TIMER_TIMEOUT_INFINITE),
     mTimerCounter(IOCTRL_U16_TIMER_TIMEOUT_INFINITE),
     mIsResultReady(FALSE),
     mErrorInfo(DIA_E_NOERROR)
{
   mUID = dia_getHashCodeFromString(mName);
}

//------------------------------------------------------------------------------

dia_IOCtrlSignal::dia_IOCtrlSignal (
   tCString name,
   tU16 udsID,                    // DID
   tU8 ctrlValueSize,             // payload Length - can be overloaded by checkPayloadCorrectness in SH
   dia_eIOCtrlMode mode,          // e.g. DIA_EN_IOCTRL_CTRLMODE_ECU
   dia_eIOCtrlMonitoringMode monitoring  // Defines time for monitoring
   )
   : mName(name),
     mUdsID(udsID),
     mCtrlValueSize(ctrlValueSize),
     mStatus(DIA_EN_IOCTRL_STATUS_INACTIVE),
     mMode(mode),
     mTimerMode(monitoring),
     mTimerValue(IOCTRL_U8_TIMER_TIMEOUT_INFINITE),
     mTimerCounter(IOCTRL_U16_TIMER_TIMEOUT_INFINITE),
     mIsResultReady(FALSE),
     mErrorInfo(DIA_E_NOERROR)
{
   mUID = dia_getHashCodeFromString(mName);
}

//------------------------------------------------------------------------------

dia_IOCtrlSignal::~dia_IOCtrlSignal ( void )
{
   mName = 0;
}

//------------------------------------------------------------------------------

dia_UID
dia_IOCtrlSignal::getUID ( void ) const
{
   return mUID;
}

//------------------------------------------------------------------------------

tU16
dia_IOCtrlSignal::getDID ( void ) const
{
   return mUdsID;
}

//------------------------------------------------------------------------------

dia_eIOCtrlStatus
dia_IOCtrlSignal::getStatus ( void ) const
{
   return mStatus;
}

//------------------------------------------------------------------------------

void
dia_IOCtrlSignal::setStatus ( dia_eIOCtrlStatus newStatus )
{
   mStatus = newStatus;
}

//------------------------------------------------------------------------------

dia_eIOCtrlMode
dia_IOCtrlSignal::getMode ( void ) const
{
   return mMode;
}

//------------------------------------------------------------------------------

void
dia_IOCtrlSignal::setMode ( dia_eIOCtrlMode mode )
{
   mMode = mode;
}

//------------------------------------------------------------------------------

dia_eIOCtrlMonitoringMode
dia_IOCtrlSignal::getMonitoringMode ( void ) const
{
   return mTimerMode;
}

//------------------------------------------------------------------------------

void
dia_IOCtrlSignal::setMonitoringMode ( dia_eIOCtrlMonitoringMode mode, tU8 timerValue )
{
   mTimerMode  = mode;
   mTimerValue = timerValue;
}

//------------------------------------------------------------------------------

tU16
dia_IOCtrlSignal::sizeOfCtrlValue ( void ) const
{
   return mCtrlValueSize;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlSignal::onTimerTickIOCtrl ( void )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlSignal::onTimerTickIOCtrl()");

   tDiaResult retCode = DIA_E_NOERROR;

   switch ( getMonitoringMode() )
   {
   case DIA_EN_IOCTRL_MONITORING_MODE_SHORT_TERM_ADJUSTMENT:
      {
         if ( (mTimerCounter > 0) && (mTimerCounter != IOCTRL_U16_TIMER_TIMEOUT_INFINITE) )
         {
            mTimerCounter--;
            if ( mTimerCounter == 0 )
            {
               // timer for this signal is elapsed
               handleTimerElapsed();
               retCode = DIA_E_TIMEOUT;
            }
         }
      }
      break;

   default:
      break;
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlSignal::checkPayloadCorrectness ( tU16 realLength, std::vector<tU8>* /*paylValue*/ )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlSignal::checkPayloadCorrectness()");

   tDiaResult retCode = DIA_FAILED;

   tU16 expectedDataLength = tU16(DIA_C_U16_IOCTRL_PAYLOAD_START_BYTE + sizeOfCtrlValue());
   if ( getMonitoringMode() != DIA_EN_IOCTRL_MONITORING_MODE_NOT_SUPPORTED )
   {
      expectedDataLength++;
   }

   if ( realLength == expectedDataLength )
   {
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_ERR("DIA_C_U8_UDS_IOCTRL_SHORT_TERM_ADJUSTMENT - INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT");
      DIA_TR_ERR("DIA_C_U8_UDS_IOCTRL_SHORT_TERM_ADJUSTMENT - SOLL=%d ; IST=%d .", expectedDataLength, realLength);
   }

   return retCode;
}

//------------------------------------------------------------------------------

void
dia_IOCtrlSignal::initializeRequest ( void )
{
   initializeRequest(DIA_C_U16_IOCTRL_DEFAULT_TIMER_VALUE,0);
}

//------------------------------------------------------------------------------

void
dia_IOCtrlSignal::initializeRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue )
{
   mErrorInfo     = DIA_E_NOERROR;
   mIsResultReady = FALSE;
   mTimerValue    = timerValue;

   mCtrlValue.clear();
   if ( ctrlValue ) mCtrlValue.assign(ctrlValue->begin(),ctrlValue->end()); //lint !e864
}

//------------------------------------------------------------------------------

bool
dia_IOCtrlSignal::isResultReady ( void ) const
{
   return ( mIsResultReady == TRUE ) ? true : false;
}

//------------------------------------------------------------------------------

bool
dia_IOCtrlSignal::isFrozen ( void ) const
{
   return ( getMode() == DIA_EN_IOCTRL_CTRLMODE_TESTER ) ? true : false;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlSignal::checkFreezeLength ( tU16 length ) const
{
   return ( length == DIA_C_U16_IOCTRL_MIN_MESSAGE_LENGTH ) ? DIA_SUCCESS : DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlSignal::handleFreeze ( void )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlSignal::handleFreeze()");

   setMode(DIA_EN_IOCTRL_CTRLMODE_TESTER);
   DIA_TR_INF("Signal %s Frozen", mName);
   mIsResultReady = TRUE;

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlSignal::handleReturnControlToECU ( void )
{
    dia_tclFnctTrace oTrace("dia_IOCtrlSignal::handleReturnControlToECU()");

    tDiaResult retCode = DIA_SUCCESS;

    setMode(DIA_EN_IOCTRL_CTRLMODE_ECU);

    if ( getStatus() == DIA_EN_IOCTRL_STATUS_INACTIVE )
    {
       setResultReady();
    }
    else
    {
       retCode = vOnTerminate(DIA_EN_IOCTRL_STATUS_INACTIVE);
    }

    return retCode;
}

//------------------------------------------------------------------------------

tU8
dia_IOCtrlSignal::getTimerValue ( void ) const
{
   return mTimerValue;
}

//------------------------------------------------------------------------------

const std::vector<tU8>&
dia_IOCtrlSignal::getControlValue ( void ) const
{
   return mCtrlValue;
}

//! set the timer for this signal (specified in seconds
void
dia_IOCtrlSignal::setTimer ( tU16 seconds )
{
   mTimerCounter = seconds;
}

//------------------------------------------------------------------------------

void
dia_IOCtrlSignal::handleTimerElapsed ( void )
{
    DIA_TR_INF("dia_IOCtrlSignal::TimerElapsed !!");

    // notify the HMI to switch off the test screen and update the signal status
    (void) vOnTerminate(DIA_EN_IOCTRL_STATUS_INACTIVE_TIMEOUT);
}

//------------------------------------------------------------------------------

void
dia_IOCtrlSignal::getCurrentState ( std::vector<tU8>& results )
{
   dia_tclFnctTrace trc("dia_IOCtrlSignal::getCurrentState");
   for ( tU16 j=0; j<sizeOfCtrlValue(); j++ ) results.push_back(0x00);
}

