/*
 * dia_IOCtrlManager.h
 *
 *  Created on: 09.07.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_IOCTRL_MANAGER__
#define __INCLUDED_DIA_IOCTRL_MANAGER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_IOCTRL__
#include <common/framework/protocols/uds/ioctrl/dia_IOCtrl.h>
#endif

#ifndef __INCLUDED_DIA_IOCTRLMANAGERFSM__
#include <common/framework/fsm/generated/dia_IOCtrlManagerFSM.h>
#endif


#ifndef __INCLUDED_DIA_INTERFACE_SESSION_LISTENER__
#include <common/interfaces/dia_ISessionListener.h>
#endif

#ifndef __INCLUDED_DIA_LOCK__
#include <common/framework/application/dia_Lock.h>
#endif

class dia_IOCtrlSignal;
class dia_IIOControlListener;

class dia_IOCtrlManager
   : protected dia_IOCtrlManagerFSM::FsmBehaviour,
     public dia_ISessionListenerImpl
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_IOCtrlManager);
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_IOCtrlManager);

public:
   //! setup method used to allocate memory on the heap etc.
   virtual tDiaResult setup ( void );
   //! teardown method used for cleanup tasks like releasing memory from heap
   virtual tDiaResult tearDown ( void );
   //! setup shall only performed once
   virtual bool isSetup ( void ) const { return mIsSetup; }

   //! add a signal to the signal repository
   virtual tDiaResult addSignal ( dia_IOCtrlSignal* pSignal );
   //! remove a signal from the signal repository
   virtual tDiaResult removeSignal ( dia_UID uid );
   //! return the number of signals in the signal repository
   tU16 numberOfSignals ( void ) const;

   //! add a listener for the signal with the given UID
   virtual tDiaResult addIOControlListener ( dia_UID uid, dia_IIOControlListener* pListener );
   //! remove a listener
   virtual tDiaResult removeIOControlListener ( dia_UID uid, dia_IIOControlListener* pListener );

   //! get the current IO control state
   virtual dia_eIOCtrlStatus getIOControlStatus ( void );
   //! update the IOCtrl status
   virtual void vUpdateIOCtrlStatus ( void );

   //! freeze the specified signal
   virtual tDiaResult freeze ( dia_UID uid );
   //! freeze the specified signal
   virtual tDiaResult freeze ( dia_IOCtrlSignal& signal );
   //! checks if the specified signal is frozen
   virtual bool isFrozen ( dia_UID uid );
   //! checks if the specified signal is frozen
   virtual bool isFrozen ( dia_IOCtrlSignal& signal );
   //! shortTermAdjustment for the specified signal
   virtual tDiaResult shortTermAdjustment ( dia_UID uid, tU8 timerValue, std::vector<tU8>* ctrlValue );
   //! shortTermAdjustment for the specified signal
   virtual tDiaResult shortTermAdjustment ( dia_IOCtrlSignal& signal, tU8 timerValue, std::vector<tU8>* ctrlValue );
   //! return control back to the ECU for the specified signal
   virtual tDiaResult returnControlToECU ( dia_UID uid );
   //! return control back to the ECU for the specified signal
   virtual tDiaResult returnControlToECU ( dia_IOCtrlSignal& signal );

   //! handle timeout from UDS session object
   virtual void handleTimeout ( void );

   //! check if the result of the specified signal is available
   virtual bool isResultReady ( dia_UID uid );

   //! query for a certain routine
   virtual tDiaResult queryIOControlSignal ( dia_UID uid, dia_IOCtrlSignal** ppSignal );
   //! query for a certain routine
   virtual tDiaResult queryIOControlSignalByDID ( tU16 did, dia_IOCtrlSignal** ppSignal );

   //! return the unique identifier of the active iocontrol signal
   dia_UID getActiveSignalUID ( void ) const { return mActiveSignalUID; }

   const std::map<dia_UID,dia_IOCtrlSignal*>& getSignals ( void ) const;

   //
   // Methods defined in SessionListener interface
   //

   virtual tDiaResult configureSessionHandling ( tU8 currentSession, tU8 nextSession, bool stopMode = true );
   virtual tDiaResult configureSessionHandling ( tU8 currentSession, bool stopMode = true );

   //! called by the session control object to notify about a session change
   virtual void vOnSessionChanged ( tU8 newSession, tU8 oldSession );

   //! this method is used by iocontrol signals to notify about an update on the given signal
   static void vOnSignalUpdate ( dia_IOCtrlSignal& pSignal );

protected:
   //! default class constructor
   dia_IOCtrlManager ( void );
   //! class destructor
   virtual ~dia_IOCtrlManager ( void );

   // FSM actions
   virtual void vFsmAddSignal ( void* pArg );
   virtual void vFsmCollectSignals ( void* pArg );
   virtual void vFsmHandleTimeout ( void* pArg );
   virtual void vFsmRemoveSignal ( void* pArg );
   virtual void vFsmReset ( void* pArg );
   virtual void vFsmStopNextSignal ( void* pArg );

   // FSM guards
   virtual bool bFsmIsNoSignalActive ( void* pArg );

   //! post a trigger state machine event to the state machine
   virtual void acceptEvent ( dia_IOCtrlManagerFSM::FsmEvent event, void* pArg );

protected:
   //! synchronization object used to ensure synchronized access to data structures and containers
   mutable dia::Lock mSyncObj;
   //! operation mode of the remote control (activated or not activated)
   dia_eIOCtrlRemoteControlState mOperationMode;
   //! status of the ioctrl signals (e.g. used in generic measurement value)
   dia_eIOCtrlStatus mIOCtrlStatus;
   //! active signal
   dia_UID mActiveSignalUID;
   //! active signal's control state
   tU8 mActiveSignalControlState;

   //! pointer to the FSM object
   dia_IOCtrlManagerFSM::Fsm* mpFSM;

   //! flag to indicate whether setup() was already called
   bool mIsSetup;

   //! repository of signal controlled via remote control
   std::map<dia_UID,dia_IOCtrlSignal*> mSignalRep;
   std::map<dia_UID,dia_IOCtrlSignal*>::iterator mSignalRepIter;
   std::map<dia_UID,dia_IOCtrlSignal*>::const_iterator mSignalRepCIter;
   std::map<tU16,bool> mSessionHandlingRep;
   //! map of listeners
   std::map<dia_UID,dia_IIOControlListener*> mListenerRep;

   //! timer used for short term adjustment of signals
   dia_IOCtrlTimer* mpTimer;

   //
   std::map<dia_UID,dia_IOCtrlSignal*> mActiveSignals;
   std::map<dia_UID,dia_IOCtrlSignal*>::iterator mActiveSignalIter;
};

#endif /* DIA_IOCTRLMANAGER_H_ */
