/*
 * dia_IOCtrl.h
 *
 *  Created on: 28.06.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_IOCTRL__
#define __INCLUDED_DIA_IOCTRL__

////////////////////////////////////////////////////////////////////////////////
//
// Defines
//
////////////////////////////////////////////////////////////////////////////////

#define DIA_C_U8_UDS_IOCTRL_RETURN_CTRL_TO_ECU     ((tU8) 0x00)
#define DIA_C_U8_UDS_IOCTRL_RESET_OR_INIT          ((tU8) 0x01)
#define DIA_C_U8_UDS_IOCTRL_FREEZE_CURRENT_STATE   ((tU8) 0x02)
#define DIA_C_U8_UDS_IOCTRL_SHORT_TERM_ADJUSTMENT  ((tU8) 0x03)

#define DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE   ((tU8) 0xFF)

////////////////////////////////////////////////////////////////////////////////
//
// Types
//
////////////////////////////////////////////////////////////////////////////////

// Enum that specifies the type of signal that shall be remote controlled

enum dia_eIOCtrlSignalType
{
   DIA_EN_IOCTRL_SIGTYPE_UNKNOWN = 0,
   DIA_EN_IOCTRL_SIGTYPE_ACTIVE_VIDEO_SOURCE,
   DIA_EN_IOCTRL_SIGTYPE_ACTUATOR_FRONT_LEFT,
   DIA_EN_IOCTRL_SIGTYPE_ACTUATOR_FRONT_RIGHT,
   DIA_EN_IOCTRL_SIGTYPE_ACTUATOR_REAR_LEFT,
   DIA_EN_IOCTRL_SIGTYPE_ACTUATOR_REAR_RIGHT,
   DIA_EN_IOCTRL_SIGTYPE_AUDIO_BALANCE,
   DIA_EN_IOCTRL_SIGTYPE_AUDIO_FADER,
   DIA_EN_IOCTRL_SIGTYPE_AUDIO_SELECT_COMPRESSED_AUDIO_TITLE,
   DIA_EN_IOCTRL_SIGTYPE_AUDIO_SOURCE,
   DIA_EN_IOCTRL_SIGTYPE_AUDIO_TESTTONE,
   DIA_EN_IOCTRL_SIGTYPE_AUDIO_LINEARMODE,
   DIA_EN_IOCTRL_SIGTYPE_AUDIO_VOLUME,
   DIA_EN_IOCTRL_SIGTYPE_AUDIO_EXT_AMPL_CONTLINE,
   DIA_EN_IOCTRL_SIGTYPE_BLUETOOTH_PAGING,
   DIA_EN_IOCTRL_SIGTYPE_BLUETOOTH_MODE,
   DIA_EN_IOCTRL_SIGTYPE_BLUETOOTH_MODULE_RESET,
   DIA_EN_IOCTRL_SIGTYPE_BLUETOOTH_SEARCH_DEVICES,
   DIA_EN_IOCTRL_SIGTYPE_CDDRIVE_TEST_QUICK,
   DIA_EN_IOCTRL_SIGTYPE_CD_MODE_CONTROL,
   DIA_EN_IOCTRL_SIGTYPE_DATASET_BLOCK_SIZE,
   DIA_EN_IOCTRL_SIGTYPE_DISPLAY_BRIGHTNESS,
   DIA_EN_IOCTRL_SIGTYPE_DISPLAY_TEST,
   DIA_EN_IOCTRL_SIGTYPE_DISPLAY_TEST_PATTERN,
   DIA_EN_IOCTRL_SIGTYPE_CDROM_EJECT,
   DIA_EN_IOCTRL_SIGTYPE_IPSIM_KEY_CODE_SIMULATION,
   DIA_EN_IOCTRL_SIGTYPE_IPSIM_PRESSED_KEY,
   DIA_EN_IOCTRL_SIGTYPE_IPSIM_LOCK_INFO_CONTROL,
   DIA_EN_IOCTRL_SIGTYPE_IPSIM_VOLUME_SIMULATION,
   DIA_EN_IOCTRL_SIGTYPE_IPSIM_CONTROL_KNOB_SIMULATION,
   DIA_EN_IOCTRL_SIGTYPE_FAN,
   DIA_EN_IOCTRL_SIGTYPE_GNSS_SYSTEM,
   DIA_EN_IOCTRL_SIGTYPE_HMI_LANGUAGE,
   DIA_EN_IOCTRL_SIGTYPE_KEYILLUMINATION_BRIGHTNESS,
   DIA_EN_IOCTRL_SIGTYPE_PLAYED_TRACK,
   DIA_EN_IOCTRL_SIGTYPE_PRESSED_KEY,
   DIA_EN_IOCTRL_SIGTYPE_REMOTE_CONTROL_STATE,
   DIA_EN_IOCTRL_SIGTYPE_SYSTEM_HMI_ON,
   DIA_EN_IOCTRL_SIGTYPE_SYSTEM_REMOTE_CONTROL,
   DIA_EN_IOCTRL_SIGTYPE_TUNER_SEL_ACTIVE_TUNER_AMFM,
   DIA_EN_IOCTRL_SIGTYPE_TUNERAMFM_ANT1_POWER_SUPPLY,
   DIA_EN_IOCTRL_SIGTYPE_TUNERDAB_ANT1_POWER_SUPPLY,
   DIA_EN_IOCTRL_SIGTYPE_TUNER_SET_BAND_AMFM,
   DIA_EN_IOCTRL_SIGTYPE_TUNER_SET_FREQUENCY_AMFM,
   DIA_EN_IOCTRL_SIGTYPE_TUNER_SETTINGS,
   DIA_EN_IOCTRL_SIGTYPE_TUNERDRM_ANT_SERVICE_ID,
   DIA_EN_IOCTRL_SIGTYPE_TUNERDRM_ANT_ENSEMBLE_FREQUENCY,
   DIA_EN_IOCTRL_SIGTYPE_TUNERXM_1_Channel,
   DIA_EN_IOCTRL_SIGTYPE_RVC_CONTROLLINE,
   DIA_EN_IOCTRL_SIGTYPE_CD_RESET_LINE,
   DIA_EN_IOCTRL_SIGTYPE_MICROPHONE_POWER_SUPPLY,
   DIA_EN_IOCTRL_SIGTYPE_MICROPHONE_POWER_SUPPLY_2,
   DIA_EN_IOCTRL_SIGTYPE_TUNERAMFM_ANT2_POWER_SUPPLY,
   DIA_EN_IOCTRL_SIGTYPE_TUNERDAB_ANT1_ENSEMBLE_FREQUENCY,
   DIA_EN_IOCTRL_SIGTYPE_TUNERDAB_ANT1_SERVICE_ID,
   DIA_EN_IOCTRL_SIGTYPE_KEY_ILLUMINATION_PWM,
   DIA_EN_IOCTRL_SIGTYPE_USB_POWER_SUPPLY_1,
   DIA_EN_IOCTRL_SIGTYPE_USB_POWER_SUPPLY_2,
   DIA_EN_IOCTRL_SIGTYPE_USB_POWER_SUPPLY_3,
   DIA_EN_IOCTRL_SIGTYPE_VIDEO_SOURCE,
   DIA_EN_IOCTRL_SIGTYPE_NEONODE_RESETLINE,
   DIA_EN_IOCTRL_NUM_OF_SIGNALS
};

// Enum that specifies who controls the signal. Either ECU itself or the tester

enum dia_eIOCtrlMode
{
   DIA_EN_IOCTRL_CTRLMODE_UNKNOWN = 0,
   DIA_EN_IOCTRL_CTRLMODE_ECU,         // iocontrol signal is controlled by the ECU
   DIA_EN_IOCTRL_CTRLMODE_TESTER,      // iocontrol signal is controlled by the external tester
   DIA_EN_IOCTRL_NUM_OF_CTRL_MODES
};

// Enum that specifies if the remote control mode is controlled by a timer

enum dia_eIOCtrlMonitoringMode
{
   DIA_EN_IOCTRL_MONITORING_MODE_UNDEFINED = 0,
   DIA_EN_IOCTRL_MONITORING_MODE_SHORT_TERM_ADJUSTMENT,
   DIA_EN_IOCTRL_MONITORING_MODE_DISABLED,
   DIA_EN_IOCTRL_MONITORING_MODE_NOT_SUPPORTED,
   DIA_EN_IOCTRL_NUM_OF_MONITORING_MODES
};

enum dia_eIOCtrlRemoteControlState
{
   DIA_EN_IOCTRL_REMOTECONTROL_STATE_UNDEFINED = 0,
   DIA_EN_IOCTRL_REMOTECONTROL_STATE_ON,
   DIA_EN_IOCTRL_REMOTECONTROL_STATE_OFF,
   DIA_EN_IOCTRL_NUM_OF_REMOTECONTROL_STATES
};

enum dia_eIOCtrlStatus
{
   DIA_EN_IOCTRL_STATUS_INACTIVE = 0,
   DIA_EN_IOCTRL_STATUS_INACTIVE_ABORTED,
   DIA_EN_IOCTRL_STATUS_INACTIVE_TIMEOUT,
   DIA_EN_IOCTRL_STATUS_ACTIVE,
   DIA_EN_IOCTRL_NUM_OF_IOCTRL_STATES
};

////////////////////////////////////////////////////////////////////////////////
//
// Defines
//
////////////////////////////////////////////////////////////////////////////////

#define IOCTRL_U8_TIMER_TIMEOUT_INFINITE  ((tU8)  0xFF)
#define IOCTRL_U8_TIMER_TIMEOUT_MAX       ((tU8)  0xFA)
#define IOCTRL_U16_TIMER_TIMEOUT_INFINITE ((tU16) 0xFFFF)

////////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
////////////////////////////////////////////////////////////////////////////////

class dia_IOCtrlSignal;
class dia_IOCtrlTimer;
class dia_IOCtrlTimerClient;

#endif /* __INCLUDED_DIA_IOCTRL__ */
