/*
 * \file        dia_EcuResetManager.h
 *
 * \brief       {insert brief description here}
 *
 * \details     {insert file description here}
 *
 * \author      kaa1hi
 * \date        Apr 21, 2015
 *
 * \copyright   Robert Bosch Car Multimedia 2015
 */

#ifndef __INCLUDED_DIA_ECURESET_MANAGER__
#define __INCLUDED_DIA_ECURESET_MANAGER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ECURESET_PLUGIN__
#include "common/framework/protocols/uds/ecureset/dia_EcuResetPlugin.h"
#endif

#ifndef __INCLUDED_DIA_ECURESET__
#include "common/framework/protocols/uds/ecureset/dia_EcuReset.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ECURESET__
#include "common/interfaces/dia_IEcuReset.h"
#endif

class dia_EcuResetManager
   : public dia_IEcuReset
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_EcuResetManager);

public:

   //
   // Methods defined in dia_IRoutineControl interface
   //

   //! install a reset service handler
   virtual tDiaResult addReset ( dia_EcuResetPlugin* pEcuResetSrvHandler );

   //! uninstall a reset service handler
   virtual tDiaResult removeReset ( dia_UID uid );


   //
   // Others methods
   //
   //! Triger  response to the tester (positive or negative)
   void vOnEcuResetUpdate ( dia_EcuResetPlugin* pEcuResetPlugin, tDiaResult result ) const;

   //! return number of registered signals
   virtual tU16 numberOfResets ( void ) const;

   const std::map<dia_UID,dia_EcuResetPlugin*>& getUIDResetSrvHandlers ( void ) const;

   virtual dia_EcuResetPlugin* getResetSrvHandler ( dia_UID uid ) const;

   virtual dia_EcuResetPlugin* getResetSrvHandler ( dia_ResetType resetType ) const;

protected:
   //! default class constructor
   dia_EcuResetManager ( void );
   //! class destructor
   virtual ~dia_EcuResetManager ( void );

protected:
   //! repository of reset service handler with key = UID (UID is hash code from name)
   std::map<dia_UID,dia_EcuResetPlugin*> mUIDResetRep;

   //! repository of reset service handler with key = reset type (according UDS standard, i.e. 0x01 )
   std::map<dia_ResetType,dia_EcuResetPlugin*> mTypeResetRep;
};

#endif /* __INCLUDED_DIA_ECURESET_MANAGER__ */
