#ifndef __INCLUDED_DIA_DEFINES_UDS__
#define __INCLUDED_DIA_DEFINES_UDS__

// 1 byte service identifiers
#define  DIA_C_U8_UDS_SID_INVALID                                           ((tU8) 0x00)
#define  DIA_C_U8_UDS_SID_SESSION_CONTROL                                   ((tU8) 0x10)
#define  DIA_C_U8_UDS_SID_ECU_RESET                                         ((tU8) 0x11)
#define  DIA_C_U8_UDS_SID_CLEAR_DIAG_INFO                                   ((tU8) 0x14)
#define  DIA_C_U8_UDS_SID_READ_DTC_INFO                                     ((tU8) 0x19)
#define  DIA_C_U8_UDS_SID_READ_DATA_BY_LOCAL_IDENTIFIER                     ((tU8) 0x21)
#define  DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER                           ((tU8) 0x22)
#define  DIA_C_U8_UDS_SID_READ_MEMORY_BY_ADDRESS                            ((tU8) 0x23)
#define  DIA_C_U8_UDS_SID_SECURITY_ACCESS                                   ((tU8) 0x27)
#define  DIA_C_U8_UDS_SID_COMMUNICATION_CONTROL                             ((tU8) 0x28)
#define  DIA_C_U8_UDS_SID_DYNMICALLY_DEFINE_DATA_IDENTIFIER                 ((tU8) 0x2C)
#define  DIA_C_U8_UDS_SID_WRITE_DATA_BY_IDENTIFIER                          ((tU8) 0x2E)
#define  DIA_C_U8_UDS_SID_IOCONTROL_BY_LOCAL_IDENTIFIER                     ((tU8) 0x30)
#define  DIA_C_U8_UDS_SID_REQUEST_DATA_DOWNLOAD                             ((tU8) 0x34)
#define  DIA_C_U8_UDS_SID_REQUEST_DATA_UPLOAD                               ((tU8) 0x35)
#define  DIA_C_U8_UDS_SID_TRANSFER_DATA                                     ((tU8) 0x36)
#define  DIA_C_U8_UDS_SID_TRANSFER_EXIT                                     ((tU8) 0x37)
#define  DIA_C_U8_UDS_SID_REQUEST_FILE_TRANSFER                             ((tU8) 0x38)
#define  DIA_C_U8_UDS_SID_WRITE_DATA_BY_LOCAL_IDENTIFIER                    ((tU8) 0x3B)
#define  DIA_C_U8_UDS_SID_TESTER_PRESENT                                    ((tU8) 0x3E)
#define  DIA_C_U8_UDS_SID_IOCONTROL_BY_IDENTIFIER                           ((tU8) 0x2F)
#define  DIA_C_U8_UDS_SID_ROUTINE_CONTROL                                   ((tU8) 0x31)
#define  DIA_C_U8_UDS_SID_WRITE_MEMORY_BY_ADDRESS                           ((tU8) 0x3D)
#define  DIA_C_U8_UDS_SID_ACCESS_TIMING_PARAMETER                           ((tU8) 0x83)
#define  DIA_C_U8_UDS_SID_CONTROL_DTC_SETTING                               ((tU8) 0x85)
#define  DIA_C_U8_UDS_SID_RESPONSE_ON_EVENT                                 ((tU8) 0x86)
#define  DIA_C_U8_UDS_SID_LINK_CONTROL                                      ((tU8) 0x87)

#define  DIA_C_U8_UDS_SID_NEGATIVE_RESPONSE                                 ((tU8) 0x7F)

#define  DIA_C_U8_UDS_SID_POS_RESP_MODIFIER                                 ((tU8) 0x40)

// service identifier for internal requests
#define  DIA_C_U8_UDS_SID_DIAG_COMMAND                                      ((tU8) 0xFD)

// Sessions

#define  DIA_C_U8_UDS_SESSION_INVALID                                       ((tU8) 0x00)
#define  DIA_C_U8_UDS_SESSION_DEFAULT                                       ((tU8) 0x01)
#define  DIA_C_U8_UDS_SESSION_PROGRAMMING                                   ((tU8) 0x02)
#define  DIA_C_U8_UDS_SESSION_EXTENDED                                      ((tU8) 0x03)
#define  DIA_C_U8_UDS_SESSION_RBCM_PRODUCTION                               ((tU8) 0x60)
#define  DIA_C_U8_UDS_SESSION_RBCM_ADR                                      ((tU8) 0x61)

// Resets
#define  DIA_C_U8_UDS_RESET_HARD                                            ((tU8) 0x01)
#define  DIA_C_U8_UDS_RESET_KEYONOFF                                        ((tU8) 0x02)
#define  DIA_C_U8_UDS_RESET_SOFT                                            ((tU8) 0x03)
#define  DIA_C_U8_UDS_SHUTDOWN_FAST                                         ((tU8) 0x60)
#define  DIA_C_U8_UDS_RESET_ALTER_SW_TSTMGR_START                           ((tU8) 0x61)
#define  DIA_C_U8_UDS_RESET_DOWNLOAD_START                                  ((tU8) 0x62)
#define  DIA_C_U8_UDS_RESET_ALTER_SW_NAC_TSTSW_START                        ((tU8) 0x63)

// DTC handling

// UDS DTCInformationTypes (subfunction of service $19)
#define UDS_REPORT_NUMBER_OF_DTC_BY_STATUS_MASK                             ((tU8) 0x01)
#define UDS_REPORT_DTC_BY_STATUS_MASK                                       ((tU8) 0x02)
#define UDS_REPORT_DTC_SNAPSHOT_IDENTIFIER                                  ((tU8) 0x03)
#define UDS_REPORT_DTC_SNAPSHOT_RECORD_BY_DTC_NUMBER                        ((tU8) 0x04)
#define UDS_REPORT_DTC_EXTENDED_DATARECORD_BY_DTC_NUMBER                    ((tU8) 0x06)
#define UDS_REPORT_READ_SUPPORTED_DTCS                                      ((tU8) 0x0A)
#define UDS_REPORT_READ_LAST_CONFIRMED_DTC                                  ((tU8) 0x0E)
#define UDS_REPORT_NUMBER_OF_EMISSIONS_RELATED_DTC_BY_STATUS_MASK           ((tU8) 0x12)
#define UDS_REPORT_EMISSIONS_RELATED_DTC_BY_STATUS_MASK                     ((tU8) 0x13)
#define UDS_REPORT_DTC_FAULT_DETECTION_COUNTER                              ((tU8) 0x14)

// 1 byte error codes (see ISO14229 annex A.1)
#define  DIA_E_U8_UDS_GENERAL_REJECT                                        ((tU8) 0x10)
#define  DIA_E_U8_UDS_SERVICE_NOT_SUPPORTED                                 ((tU8) 0x11)
#define  DIA_E_U8_UDS_SUBFUNCTION_NOT_SUPPORTED                             ((tU8) 0x12)
#define  DIA_E_U8_UDS_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT              ((tU8) 0x13)
#define  DIA_E_U8_UDS_BUSY_REPEAT                                           ((tU8) 0x21)
#define  DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT                                ((tU8) 0x22)
#define  DIA_E_U8_UDS_ROUTINE_NOT_COMPLETE                                  ((tU8) 0x23)
#define  DIA_E_U8_UDS_SEQUENCE_ERROR                                        ((tU8) 0x24)
#define  DIA_E_U8_UDS_FAILURE_PREVENTS_EXECUTION_OF_REQUESTED_ACTION        ((tU8) 0x26)
#define  DIA_E_U8_UDS_OUT_OF_RANGE                                          ((tU8) 0x31)
#define  DIA_E_U8_UDS_SECURITY_ACCESS_DENIED                                ((tU8) 0x33)
#define  DIA_E_U8_UDS_INVALID_KEY                                           ((tU8) 0x35)
#define  DIA_E_U8_UDS_EXCEED_NUMBER_OF_ATTEMPTS                             ((tU8) 0x36)
#define  DIA_E_U8_UDS_REQUIRED_TIME_DELAY_NOT_EXPIRED                       ((tU8) 0x37)

#define  DIA_E_U8_UDS_UPLOAD_DOWNLOAD_NOT_ACCEPTED                          ((tU8) 0x70)
#define  DIA_E_U8_UDS_TRANSFER_DATA_SUSPENDED                               ((tU8) 0x71)
#define  DIA_E_U8_UDS_GENERAL_PROGRAMMING_FAILURE                           ((tU8) 0x72)
#define  DIA_E_U8_UDS_WRONG_BLOCK_SEQUENCE_NUMBER                           ((tU8) 0x73)
#define  DIA_E_U8_UDS_RESPONSE_PENDING                                      ((tU8) 0x78)
#define  DIA_E_U8_UDS_SUBFUNCTION_NOT_SUPPORTED_IN_ACTIVE_SESSION           ((tU8) 0x7E)
#define  DIA_E_U8_UDS_SERVICE_NOT_SUPPORTED_IN_ACTIVE_SESSION               ((tU8) 0x7F)
#define  DIA_E_U8_UDS_ENGINE_IS_RUNNING                                     ((tU8) 0x83)
#define  DIA_E_U8_UDS_VEHICLE_SPEED_TOO_HIGH                                ((tU8) 0x88)
#define  DIA_E_U8_UDS_VOLTAGE_TOO_HIGH                                      ((tU8) 0x92)
#define  DIA_E_U8_UDS_VOLTAGE_TOO_LOW                                       ((tU8) 0x93)

#endif /* __INCLUDED_DIA_DEFINES_UDS__ */

