/*!
 * \file       dia_TesterPresentHandler.h
 *
 * \brief      Handling of Tester-Present as Message-Handler of udd-comm-channel
 *
 * \details    
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreUDD
 *
 * \copyright  (c) 2019 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
#ifndef __INCLUDED_DIA_TESTER_PRESENT_HANDLER__
#define __INCLUDED_DIA_TESTER_PRESENT_HANDLER__

#include <unistd.h>
#include <netdb.h>
#include <sys/socket.h>

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_MESSAGEHANDLER__
#include <common/framework/engine/dia_MessageHandler.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SELF_TIMER__
#include "common/framework/application/dia_SelfTimer.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DIAGNOSIS_RESPONSE_LISTENER__
#include <common/interfaces/dia_IDiagnosisResponseListener.h>
#endif

namespace dia {


class TesterPresentHandler :
      public dia_MessageHandler,
      public IDiagnosisResponseListener

{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(TesterPresentHandler) ;
public:
   struct MsgTimeoutS3 {
   };

   //! class TesterPresentHandler
   TesterPresentHandler ( );
   //! class constructor with next hanndler passed
   TesterPresentHandler (dia_MessageHandler* nextHandler );
   //! class destructor
   virtual ~TesterPresentHandler ( void );

   //! method to be implemented by concrete handlers for processing incoming messages. Return value of DIA_SUCCESS indicates that the message was handled within the chain of handlers
   virtual tDiaResult handleMessage ( dia_MessageBuffer& msg );

   //! method called on timeout
   void onTimeout(MsgTimeoutS3 *msg);

   //! overloaded method from class IDiagnosisResponseListener
   virtual tVoid onDiagnosisResponse ( tU8 const *au8MsgBuffer, tU16 u16Length );


protected:
   //! setup method for the application
   virtual tDiaResult setup ( void );
   //! shutdown method for the application
   virtual tDiaResult tearDown ( void );

private:
   //! timeout value for inactive session
   tU32 mS3ValMs;

   //! store if setup() has already run.
   bool mIsSetupDone;

   //! flas to indicate that we are currently in a non-default session
   bool mNonDefaultSessionActive;


   RefCounter mRefCounter;
   SelfTimer<TesterPresentHandler, MsgTimeoutS3> mSelfTimer;

};
}

#endif

