/**
 * \file    dia_ServiceHandlerUDS.h
 *
 * \brief   This file contains the definition of the base class for all kinds of
 *          service handlers using the UDS protocol
 *
 * \author  gib2hi
 * \date    25.04.2012
 */

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#define __INCLUDED_DIA_SERVICE_HANDLER_UDS__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER__
#include "common/framework/engine/dia_ServiceHandler.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#define DIA_C_U32_MAX_PROCESSING_TIME_SERVICE_UDS   ((tU32) 15000)

class diagnostics_tclApp;
class dia_LookupKey;

// handy macro for declarations of derived classes
#define SRVC_HANDLER_UDS_DECL(class, name)   \
protected:                                    \
   class(tCString name)                       \
      : dia_ServiceHandlerUDS(name) {}


#define DECL_SERVICE_HANDLER_METHODS(class)              \
public:                                                   \
   virtual void vOnReqRx ( void );                       \
   virtual void vOnTimeout ( void )


class dia_ServiceHandlerUDS
   : public dia_ServiceHandler
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_ServiceHandlerUDS);

protected:
   //! protected class constructor, because this class is an abstract base class
   dia_ServiceHandlerUDS ( tCString name, tU32 timeoutVal=DIA_C_U32_MAX_PROCESSING_TIME_SERVICE_UDS );
   //! protected class constructor, because this class is an abstract base class
   dia_ServiceHandlerUDS ( tCString name, tU8 sid, tU32 timeoutVal=DIA_C_U32_MAX_PROCESSING_TIME_SERVICE_UDS );
   //! protected class constructor, because this class is an abstract base class
   dia_ServiceHandlerUDS ( tCString name, tU8 sid, tU8 did, tU32 timeoutVal=DIA_C_U32_MAX_PROCESSING_TIME_SERVICE_UDS );
   //! protected class constructor, because this class is an abstract base class
   dia_ServiceHandlerUDS ( tCString name, tU8 sid, tU16 did, tU32 timeoutVal=DIA_C_U32_MAX_PROCESSING_TIME_SERVICE_UDS );
   //! deprecated copy constructor (no implementation)
   dia_ServiceHandlerUDS ( const dia_ServiceHandlerUDS& );
   //! deprecated assignment operator (no implementation)
   dia_ServiceHandlerUDS& operator = ( const dia_ServiceHandlerUDS& );
   //! protected class constructor, because this class is an abstract base class
   virtual ~dia_ServiceHandlerUDS ( void );

public:
   //! default implementation for timeout notifications (initiates negative response 0x22)
   virtual void vOnTimeout ( void );
   //! return SID of the request handled by this handler
   virtual tU8  getSID ( void ) const;
   //! return DID of the request handled by this handler
   virtual tU16 getDID ( void ) const;

   //! setup a lookup key for the lookup table
   virtual tDiaResult makeLookupKeys ( std::vector<dia_LookupKey*>& keys );

protected:
   //! create and send a negative response
   void vSendNegativeResponse ( tU8 errCode ) const;

   //! set a new length of response (length doesn't contain length byte), get data from msg buffer, overwrite this data by <dataToAppend> if its length is less than or equal to msg buffer length.
   //! At the end create and send positive response.
   void vSendPositiveResponse ( tU16 length, std::vector<tU8>* dataToAppend = 0 ) const;
   //! This method returns a reference to the currently active diag msg buffer object
   dia_MessageBuffer& oDiagMsgBuffer ( void ) const;

   void vResReadyAndQuit ( void ) const;

protected:
   //! service identifier of the associated diagnosis request
   tU8  mSID;
   //! data identifier of the associated diagnosis request
   tU16 mDID;
   //! length of the DID
   tU16 mDIDLen;
};

#endif /* __INCLUDED_DIA_SERVICE_HANDLER_UDS__ */
